/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.changemodel;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.taxc.bdtaxr.business.changemodel.ChangeModelBusiness;
import kd.taxc.bdtaxr.business.changemodel.ChangeResumeBusiness;
import kd.taxc.bdtaxr.business.changemodel.XBillBusiness;
import kd.taxc.bdtaxr.common.enums.changemodel.BizChangeStatusEnum;
import kd.taxc.bdtaxr.formplugin.changemodel.helper.SrcBillChangeHelper;

public class SrcBillChangeListPlugin
extends AbstractListPlugin {
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";
    private static final String JUMP = "jump";

    public void packageData(PackageDataEvent evt) {
        String colkey;
        if (evt.getSource() instanceof AbstractColumnDesc && "changestatus".equalsIgnoreCase(colkey = ((AbstractColumnDesc)evt.getSource()).getKey()) && (evt.getFormatValue() == null || !BizChangeStatusEnum.CHANGING.getValue().equalsIgnoreCase(evt.getFormatValue().toString()))) {
            evt.getNoLinkKey().add(((ColumnDesc)evt.getSource()).getKey());
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("changestatus".equals(fieldName)) {
            args.setCancel(true);
            IListView listview = (IListView)this.getView();
            String srcBillEntity = listview.getListModel().getDataEntityType().getName();
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            Long pkv = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
            DynamicObject xbill = XBillBusiness.getOnWayXBill(pkv, srcBillEntity);
            if (xbill != null) {
                BillShowParameter fsp = new BillShowParameter();
                fsp.setFormId(xbill.getDataEntityType().getName());
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                fsp.setPkId(xbill.get("id"));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, JUMP);
                fsp.setCloseCallBack(closeCallBack);
                DynamicObject changeModel = ChangeModelBusiness.getChangeModel4SrcBill(srcBillEntity);
                if (changeModel != null) {
                    Map<String, Map<String, String>> XBillEntryAndOp = ChangeModelBusiness.getXBillEntryAndOp(changeModel);
                    String status = XBillEntryAndOp.get("_bill").get("status");
                    if ("A".equalsIgnoreCase(xbill.getString(status))) {
                        fsp.setStatus(OperationStatus.EDIT);
                    } else {
                        fsp.setStatus(OperationStatus.VIEW);
                    }
                }
                this.getView().showForm((FormShowParameter)fsp);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"SrcBillChangeListPlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (JUMP.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getListSelectedData() == null || args.getListSelectedData().size() == 0) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        if (operate.getOperateKey().equals("bizchange")) {
            if (args.getListSelectedData().getPrimaryKeyValues().length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u53d8\u66f4\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"SrcBillChangeListPlugin_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            RefObject afterConfirm = new RefObject();
            if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bizchange", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u8981\u5bf9\u5f53\u524d\u5355\u636e\u8fdb\u884c\u53d8\u66f4?", (String)"SrcBillChangeListPlugin_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals("bizchange") && evt.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            this.getView().invokeOperation("bizchange", operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IListView listview = (IListView)this.getView();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            String srcBillEntity;
            DynamicObject changeModel;
            if (args.getOperateKey().equals("bizchange")) {
                OperationResult opRes = args.getOperationResult();
                List billPks = opRes.getSuccessPkIds();
                if (!billPks.isEmpty()) {
                    String srcBillEntity2 = listview.getListModel().getDataEntityType().getName();
                    DynamicObject xbill = XBillBusiness.getOnWayXBill((Long)billPks.get(0), srcBillEntity2);
                    if (xbill != null) {
                        BillShowParameter fsp = new BillShowParameter();
                        fsp.setFormId(xbill.getDataEntityType().getName());
                        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        fsp.setPkId(xbill.get("id"));
                        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, JUMP);
                        fsp.setStatus(OperationStatus.EDIT);
                        fsp.setCloseCallBack(closeCallBack);
                        this.getView().showForm((FormShowParameter)fsp);
                    }
                }
            } else if (args.getOperateKey().equals("bizchangeresume")) {
                List successbillids = args.getOperationResult().getSuccessPkIds();
                if (successbillids.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u770b\u53d8\u66f4\u8be6\u60c5\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"SrcBillChangeListPlugin_3", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                } else if (successbillids.size() == 1) {
                    long srcbillid = (Long)successbillids.get(0);
                    DynamicObject changeRecord = ChangeResumeBusiness.getChangeResumeBySrcBillId(srcbillid);
                    if (changeRecord != null) {
                        String srcBillEntity3 = listview.getListModel().getDataEntityType().getName();
                        Optional<String> result = SrcBillChangeHelper.checkPermission4SrcChangeResume(srcbillid, srcBillEntity3);
                        if (result.isPresent()) {
                            this.getView().showErrorNotification(result.get());
                        } else {
                            FormShowParameter changeResume = new FormShowParameter();
                            changeResume.setFormId("bdtaxr_changeresumeform");
                            changeResume.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                            changeResume.setStatus(OperationStatus.VIEW);
                            changeResume.setCustomParam("srcbillid", (Object)srcbillid);
                            changeResume.setCustomParam("srcbillno", changeRecord.get("srcbillno"));
                            changeResume.setCustomParam("srcbillentity", changeRecord.get("srcbillentity"));
                            this.getView().showForm(changeResume);
                        }
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5b9e\u9645\u53d1\u751f\u7684\u53d8\u66f4\u6570\u636e\uff0c\u6682\u672a\u8bb0\u5f55\u53d8\u66f4\u8be6\u60c5\u4fe1\u606f\u3002", (String)"SrcBillChangeListPlugin_4", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                    }
                }
            } else if (args.getOperateKey().equals("bizchangelist") && (changeModel = ChangeModelBusiness.getChangeModel4SrcBill(srcBillEntity = listview.getListModel().getDataEntityType().getName())) != null && changeModel.getDynamicObject("xbill") != null) {
                String xBillEntityID = changeModel.getDynamicObject("xbill").getString("id");
                ListShowParameter fsp = new ListShowParameter();
                fsp.setBillFormId(xBillEntityID);
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, JUMP);
                fsp.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)fsp);
            }
        }
    }
}

