/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.changemodel;

import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.business.changemodel.ChangeModelBusiness;
import kd.taxc.bdtaxr.business.changemodel.ChangeResumeBusiness;
import kd.taxc.bdtaxr.business.changemodel.XBillBusiness;
import kd.taxc.bdtaxr.common.enums.changemodel.BizChangeStatusEnum;
import kd.taxc.bdtaxr.common.utils.ChangeModelUtil;

public class XBillChangeListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List listFilter = e.getQFilters();
        QFilter f = new QFilter("changestatus", "!=", (Object)BizChangeStatusEnum.INITED.getValue());
        listFilter.add(f);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        ListSelectedRowCollection listSelectRows = args.getListSelectedData();
        if (this.isListSelectedDataNull(listSelectRows)) {
            return;
        }
        if (listSelectRows.size() > 0) {
            switch (operate.getOperateKey()) {
                case "submit": 
                case "unsubmit": 
                case "audit": 
                case "unaudit": 
                case "bizvalid": {
                    DynamicObject changeModel;
                    if (ChangeModelUtil.isNull(operate.getEntityId()) || (changeModel = ChangeModelBusiness.getChangeModel4XBill(operate.getEntityId())) != null) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6ca1\u6709\u542f\u7528\u7684\u53d8\u66f4\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u670d\u52a1\u4eba\u5458\u7ef4\u62a4\u53d8\u66f4\u65b9\u6848\u6570\u636e\u3002", (String)"XBillChangeListPlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("sourcebillno".equals(fieldName)) {
            args.setCancel(true);
            IListView listview = (IListView)this.getView();
            String xBillEntity = listview.getListModel().getDataEntityType().getName();
            DynamicObject changeModel = ChangeModelBusiness.getChangeModel4XBill(xBillEntity);
            if (changeModel != null && changeModel.getDynamicObject("srcbill") != null) {
                String srcBillEntityID = changeModel.getDynamicObject("srcbill").getString("id");
                BillList list = (BillList)this.getControl("billlistap");
                ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
                Long pkv = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
                DynamicObject xbill = XBillBusiness.getXbillById(pkv, xBillEntity);
                if (xbill != null) {
                    BillShowParameter fsp = new BillShowParameter();
                    fsp.setFormId(srcBillEntityID);
                    fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    fsp.setPkId(xbill.get("sourcebillid"));
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "jump");
                    fsp.setCloseCallBack(closeCallBack);
                    fsp.setStatus(OperationStatus.VIEW);
                    this.getView().showForm((FormShowParameter)fsp);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (operate.getOperateKey().equals("bizchangeresume")) {
            List successbillids = args.getOperationResult().getSuccessPkIds();
            if (successbillids.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u5f20\u5355\u636e\u67e5\u770b\u53d8\u66f4\u8be6\u60c5\uff0c\u8bf7\u9009\u62e91\u5f20\u5355\u636e\u3002", (String)"XBillChangeListPlugin_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            } else if (successbillids.size() == 1) {
                long xBillID = (Long)successbillids.get(0);
                DynamicObject changerecord = ChangeResumeBusiness.getChangeResumeByXBillId(xBillID);
                if (changerecord != null) {
                    FormShowParameter changeResume = new FormShowParameter();
                    changeResume.setFormId("bdtaxr_changeresumeform");
                    changeResume.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    changeResume.setStatus(OperationStatus.VIEW);
                    changeResume.setCustomParam("srcbillid", changerecord.get("srcbillid"));
                    changeResume.setCustomParam("srcbillno", changerecord.get("srcbillno"));
                    changeResume.setCustomParam("srcbillentity", changerecord.get("srcbillentity"));
                    changeResume.setCustomParam("xbillid", (Object)xBillID);
                    this.getView().showForm(changeResume);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5b9e\u9645\u5f55\u5165\u53d8\u66f4\u6570\u636e\uff0c\u6682\u672a\u8bb0\u5f55\u53d8\u66f4\u5c65\u5386\u4fe1\u606f\u3002", (String)"XBillChangeListPlugin_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                }
            }
        }
    }

    private boolean isListSelectedDataNull(ListSelectedRowCollection listSelectRows) {
        return listSelectRows == null || listSelectRows.size() < 1;
    }
}

