/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.changemodel.helper;

import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.taxc.bdtaxr.business.changemodel.ChangeModelBusiness;
import kd.taxc.bdtaxr.business.changemodel.CommonDataBusiness;
import org.apache.commons.lang3.StringUtils;

public class SrcBillChangeHelper {
    private static final String PERMISSION_VIEW = "47150e89000000ac";

    public static Optional<String> checkPermission4SrcChangeResume(Long srcid, String entityId) {
        DynamicObject changeModel = ChangeModelBusiness.getChangeModel4SrcBill(entityId);
        if (changeModel == null) {
            return Optional.empty();
        }
        String xbilldtstr = "";
        if (changeModel.getDynamicObject("xbill") == null || changeModel.getDynamicObject("xbill").getPkValue() == null) {
            return Optional.empty();
        }
        xbilldtstr = (String)changeModel.getDynamicObject("xbill").getPkValue();
        Map<String, Map<String, String>> params = ChangeModelBusiness.getXBillEntryAndOp(changeModel);
        String orgField = params.get("_bill").get("org");
        String appId = EntityMetadataCache.getDataEntityType((String)xbilldtstr).getAppId();
        DynamicObject srcObj = CommonDataBusiness.loadSingle(srcid, entityId);
        if (srcObj != null) {
            boolean hasPermission = false;
            if (StringUtils.isNotBlank((CharSequence)orgField)) {
                Long orgId = srcObj.getDynamicObject(orgField).getLong("id");
                int result = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (Long)orgId, (String)appId, (String)xbilldtstr, (String)PERMISSION_VIEW);
                hasPermission = result == 1;
            } else {
                hasPermission = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)appId, (String)xbilldtstr, (String)PERMISSION_VIEW);
            }
            if (!hasPermission) {
                String billName = EntityMetadataCache.getDataEntityType((String)xbilldtstr).getDisplayName().toString();
                String msg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SrcBillChangeHelper_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), billName);
                return Optional.of(msg);
            }
        }
        return Optional.empty();
    }
}

