/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.declare.tsate;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.fileservice.utils.ExceptionUtil;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.helper.tsate.DirectDeclareServiceHelper;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.declare.tsate.TsateBaseDeclarePlugin;

public class DirectDeclarePlugin
extends TsateBaseDeclarePlugin {
    private static Log LOGGER = LogFactory.getLog(DirectDeclarePlugin.class);
    private static final String BTN_DIRECTEDECLARE = "btn_directdeclare";
    private static final String CONFIRMKEY_RISK = "risk_confirm";
    private static final String CONFIRMKEY_DECLARE = "declare_confirm";
    private static final String CONFIRMKEY_DIALOG = "dialog_confirm";
    private static final String CHECK_REQUEST = "check_requestid";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals(BTN_DIRECTEDECLARE)) {
            this.declareOperation(this.getDeclareIds());
        }
    }

    private void declareOperation(List<Long> declareIds) {
        if (!this.checkTsateLicense()) {
            return;
        }
        if (!this.validSelected(declareIds)) {
            return;
        }
        List<DynamicObject> declareDyns = this.getSelectedDataCompatible(declareIds);
        if (!this.needContinue(declareDyns).booleanValue()) {
            return;
        }
        String checkRequestId = RequestContext.get().getRequestId();
        this.validateDeclare(declareDyns, checkRequestId);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (!(CONFIRMKEY_DECLARE.equals(callBackId) || CONFIRMKEY_RISK.equals(callBackId) || CONFIRMKEY_DIALOG.equals(callBackId))) {
            return;
        }
        if (event.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String customVaule = event.getCustomVaule();
        JSONObject jsonObject = JSONObject.parseObject((String)customVaule);
        List ids = (List)jsonObject.get((Object)"declarePkIds");
        String checkRequestId = jsonObject.getString(CHECK_REQUEST);
        List<DynamicObject> declares = this.getSelectedDataCompatible(ids);
        if (CONFIRMKEY_DECLARE.equals(callBackId)) {
            this.sendTask(declares);
            String controlKey = this.getListControlKey();
            if (StringUtil.isNotBlank((CharSequence)controlKey)) {
                BillList billlist = (BillList)this.getControl(controlKey);
                billlist.refresh();
            }
        } else if (CONFIRMKEY_RISK.equals(callBackId)) {
            this.setCheckedPassed(checkRequestId, CONFIRMKEY_RISK);
            this.validateDeclare(declares, checkRequestId);
        } else if (CONFIRMKEY_DIALOG.equals(callBackId)) {
            DirectDeclareServiceHelper.setDialogStatus(ids, "3");
            this.setCheckedPassed(checkRequestId, CONFIRMKEY_DIALOG);
            this.validateDeclare(declares, checkRequestId);
        }
    }

    private void confirmRisk(List<Long> pkIds, BigDecimal ybtse, String riskMsg, String checkRequestId) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMKEY_RISK, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"DirectDeclarePlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"DirectDeclarePlugin_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        HashMap<String, Object> customValueMap = new HashMap<String, Object>();
        customValueMap.put("declarePkIds", pkIds);
        customValueMap.put("ybtse", ybtse.toString());
        customValueMap.put(CHECK_REQUEST, checkRequestId);
        this.getView().showConfirm(riskMsg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, SerializationUtils.toJsonString(customValueMap));
    }

    private void confirmMoney(List<Long> pkIds, BigDecimal ybtse) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMKEY_DECLARE, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"DirectDeclarePlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"DirectDeclarePlugin_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        HashMap<String, Object> customValueMap = new HashMap<String, Object>();
        customValueMap.put("declarePkIds", pkIds);
        customValueMap.put("ybtse", ybtse.toString());
        String moneryMsg = String.format(ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u4e2d%1$s\u4efd\u7533\u62a5\u8868\uff0c\u5e94\u4ea4\u7a0e\u91d1\u5408\u8ba1%2$s\uff0c\u53d1\u9001\u7533\u62a5\u540e\u65e0\u6cd5\u64a4\u9500\uff0c\u786e\u5b9a\u7533\u62a5\u5417\uff1f", (String)"DirectDeclarePlugin_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), pkIds.size(), ybtse.setScale(2, 4));
        this.getView().showConfirm(moneryMsg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, SerializationUtils.toJsonString(customValueMap));
    }

    private void confirmDialog(List<Long> pkIds, BigDecimal ybtse, String dialogMsg, String checkRequestId) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMKEY_DIALOG, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"DirectDeclarePlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"DirectDeclarePlugin_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        HashMap<String, Object> customValueMap = new HashMap<String, Object>();
        customValueMap.put("declarePkIds", pkIds);
        customValueMap.put("ybtse", ybtse.toString());
        customValueMap.put(CHECK_REQUEST, checkRequestId);
        this.getView().showConfirm(dialogMsg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, SerializationUtils.toJsonString(customValueMap));
    }

    private void validateDeclare(List<DynamicObject> declareDyns, String checkRequestId) {
        List<Map<String, Object>> riskInfos;
        BigDecimal totalBqybtse = BigDecimal.valueOf(0.0);
        ArrayList<Long> declarePkIds = new ArrayList<Long>(8);
        for (DynamicObject declare : declareDyns) {
            totalBqybtse = totalBqybtse.add(declare.getBigDecimal("bqybtse"));
            declarePkIds.add(declare.getLong("id"));
        }
        try {
            riskInfos = DirectDeclareServiceHelper.validateDeclareData(declarePkIds).getData();
        }
        catch (Exception e) {
            LOGGER.error("DirectDeclareServiceHelper.validateDeclareData\uff1aerror={} ", (Object)ExceptionUtil.toString((Throwable)e));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"TsateBaseDeclarePlugin_6", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> failList = new ArrayList<String>(8);
        ArrayList<String> riskList = new ArrayList<String>(8);
        ArrayList<String> dialogList = new ArrayList<String>(8);
        for (Map<String, Object> info : riskInfos) {
            Boolean isRisk = (Boolean)info.get("isrisk");
            String riskMsg = (String)info.get("riskmsg");
            Boolean isfail = (Boolean)info.get("isfail");
            String failMsg = (String)info.get("failmsg");
            Boolean isdialog = (Boolean)info.get("isdialog");
            String dialogMsg = (String)info.get("dialogmsg");
            if (isRisk.booleanValue()) {
                riskList.add(riskMsg);
            }
            if (isfail.booleanValue()) {
                failList.add(failMsg);
            }
            if (!isdialog.booleanValue()) continue;
            dialogList.add(dialogMsg);
        }
        if (failList.size() > 0) {
            this.showTip("", failList);
            return;
        }
        if (riskList.size() > 0 && !this.getCheckedIfPassed(checkRequestId, CONFIRMKEY_RISK)) {
            StringBuilder riskDetail = new StringBuilder();
            for (String msg : riskList) {
                riskDetail.append(msg).append(SEPARATOR);
            }
            this.confirmRisk(declarePkIds, totalBqybtse, riskDetail.toString(), checkRequestId);
            return;
        }
        if (dialogList.size() > 0 && !this.getCheckedIfPassed(checkRequestId, CONFIRMKEY_DIALOG)) {
            StringBuilder dialogDetail = new StringBuilder();
            for (String msg : dialogList) {
                dialogDetail.append(msg).append(SEPARATOR);
            }
            this.confirmDialog(declarePkIds, totalBqybtse, dialogDetail.toString(), checkRequestId);
            return;
        }
        this.confirmMoney(declarePkIds, totalBqybtse);
    }

    private void sendTask(List<DynamicObject> declares) {
        List<Map<String, Object>> executeInfos;
        List<Long> declareIds = declares.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        try {
            executeInfos = DirectDeclareServiceHelper.sendTask(declareIds).getData();
        }
        catch (Exception e) {
            LOGGER.error("DirectDeclareServiceHelper.sendTask\uff1aerror={} ", (Object)ExceptionUtil.toString((Throwable)e));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"TsateBaseDeclarePlugin_6", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            return;
        }
        int totalSize = executeInfos.size();
        int failSize = 0;
        ArrayList<String> faildetail = new ArrayList<String>();
        for (Map<String, Object> info : executeInfos) {
            Boolean isfail = (Boolean)info.get("isfail");
            if (!isfail.booleanValue()) continue;
            ++failSize;
            String failmsg = (String)info.get("failmsg");
            faildetail.add(failmsg);
        }
        this.showTaskInfo(totalSize, totalSize - failSize, failSize, ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a\u672a\u914d\u7f6e\u901a\u9053\u7684\u8bb0\u5f55\u65e0\u6cd5\u652f\u6301\u76f4\u8fde\u7533\u62a5", (String)"DirectDeclarePlugin_4", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), faildetail);
    }

    private boolean getCheckedIfPassed(String requestId, String checkKey) {
        String key = requestId + "_" + checkKey;
        String ifPassed = this.getPageCache().get(key);
        return "passed".equals(ifPassed);
    }

    private void setCheckedPassed(String requestId, String checkKey) {
        String key = requestId + "_" + checkKey;
        this.getPageCache().put(key, "passed");
    }
}

