/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.declare.tsate;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.helper.tsate.SchedulePayServiceHelper;
import kd.taxc.bdtaxr.formplugin.declare.tsate.TsateBaseDeclarePlugin;

public class ScheduledPayPlugin
extends TsateBaseDeclarePlugin {
    private static final String BTN_YYJK = "btn_yyjk";
    private static final String BTN_CANCELYYJK = "btn_cancelyyjk";
    private static Log LOGGER = LogFactory.getLog(ScheduledPayPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals(BTN_YYJK)) {
            this.yyOperation();
        } else if (afterDoOperationEventArgs.getOperateKey().equals(BTN_CANCELYYJK)) {
            this.cancelYyOperation();
        }
    }

    private void yyOperation() {
        if (!this.checkTsateLicense()) {
            return;
        }
        ArrayList<Long> declareIds = new ArrayList<Long>(8);
        if (!this.validSelected(declareIds)) {
            return;
        }
        Map<Long, String> validateInfos = SchedulePayServiceHelper.validateYyjk(declareIds).getData();
        if (validateInfos.size() > 0) {
            ArrayList<String> erros = new ArrayList<String>(8);
            erros.addAll(validateInfos.values());
            this.showTip(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"ScheduledPayPlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), erros);
            return;
        }
        this.confirmPayDate();
    }

    private void cancelYyOperation() {
        if (!this.checkTsateLicense()) {
            return;
        }
        ArrayList<Long> declareIds = new ArrayList<Long>(8);
        if (!this.validSelected(declareIds)) {
            return;
        }
        Map<Long, String> validateInfos = SchedulePayServiceHelper.validateCancelYyjk(declareIds).getData();
        if (validateInfos.size() > 0) {
            ArrayList<String> erros = new ArrayList<String>(8);
            erros.addAll(validateInfos.values());
            this.showTip(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"ScheduledPayPlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), erros);
            return;
        }
        this.cancelYyjk(declareIds);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.refresh();
    }

    public void afterBindData(EventObject e) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (closedCallBackEvent.getActionId().equals("payDateConfirm")) {
            Date payDate = (Date)closedCallBackEvent.getReturnData();
            if (payDate == null) {
                return;
            }
            ListSelectedRowCollection list = billList.getSelectedRows();
            Object[] pkIds = list.getPrimaryKeyValues();
            ArrayList<Long> ids = new ArrayList<Long>(8);
            for (Object id : pkIds) {
                if (!(id instanceof Long)) continue;
                ids.add((Long)id);
            }
            this.confirmPay(ids, payDate);
        }
        billList.refresh();
    }

    private void btnSetting() {
        List<Long> orgIds = this.getOrgFromFilter();
        boolean support = SchedulePayServiceHelper.support(orgIds).getData();
        this.getView().setVisible(Boolean.valueOf(support), new String[]{BTN_YYJK, BTN_CANCELYYJK});
    }

    private void cancelYyjk(List<Long> declareIds) {
        List<Map<String, Object>> executeInfos = SchedulePayServiceHelper.sendCancelYyjkTask(declareIds).getData();
        int totalSize = executeInfos.size();
        int failSize = 0;
        ArrayList<String> faildetail = new ArrayList<String>();
        for (Map<String, Object> info : executeInfos) {
            Boolean isfail = (Boolean)info.get("isfail");
            if (!isfail.booleanValue()) continue;
            ++failSize;
            String failmsg = (String)info.get("failmsg");
            faildetail.add(failmsg);
        }
        this.showTaskInfo(totalSize, totalSize - failSize, failSize, null, faildetail);
    }

    private void confirmPayDate() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("tsate_paydate_confirm");
        param.getOpenStyle().setShowType(ShowType.NonModal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payDateConfirm");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private void confirmPay(List<Long> declareIds, Date payDate) {
        List<Map<String, Object>> executeInfos = SchedulePayServiceHelper.sendYyjkTask(declareIds, payDate).getData();
        int totalSize = executeInfos.size();
        int failSize = 0;
        ArrayList<String> faildetail = new ArrayList<String>();
        for (Map<String, Object> info : executeInfos) {
            Boolean isfail = (Boolean)info.get("isfail");
            if (!isfail.booleanValue()) continue;
            ++failSize;
            String failmsg = (String)info.get("failmsg");
            faildetail.add(failmsg);
        }
        this.showTaskInfo(totalSize, totalSize - failSize, failSize, "", faildetail);
    }
}

