/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.declare.tsate;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.utils.ExceptionUtil;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.helper.tsate.SyncCancelStatusServiceHelper;
import kd.taxc.bdtaxr.formplugin.declare.tsate.CancelDeclarePlugin;
import kd.taxc.bdtaxr.formplugin.declare.tsate.TsateBaseDeclarePlugin;

public class SyncCancelStatusPlugin
extends TsateBaseDeclarePlugin {
    private static final String BTN_SYNCUNDO = "btn_refreshstatus";
    private static Log LOGGER = LogFactory.getLog(CancelDeclarePlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals(BTN_SYNCUNDO)) {
            this.syncOperation();
        }
    }

    private void syncOperation() {
        if (!this.checkTsateLicense()) {
            return;
        }
        ArrayList<Long> declareIds = new ArrayList<Long>(8);
        if (!this.validSelected(declareIds)) {
            return;
        }
        List<DynamicObject> declareDyns = this.getSelectedDataCompatible(declareIds);
        if (!this.validateData(declareDyns)) {
            return;
        }
        this.cancelStatus(declareDyns);
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.refresh();
    }

    public void afterBindData(EventObject e) {
    }

    private boolean validateData(List<DynamicObject> declares) {
        ArrayList<Long> declareIds = new ArrayList<Long>(8);
        for (DynamicObject declare : declares) {
            declareIds.add(declare.getLong("id"));
        }
        Map<Long, String> validateInfos = SyncCancelStatusServiceHelper.validateSyncData(declareIds).getData();
        if (validateInfos.size() > 0) {
            ArrayList<String> erros = new ArrayList<String>(8);
            erros.addAll(validateInfos.values());
            this.showTip(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"SyncCancelStatusPlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), erros);
            return false;
        }
        return true;
    }

    private void btnSetting() {
        List<Long> orgIds = this.getOrgFromFilter();
        boolean support = SyncCancelStatusServiceHelper.support(orgIds).getData();
        this.getView().setVisible(Boolean.valueOf(support), new String[]{BTN_SYNCUNDO});
    }

    private void cancelStatus(List<DynamicObject> declares) {
        this.senTask(declares);
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.refresh();
    }

    private void senTask(List<DynamicObject> declares) {
        List<Map<String, Object>> executeInfos;
        List<Long> declareIds = declares.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        try {
            executeInfos = SyncCancelStatusServiceHelper.sendTask(declareIds).getData();
        }
        catch (Exception e) {
            LOGGER.error("SyncCancelStatusServiceHelper.sendTask erro={}", (Object)ExceptionUtil.toString((Throwable)e));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"TsateBaseDeclarePlugin_6", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            return;
        }
        int totalSize = executeInfos.size();
        int failSize = 0;
        ArrayList<String> faildetail = new ArrayList<String>();
        for (Map<String, Object> info : executeInfos) {
            Boolean isfail = (Boolean)info.get("isfail");
            if (!isfail.booleanValue()) continue;
            ++failSize;
            String failmsg = (String)info.get("failmsg");
            faildetail.add(failmsg);
        }
        this.showTaskInfo(totalSize, totalSize - failSize, failSize, ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a\u672a\u914d\u7f6e\u7533\u62a5\u901a\u9053\u7684\u8bb0\u5f55\u65e0\u6cd5\u6267\u884c\u540c\u6b65\u7a0e\u5c40\u4f5c\u5e9f\u72b6\u6001", (String)"SyncCancelStatusPlugin_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), faildetail);
    }
}

