/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.declare.tsate;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tsate.SzyhPlatformServiceHelper;
import kd.taxc.bdtaxr.formplugin.declare.tsate.TsateBaseDeclarePlugin;

public class SzyhPlatformPlguin
extends TsateBaseDeclarePlugin {
    private static final String BTN_YHPT = "btn_szyhplatform";
    private static final Log LOGGER = LogFactory.getLog(SzyhPlatformPlguin.class);

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals(BTN_YHPT)) {
            this.redirectSzyhPlatform();
        }
    }

    public void afterBindData(EventObject e) {
    }

    private void redirectSzyhPlatform() {
        if (!this.checkTsateLicense()) {
            return;
        }
        Long userId = RequestContext.get().getCurrUserId();
        TaxResult<String> result = SzyhPlatformServiceHelper.getSzyhPlatformUrl(userId);
        if (result.isSuccess()) {
            String url = result.getData();
            LOGGER.info(String.format("szyh redirect url: %s", url));
            if (url == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u6210\u529f\u83b7\u53d6\u5230\u795e\u5dde\u4e91\u5408\u8df3\u8f6c\u5730\u5740\u3002", (String)"SzyhPlatformPlguin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                return;
            }
            this.getView().openUrl(url);
        } else {
            this.getView().showErrorNotification(result.getMessage());
        }
    }

    private void btnSetting() {
        List<Long> orgIds = this.getOrgFromFilter();
        boolean support = SzyhPlatformServiceHelper.support(orgIds).getData();
        this.getView().setVisible(Boolean.valueOf(support), new String[]{BTN_YHPT});
    }
}

