/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.prescripted;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.enums.prescripted.DeployStatusEnum;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;

public class PreScriptedFormPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(PreScriptedFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit textEdit = (TextEdit)this.getControl("filename");
        textEdit.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initControls();
    }

    private void initControls() {
        BillShowParameter bsp = (BillShowParameter)this.getView().getFormShowParameter();
        if (bsp.getStatus() == OperationStatus.ADDNEW) {
            return;
        }
        DynamicObject obj = this.getModel().getDataEntity(true);
        Long executeTime = obj.getLong("executetime");
        if (executeTime != null && executeTime != 0L) {
            String executeTime_text = DateUtils.formatTime(executeTime);
            this.getModel().setValue("executetime_text", (Object)executeTime_text);
        }
        DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
        Long executeTime_entry = null;
        DynamicObject entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (DynamicObject)entries.get(i);
            executeTime_entry = entry.getLong("executetime_entry");
            if (executeTime_entry == null || executeTime_entry == 0L) continue;
            String executeTime_entrytext = DateUtils.formatTime(executeTime_entry);
            this.getModel().setValue("executetime_entrytext", (Object)executeTime_entrytext, i);
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((FormOperate)args.getSource()).getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)"delentry", (CharSequence)key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", entryGrid.getEntryState().getFocusRow());
            if (!DeployStatusEnum.UNDEPLOY.getValue().equals(entry.getString("deploystatus_entry"))) {
                String msg = ResManager.loadKDString((String)"\u53ea\u6709\u90e8\u7f72\u72b6\u6001\u4e3a\u672a\u90e8\u7f72\u7684\u6570\u636e\u53ef\u4ee5\u5220\u9664", (String)"PreScriptedFormPlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"filename")) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bdtaxr_fileupload");
            StyleCss css = new StyleCss();
            css.setWidth("500px");
            css.setHeight("200px");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setShowTitle(false);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "filename");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)"filename")) {
            Map data = (Map)closedCallBackEvent.getReturnData();
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int focusRow = entryGrid.getEntryState().getFocusRow();
            if (!ObjectUtils.isEmpty((Object)data)) {
                this.getModel().setValue("filename", data.get("name"), focusRow);
                this.getModel().setValue("filepath", data.get("url"), focusRow);
            }
        }
    }
}

