/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.changemodel;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.business.changemodel.ChangeResumeBusiness;
import kd.taxc.bdtaxr.business.changemodel.SrcBillBusiness;
import kd.taxc.bdtaxr.business.changemodel.XBillBusiness;
import kd.taxc.bdtaxr.business.changemodel.helper.FieldKeysHelper;
import kd.taxc.bdtaxr.common.utils.ChangeModelUtil;
import kd.taxc.bdtaxr.opplugin.changemodel.SrcBillBizChangeOpValidator;

public class SrcBillBizChangeOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SrcBillBizChangeOpValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        if (this.billEntityType != null) {
            e.getFieldKeys().addAll(FieldKeysHelper.getFieldKeys4BizChange(this.billEntityType.getName()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        if ("bizchange".equals(e.getOperationKey())) {
            DynamicObject[] bills = e.getDataEntities();
            if (ChangeModelUtil.isNull(bills)) {
                return;
            }
            SrcBillBusiness.updateSrcBillStatus(bills);
            DynamicObject[] xBills = XBillBusiness.generateXBill(bills);
            ChangeResumeBusiness.saveZeroChangeResume(xBills);
            if (!ChangeModelUtil.isNull(xBills)) {
                this.getOperationResult().setSuccess(true);
                String xBillEntityID = xBills[0].getDataEntityType().getName();
                this.getOption().setVariableValue("xBillEntityID", xBillEntityID);
            }
        }
    }
}

