/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.prescripted;

import java.util.ArrayList;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.prescripted.PreScriptedFileBusiness;
import kd.taxc.bdtaxr.common.enums.prescripted.DeployStatusEnum;

public class PreScriptedDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PreScriptedDeleteOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("deploystatus");
        e.getFieldKeys().add("deploycount");
        e.getFieldKeys().add("ispreset");
        e.getFieldKeys().add("scriptedtype");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.bizobj");
        e.getFieldKeys().add("bizapp");
        e.getFieldKeys().add("bizapp.bizcloud");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                DynamicObject obj = null;
                for (ExtendedDataEntity entity : this.getDataEntities()) {
                    obj = entity.getDataEntity();
                    Optional result = PreScriptedDeleteOp.this.checkInfoVoild(obj);
                    if (!result.isPresent()) continue;
                    this.addFatalErrorMessage(entity, (String)result.get());
                }
            }
        });
    }

    private Optional<String> checkInfoVoild(DynamicObject obj) {
        if (obj.getBoolean("ispreset")) {
            String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u9884\u8bbe\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PreScriptedDeleteOp_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), obj.getString("name"));
            return Optional.of(msg);
        }
        if (!DeployStatusEnum.UNDEPLOY.getValue().equals(obj.getString("deploystatus"))) {
            String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u6709\u90e8\u7f72\u72b6\u6001\u4e3a\u672a\u90e8\u7f72\u7684\u6570\u636e\u53ef\u4ee5\u5220\u9664\u3002", (String)"PreScriptedDeleteOp_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), obj.getString("name"));
            return Optional.of(msg);
        }
        return Optional.empty();
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] objects = e.getDataEntities();
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>(10);
        for (DynamicObject obj : objects) {
            try {
                PreScriptedFileBusiness.deletePreScriptedFile(obj.getLong("id"));
                successObjs.add(obj);
            }
            catch (KDBizException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
                this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(obj, e1.getMessage()));
            }
            catch (Exception e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
                String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u6587\u4ef6\u5220\u9664\u5931\u8d25\u3002", (String)"PreScriptedDeleteOp_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), obj.getString("name"));
                this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(obj, msg));
            }
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }

    private ValidationErrorInfo buildErrMessage(DynamicObject obj, String msg) {
        Object pkId = obj.getPkValue();
        int dataIndex = 0;
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "errorcode001", "", msg, errorLevel);
        return info;
    }
}

