/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.prescripted;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.prescripted.PreScriptedBusiness;
import kd.taxc.bdtaxr.common.enums.prescripted.DeployStatusEnum;

public class PreScriptedResetDeployOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PreScriptedResetDeployOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("deploystatus");
        e.getFieldKeys().add("deploycount");
        e.getFieldKeys().add("ispreset");
        e.getFieldKeys().add("scriptedtype");
        e.getFieldKeys().add("executetime");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.bizobj");
        e.getFieldKeys().add("entryentity.deploystatus_entry");
        e.getFieldKeys().add("entryentity.executetime_entry");
        e.getFieldKeys().add("bizapp");
        e.getFieldKeys().add("bizapp.bizcloud");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                DynamicObject obj = null;
                for (ExtendedDataEntity entity : this.getDataEntities()) {
                    obj = entity.getDataEntity();
                    if (!DeployStatusEnum.DEPLOYING.getValue().equals(obj.getString("deploystatus"))) continue;
                    this.addFatalErrorMessage(entity, String.format(ResManager.loadKDString((String)"%s\uff1a\u90e8\u7f72\u4e2d\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u90e8\u7f72\u91cd\u7f6e\u3002", (String)"PreScriptedResetDeployOp_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), obj.getString("name")));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] objects = e.getDataEntities();
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>(10);
        for (DynamicObject obj : objects) {
            try {
                PreScriptedBusiness.resetDeployPreScripted(obj);
                successObjs.add(obj);
            }
            catch (KDBizException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
                this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(obj, e1.getMessage()));
            }
            catch (Exception e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
                String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u90e8\u7f72\u91cd\u7f6e\u5931\u8d25\u3002", (String)"PreScriptedResetDeployOp_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), obj.getString("name"));
                this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(obj, msg));
            }
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }

    private ValidationErrorInfo buildErrMessage(DynamicObject obj, String msg) {
        Object pkId = obj.getPkValue();
        int dataIndex = 0;
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "errorcode001", "", msg, errorLevel);
        return info;
    }
}

