/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.prescripted;

import com.thoughtworks.xstream.core.util.Base64Encoder;
import java.util.ArrayList;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.prescripted.PreScriptedFileBusiness;
import kd.taxc.bdtaxr.common.enums.prescripted.FileTypeEnum;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.bdtaxr.opplugin.prescripted.PreScriptedResetDeployOp;

public class PreScriptedSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PreScriptedResetDeployOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                DynamicObject obj = null;
                for (ExtendedDataEntity entity : this.getDataEntities()) {
                    obj = entity.getDataEntity();
                    Optional result = PreScriptedSaveOp.this.checkInfoVoild(obj);
                    if (!result.isPresent()) continue;
                    this.addFatalErrorMessage(entity, (String)result.get());
                }
            }
        });
    }

    private Optional<String> checkInfoVoild(DynamicObject obj) {
        DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
        DynamicObject entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (DynamicObject)entries.get(i);
            if (FileTypeEnum.PLUGIN.getValue().equals(entry.getString("filetype"))) {
                if (!StringUtils.isEmpty((CharSequence)entry.getString("scriptedplugin"))) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u6587\u4ef6\u7c7b\u578b\u4e3a\u63d2\u4ef6\uff0c\u63d2\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PreScriptedSaveOp_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), i + 1);
                return Optional.of(msg);
            }
            if (!StringUtils.isEmpty((CharSequence)entry.getString("filename"))) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u6587\u4ef6\u7c7b\u578b\u4e0d\u662f\u63d2\u4ef6\uff0c\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PreScriptedSaveOp_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), i + 1);
            return Optional.of(msg);
        }
        return Optional.empty();
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] objects = e.getDataEntities();
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        Base64Encoder encoder = new Base64Encoder();
        for (DynamicObject obj : objects) {
            DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
            boolean isSuccess = true;
            ArrayList<Long> entryIds = new ArrayList<Long>(10);
            for (DynamicObject entry : entries) {
                String fileUrl = entry.getString("filepath");
                if (!StringUtil.isEmpty((CharSequence)fileUrl)) {
                    byte[] fileContent = PreScriptedFileBusiness.loadFileContent(fileUrl);
                    if (fileContent == null) {
                        String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u6587\u4ef6\u89e3\u6790\u5931\u8d25\u3002", (String)"PreScriptedSaveOp_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), entry.getString("filename"));
                        this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(obj, msg));
                        isSuccess = false;
                        break;
                    }
                    entry.set("filepath", null);
                    try {
                        PreScriptedFileBusiness.savePreScriptedFile(obj.getLong("id"), entry.getLong("id"), encoder.encode(fileContent));
                    }
                    catch (KDBizException e1) {
                        logger.error(e1.getMessage(), (Throwable)e1);
                        this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(obj, e1.getMessage()));
                        isSuccess = false;
                        break;
                    }
                    catch (Exception e2) {
                        logger.error(e2.getMessage(), (Throwable)e2);
                        String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25\u3002", (String)"PreScriptedSaveOp_3", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), entry.getString("filename"));
                        this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(obj, msg));
                        isSuccess = false;
                        break;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)entry.getString("filename"))) continue;
                entryIds.add(entry.getLong("id"));
            }
            try {
                PreScriptedFileBusiness.deleteNotRelatePreScriptedFile(obj.getLong("id"), entryIds);
            }
            catch (KDBizException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
                this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(obj, e1.getMessage()));
                isSuccess = false;
            }
            catch (Exception e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
                String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u6587\u4ef6\u5220\u9664\u5931\u8d25\u3002", (String)"PreScriptedSaveOp_4", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), obj.getString("name"));
                this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(obj, msg));
                isSuccess = false;
            }
            if (!isSuccess) continue;
            successObjs.add(obj);
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }

    private ValidationErrorInfo buildErrMessage(DynamicObject obj, String msg) {
        Object pkId = obj.getPkValue();
        int dataIndex = 0;
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "errorcode001", "", msg, errorLevel);
        return info;
    }
}

