/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.assist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class AssistService {
    private static final String TPO_TCVAT_ASSIST = "tpo_tcvat_assist";

    public static List<String> queryAssistParams(String assistCode, String orgId, String startDate, String endDate) {
        ArrayList<String> list = new ArrayList<String>();
        QFilter code = new QFilter("number", "=", (Object)assistCode);
        QFilter fstatus1 = new QFilter("entryentity.fstatus1", "=", (Object)"1");
        QFilter startdate = new QFilter("entryentity.startdate", "<=", (Object)DateUtils.stringToDate(startDate));
        QFilter enddate = new QFilter("entryentity.enddate", ">=", (Object)DateUtils.stringToDate(endDate)).or(QFilter.isNull((String)"entryentity.enddate"));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)TPO_TCVAT_ASSIST, (String)"entryentity.fvalue1,entryentity.wherejson", (QFilter[])new QFilter[]{code, fstatus1, startdate, enddate}, (String)"entryentity.fvalue1 asc,entryentity.endDate DESC");
        for (DynamicObject d : doc) {
            String fvalue1 = d.getString("entryentity.fvalue1");
            String wherejson = d.getString("entryentity.wherejson");
            if (StringUtils.isNotEmpty((CharSequence)wherejson)) {
                Boolean exists = (Boolean)TaxcMainDataServiceHelper.queryTaxcMainByOrgIdAndWhereJson((Long)Long.parseLong(orgId), (String)wherejson).getData();
                if (!exists.booleanValue()) continue;
                list.add(fvalue1);
                continue;
            }
            list.add(fvalue1);
        }
        return list;
    }

    public static Map<String, String> queryAssistParams(List<String> assistCodes, String orgId, String startDate, String endDate) {
        HashMap<String, String> map = new HashMap<String, String>();
        QFilter code = new QFilter("number", "in", assistCodes);
        QFilter fstatus1 = new QFilter("entryentity.fstatus1", "=", (Object)"1");
        QFilter startdate = new QFilter("entryentity.startdate", "<=", (Object)DateUtils.stringToDate(startDate));
        QFilter enddate = new QFilter("entryentity.enddate", ">=", (Object)DateUtils.stringToDate(endDate)).or(QFilter.isNull((String)"entryentity.enddate"));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)TPO_TCVAT_ASSIST, (String)"number,entryentity.fvalue1,entryentity.wherejson", (QFilter[])new QFilter[]{code, fstatus1, startdate, enddate}, (String)"entryentity.endDate DESC");
        for (DynamicObject d : doc) {
            String number = d.getString("number");
            String fvalue1 = d.getString("entryentity.fvalue1");
            String wherejson = d.getString("entryentity.wherejson");
            if (StringUtils.isNotEmpty((CharSequence)wherejson)) {
                Boolean exists = (Boolean)TaxcMainDataServiceHelper.queryTaxcMainByOrgIdAndWhereJson((Long)Long.parseLong(orgId), (String)wherejson).getData();
                if (!exists.booleanValue()) continue;
                map.put(number, fvalue1);
                continue;
            }
            map.putIfAbsent(number, fvalue1);
        }
        return map;
    }
}

