/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.constant;

import java.util.Optional;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;

public enum TaxAppEnum {
    TCVAT("tcvat", new MultiLangEnumBridge("\u589e\u503c\u7a0e", "TaxAppEnum_0", "taxc-bdtaxr-common"), "zzs"),
    FJSF("fjsf", new MultiLangEnumBridge("\u9644\u52a0\u7a0e", "TaxAppEnum_1", "taxc-bdtaxr-common"), "fjsf"),
    TCCIT("tccit", new MultiLangEnumBridge("\u6240\u5f97\u7a0e", "TaxAppEnum_2", "taxc-bdtaxr-common"), "qysds"),
    TCCT("tcct", new MultiLangEnumBridge("\u6d88\u8d39\u7a0e", "TaxAppEnum_3", "taxc-bdtaxr-common"), "xfs"),
    TCSD("tcsd", new MultiLangEnumBridge("\u5370\u82b1\u7a0e", "TaxAppEnum_4", "taxc-bdtaxr-common"), "yhs"),
    TCRET("tcret", new MultiLangEnumBridge("\u623f\u4ea7\u7a0e", "TaxAppEnum_5", "taxc-bdtaxr-common"), "fcscztdsys"),
    TCTRC("tctrc", new MultiLangEnumBridge("\u7a0e\u52a1\u98ce\u9669\u7ba1\u63a7", "TaxAppEnum_6", "taxc-bdtaxr-common"), null),
    TCVVT("tcvvt", new MultiLangEnumBridge("\u7a0e\u52a1\u62a5\u8868\u62a5\u544a", "TaxAppEnum_7", "taxc-bdtaxr-common"), null),
    TCNFEP("tcnfep", new MultiLangEnumBridge("\u975e\u8d38\u4ed8\u6c47", "TaxAppEnum_8", "taxc-bdtaxr-common"), null),
    TCTSA("tctsa", new MultiLangEnumBridge("\u7a0e\u52a1\u7edf\u8ba1\u5206\u6790", "TaxAppEnum_9", "taxc-bdtaxr-common"), null),
    GTCP("gtcp", new MultiLangEnumBridge("\u5168\u7403\u7a0e\u52a1\u7533\u62a5", "TaxAppEnum_10", "taxc-bdtaxr-common"), null),
    TOTF("totf", new MultiLangEnumBridge("\u5176\u4ed6\u7a0e\u8d39", "TaxAppEnum_11", "taxc-bdtaxr-common"), "qtsf"),
    TAM("tam", new MultiLangEnumBridge("\u7a0e\u52a1\u5de5\u4f5c\u53f0", "TaxAppEnum_12", "taxc-bdtaxr-common"), null),
    TDM("tdm", new MultiLangEnumBridge("\u6d89\u7a0e\u6570\u636e\u7ba1\u7406", "TaxAppEnum_13", "taxc-bdtaxr-common"), null),
    ITP("itp", new MultiLangEnumBridge("\u6240\u5f97\u7a0e\u8ba1\u63d0", "TaxAppEnum_14", "taxc-bdtaxr-common"), null),
    RDESD("rdesd", new MultiLangEnumBridge("\u7814\u53d1\u52a0\u8ba1\u6263\u9664", "TaxAppEnum_15", "taxc-bdtaxr-common"), null),
    TPO("tpo", new MultiLangEnumBridge("\u7a0e\u52a1\u653f\u7b56\u8fd0\u7ef4", "TaxAppEnum_16", "taxc-bdtaxr-common"), null),
    ICTM("ictm", new MultiLangEnumBridge("\u5173\u8054\u4ea4\u6613", "TaxAppEnum_17", "taxc-bdtaxr-common"), null);

    private String appid;
    private String name;
    private String categoryCode;
    private MultiLangEnumBridge bridge = null;

    private TaxAppEnum(String appid, MultiLangEnumBridge bridge, String categoryCode) {
        this.appid = appid;
        this.bridge = bridge;
        this.categoryCode = categoryCode;
    }

    public static TaxAppEnum getEnumInstanceByAppid(String appid) {
        for (TaxAppEnum taxEnum : TaxAppEnum.values()) {
            if (!taxEnum.getAppid().equalsIgnoreCase(appid)) continue;
            return taxEnum;
        }
        return null;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public String getCategoryCode() {
        return this.categoryCode;
    }

    public static String getCategoryType(String appid, String templatetype) {
        if ("szys_a".equals(templatetype) || "szys_b".equals(templatetype)) {
            return "szys";
        }
        TaxAppEnum licenseTaxEnum = TaxAppEnum.getEnumInstanceByAppid(appid);
        return Optional.ofNullable(licenseTaxEnum).isPresent() ? licenseTaxEnum.getCategoryCode() : null;
    }
}

