/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.db;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DynamicObjectUtils {
    public static DynamicObject mapToDynamicObject(String metaEntryId, Map<String, Object> map) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)metaEntryId);
        DataEntityPropertyCollection properties = dynamicObject.getDynamicObjectType().getProperties();
        map.keySet().stream().forEach(key -> {
            IDataEntityProperty property = (IDataEntityProperty)properties.get(key);
            Object value = map.get(key);
            if (property instanceof DateTimeProp) {
                dynamicObject.set(key, null == value ? null : DateUtils.stringToDate((String)value));
            } else if (property instanceof DynamicCollectionProperty) {
                if (value != null) {
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(key);
                    List list = (List)value;
                    for (Map entryMap : list) {
                        DynamicObject aNew = dynamicObjectCollection.addNew();
                        DynamicObjectUtils.fillDynamicObject(aNew, entryMap);
                    }
                }
            } else {
                dynamicObject.set(key, value);
            }
        });
        return dynamicObject;
    }

    private static void fillDynamicObject(DynamicObject dynamicObject, Map<String, Object> map) {
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)key);
            if (property instanceof BasedataProp) {
                BasedataProp a = (BasedataProp)property;
                DynamicObject basedata = BusinessDataServiceHelper.newDynamicObject((String)a.getBaseEntityId());
                DynamicObjectUtils.fillDynamicObject(basedata, (Map)value);
                dynamicObject.set(key, (Object)basedata);
                continue;
            }
            dynamicObject.set(key, value);
        }
    }

    public static void transferDynamicObjectToMap(DynamicObject dynamicObject, Map<String, Object> map) {
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String key = property.getName();
            map.put(key, dynamicObject.get(key));
        }
    }

    public static void transferMapToDynamicObject(DynamicObject dynamicObject, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            dynamicObject.set(entry.getKey(), entry.getValue());
        }
    }

    public static boolean containsProperty(DynamicObject dynamicObject, String propertyName) {
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)dynamicObject.getDataEntityType().getProperties().get((Object)propertyName);
        return iDataEntityProperty != null;
    }

    public static String serializeDynamicObjToStr(DynamicObject dataEntity) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dataEntity.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        binder.setSerializeDefaultValue(true);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        String jsonString = jser.serializeToString((Object)dataEntity, null);
        return jsonString;
    }

    public static DynamicObject serializeToDataEntity(String jsonString, String formId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)entityType);
        binder.setOnlyDbProperty(false);
        binder.setSerializeDefaultValue(true);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        DynamicObject object = (DynamicObject)jser.deserializeFromString(jsonString, null);
        return object;
    }
}

