/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.db.table;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.declare.handler.NsrDeclareHandler;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class DrawbackService
implements NsrDeclareHandler {
    private static Log logger = LogFactory.getLog(DrawbackService.class);
    public static final String TCVAT_NSRXX = "tcetr_declare_main";
    public static final String SPLITSTRING = "#";
    public static final String EWBLXH = "ewblxh";
    public static final String SBBID = "sbbid";
    private static final String ORGID = "org";
    private static final String STATUS = "declarestatus";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String SBRQ = "sbrq";
    private static final String NSRTYPE = "type";
    private static final String TAXLIMIT = "taxlimit";
    private static final String TEMPLATE_ID = "templateid";
    private static final String ID = "id";
    private static final String[] fields = new String[]{"id", "number", "contactinformation", "maincompany", "taxorg.taxpayer as taxpayer", "taxorg.unifiedsocialcode as unifiedsocialcode", "registertype.name", "registeredcapital", "registertime", "codeandname.name", "legalpeople", "registeraddress", "actualaddress", "accountingstandards", "orgid", "registeraddrdetail", "actualaddrdetail", "entryentity.bankname", "entryentity.bankacct,taxoffice"};

    @Override
    public Map<String, String> createDeclareMain(String id, String billNo, String type, String orgId, String startData, String endData, boolean isCreate, Map<String, Object> extendParams, Long templateId) {
        HashMap<String, String> map = new HashMap<String, String>();
        DrawbackService.set(map, ORGID, orgId);
        DrawbackService.set(map, STATUS, "editing");
        DrawbackService.set(map, SKSSQQ, startData);
        DrawbackService.set(map, SKSSQZ, endData);
        DrawbackService.set(map, NSRTYPE, type);
        if (templateId != null) {
            DrawbackService.set(map, TEMPLATE_ID, String.valueOf(templateId));
        }
        DrawbackService.set(map, EWBLXH, "1");
        if (isCreate) {
            DrawbackService.set(map, "creator", RequestContext.get().getUserId());
            DrawbackService.set(map, "createtime", DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        }
        DrawbackService.set(map, "billstatus", "A");
        DrawbackService.set(map, "modifier", RequestContext.get().getUserId());
        DrawbackService.set(map, "modifytime", DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        DrawbackService.set(map, ID, id);
        DrawbackService.set(map, "billno", StringUtil.isNotBlank((CharSequence)billNo) ? billNo : id);
        DynamicObject taxorg = (DynamicObject)TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)Long.valueOf(orgId)).getData();
        if (taxorg != null) {
            DrawbackService.set(map, "nsrsbh", TaxOrgUtil.getUnifiedsocialcode(taxorg));
            DrawbackService.set(map, "nsrmc", TaxOrgUtil.getTaxpayer(taxorg));
        }
        if (null != extendParams && extendParams.size() != 0) {
            for (Map.Entry<String, Object> entry : extendParams.entrySet()) {
                DrawbackService.set(map, entry.getKey(), (String)entry.getValue());
            }
        }
        DrawbackService.set(map, "sourcetype", "1");
        return map;
    }

    private static void set(Map<String, String> map, String key, String value) {
        if (StringUtil.isNotBlank((CharSequence)value)) {
            map.put("tcetr_declare_main#1#" + key, value);
        }
    }
}

