/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.bdtaxr.common.constant.TaxDeductionConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.declare.initparam.InitParamsService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.request.FormulaRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.CellType;
import kd.taxc.bdtaxr.common.taxdeclare.AbstractTaxDeclarePluginNew;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang.StringUtils;

@Deprecated
public class TaxDeclarePlugin
extends AbstractTaxDeclarePluginNew {
    private static Log LOGGER = LogFactory.getLog(TaxDeclarePlugin.class);
    private static String CUSTOM_CONTROL = "customcontrolap";
    private static final String CACHE_CURRENT_DATA = "current_data";
    private static final String CACHE_UPDATA_CELLID = "updata_cellid";
    private static final String CACHE_UPDATA_FOCUS = "focus";
    private static final String CACHE_UPDATA_REMARK = "remark_data";
    private static final String CACHE_CELLTYPE_FORMULA_LIST = "CACHE_CELLTYPE_FORMULA_LIST";
    private static final String CACHE_UPDATA_CELLID_SAVE = "updata_cellid_save";
    private static final String CACHE_DECLARE_REQUEST = "declareRequest";
    private static final String CACHE_DECLARE_DATA = "declareData";
    private static final String EVENT_SHOW_BASE_DATA = "showBaseData";
    private static final String EVENT_SELECT_SHEET = "selectSheet";
    private static final String EVENT_DETAIL = "detail";
    private static final String EVENT_SHOW_ADD_REMARK = "showAddRemark";
    private static final String EVENT_CHANGE_DATA = "changeData";
    private static final String EVENT_HREF = "datahref";
    private static final String EVENT_UPDATE_ROW = "updateRow";
    private static final String BASEDATA_ENTITY_ID = "baseEntityId";
    private static final char SPLIT_STRING_SAVE = '#';
    private static final char SPLIT_STRING_SHOW = '_';
    private static final String HTML_TEMPLATE = "htmlTemplate";
    private static final String CELL_CLICK_POPUP = "cell_click_popup";

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    @Override
    public String getAttachmentFieldName() {
        return "attachmentpanelap";
    }

    @Override
    public String getAttachmentPanelName() {
        return "attachmentflex";
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        LOGGER.info("TaxDeclarePlugin customParams=" + JsonUtil.toJson(customParams));
        DeclareRequestModel declareModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)((String)customParams.get("declareRequestData")), DeclareRequestModel.class);
        Long orgId = declareModel.getOrgId();
        if (null == orgId) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxDeclarePlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        String templateType = declareModel.getTemplateType();
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)templateType)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u6a21\u677f\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxDeclarePlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        String skssqq = declareModel.getSkssqq();
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)skssqq)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxDeclarePlugin_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            sdf.parse(skssqq);
        }
        catch (ParseException e1) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a[yyyy-MM-dd]", (String)"TaxDeclarePlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), e1);
        }
        String skssqz = declareModel.getSkssqz();
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)skssqz)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxDeclarePlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        try {
            sdf.parse(skssqz);
        }
        catch (ParseException e1) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a[yyyy-MM-dd]", (String)"TaxDeclarePlugin_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), e1);
        }
        String operation = declareModel.getOperation();
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)operation)) {
            operation = "read";
        }
        String sheetName = declareModel.getSheetName();
        TreeUtils.putCache(this.getPageCache(), CACHE_DECLARE_REQUEST, declareModel);
        this.loadDeclare(declareModel);
        if (null != this.getView().getParentView()) {
            this.getView().getParentView().addClientCallBack(null == this.getPageCache().get("sheetid") ? "0" : this.getPageCache().get("sheetid"), Integer.valueOf(0));
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("button_save".equals(key)) {
            // empty if block
        }
    }

    private void loadDeclare(DeclareRequestModel requestModel) {
        Long templateId;
        DeclareResponseModel responseModel = DeclareServiceHelper.queryData(requestModel);
        if (requestModel.getId() != null) {
            this.getPageCache().put("sbbid", String.valueOf(requestModel.getId()));
        }
        if (null == (templateId = responseModel.getTemplateId())) {
            this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7533\u62a5\u8868\u6a21\u677f\u5c1a\u672a\u7ef4\u62a4\uff0c\u6682\u4e0d\u652f\u6301\u7533\u62a5", (String)"TaxDeclarePlugin_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        TreeUtils.putCache(this.getPageCache(), CACHE_DECLARE_DATA, responseModel);
        this.refresh(responseModel.getData(), requestModel.getSheetName(), requestModel.getOperation());
        String sbbid = responseModel.getData().getOrDefault("tcvat_nsrxx#1#id", "-1");
        this.showAttachment(sbbid, requestModel.getOperation(), requestModel.getTemplateType());
    }

    public void customEvent(CustomEventArgs e) {
        String args = e.getEventArgs();
        String eventName = e.getEventName();
        Map argsMap = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        if (EVENT_CHANGE_DATA.equals(eventName)) {
            this.changeData((String)argsMap.get("cellid"), (String)argsMap.get("value"), (String)argsMap.get("sheetid"));
        } else if (EVENT_SHOW_ADD_REMARK.equals(eventName)) {
            this.showAddRemark((String)argsMap.get("cellid"));
        } else if (EVENT_DETAIL.equals(eventName)) {
            this.showDetail((String)argsMap.get("cellid"));
        } else if (EVENT_SELECT_SHEET.equals(eventName)) {
            this.getPageCache().put("sheetid", (String)argsMap.get("sheetid"));
            if (null != this.getView().getParentView()) {
                this.getView().getParentView().addClientCallBack((String)argsMap.get("sheetid"));
                this.getView().sendFormAction(this.getView().getParentView());
            }
        } else if (EVENT_SHOW_BASE_DATA.equals(eventName)) {
            this.getPageCache().put(BASEDATA_ENTITY_ID, (String)argsMap.get(BASEDATA_ENTITY_ID));
            this.getPageCache().put("cellid", (String)argsMap.get("cellid"));
            if (((String)argsMap.get("cellid")).startsWith("tccit_qysds_ext_dyn")) {
                Map<String, String> currentMap = TreeUtils.getCache(this.getPageCache(), CACHE_UPDATA_CELLID_SAVE, Map.class);
                if (null == currentMap) {
                    DeclareResponseModel declareMode = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_DATA, DeclareResponseModel.class);
                    currentMap = declareMode.getData();
                }
                String saveCellId = this.paraString((String)argsMap.get("cellid"));
                String beforeValue = currentMap.get(saveCellId);
                String amountCellId = saveCellId + "amount";
                String beforeAmountValue = currentMap.get(amountCellId);
                if (this.StringValueExist(beforeValue) || this.StringValueExist(beforeAmountValue)) {
                    this.remindChange(argsMap);
                } else {
                    this.showBaseData(argsMap);
                }
            } else {
                this.showBaseData(argsMap);
            }
        } else if (EVENT_HREF.equals(eventName)) {
            String hreftype = (String)argsMap.get("hreftype");
            String hrefpara = (String)argsMap.get("hrefpara");
            if ("treeclick".equals(hreftype)) {
                IFormView parentView = this.getView().getParentView();
                JSONObject jsonObject = JSONObject.parseObject((String)hrefpara);
                String pluginName = jsonObject.getString("plugin");
                String method = jsonObject.getString("method");
                String param = jsonObject.getString("param");
                try {
                    FormViewPluginProxy pluginProxy = (FormViewPluginProxy)parentView.getService(FormViewPluginProxy.class);
                    IFormPlugin plugin = pluginProxy.getPlugin(pluginName);
                    if (plugin == null) {
                        throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u63d2\u4ef6%s", (String)"TaxDeclarePlugin_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), pluginName));
                    }
                    Class<?> pluginClass = plugin.getClass();
                    Method saveClick = pluginClass.getMethod(method, String.class);
                    saveClick.invoke((Object)plugin, param);
                    this.getView().sendFormAction(parentView);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            if ("hyperLinkClick".equals(hreftype)) {
                this.hyperLinkClick(argsMap);
            }
        } else if (EVENT_UPDATE_ROW.equals(eventName)) {
            // empty if block
        }
    }

    private String paraString(String str) {
        StringBuilder buf = new StringBuilder();
        String[] cellId = str.split("_");
        for (int i = 0; i < cellId.length; ++i) {
            if (i < cellId.length - 3) {
                buf.append(cellId[i]);
                buf.append("_");
                continue;
            }
            if (i == cellId.length - 1) {
                buf.append(cellId[i]);
                continue;
            }
            buf.append(cellId[i]);
            buf.append("#");
        }
        return buf.toString();
    }

    private boolean StringValueExist(String str) {
        return !StringUtil.isEmpty((CharSequence)str) && !str.equals("0");
    }

    private void remindChange(Map<String, String> argsMap) {
        TreeUtils.putCache(this.getPageCache(), "orgModifyParams", argsMap);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("orgModifyConform", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TaxDeclarePlugin_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TaxDeclarePlugin_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u884c\u6b21\u5df2\u5b58\u5728\u6570\u636e\uff0c\u91cd\u65b0\u9009\u62e9\u4f18\u60e0\u9879\u76ee\u5c06\u4f1a\u8986\u76d6\u5f53\u524d\u5df2\u6709\u4f18\u60e0\u9879\u76ee\u53ca\u91d1\u989d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u7f16\u8f91\uff1f", (String)"TaxDeclarePlugin_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)"orgModifyConform", (String)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.showBaseData(TreeUtils.getCache(this.getPageCache(), "orgModifyParams", Map.class));
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                return;
            }
        }
    }

    private void hyperLinkClick(Map<String, String> argsMap) {
        DeclareRequestModel requestModel = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_REQUEST, DeclareRequestModel.class);
        String operation = requestModel.getOperation();
        String hrefpara = argsMap.get("hrefpara");
        String sheetid = argsMap.get("sheetid");
        String cellid = argsMap.get("cellid");
        IFormView parentView = this.getView().getParentView();
        JSONObject jsonObject = JSONObject.parseObject((String)hrefpara);
        String pluginName = jsonObject.getString("plugin");
        String method = jsonObject.getString("method");
        JSONObject param = this.replaceCellValue(jsonObject, cellid);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)sheetid)) {
            sheetid = this.getPageCache().get("sheetid");
        }
        param.put("sheetid", (Object)sheetid);
        param.put("operation", (Object)operation);
        param.put("cellid", (Object)cellid);
        try {
            Class<?> aClass = Class.forName(pluginName);
            if (aClass == null) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u63d2\u4ef6%s", (String)"TaxDeclarePlugin_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), pluginName));
            }
            Method hyperLinkClick = aClass.getMethod(method, String.class, JSONObject.class, IFormView.class, IFormPlugin.class);
            Map<String, String> allFieldToSave = this.getAllFieldToSave();
            hyperLinkClick.invoke(aClass.newInstance(), new Object[]{allFieldToSave.get(argsMap.get("cellid")), param, this.getView(), this});
            this.getView().sendFormAction(parentView);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public JSONObject replaceCellValue(JSONObject jsonObject, String cellid) {
        JSONObject param = jsonObject.getJSONObject("param");
        DeclareResponseModel model = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_DATA, DeclareResponseModel.class);
        Map<String, String> resultCache = model.getData();
        cellid = new StringBuffer(new StringBuffer(cellid).reverse().toString().replaceFirst("_", "#").replaceFirst("_", "#")).reverse().toString();
        HashMap saveMap = TreeUtils.getCache(this.getPageCache(), CACHE_UPDATA_CELLID_SAVE, Map.class);
        if (saveMap == null) {
            saveMap = new HashMap();
        }
        String cellValueFromSaveCache = (String)saveMap.get(cellid);
        String cellValueFromDeclareCache = resultCache.get(cellid);
        if (StringUtil.isNotEmpty((CharSequence)cellValueFromSaveCache) && !cellValueFromSaveCache.equalsIgnoreCase(cellValueFromDeclareCache)) {
            param.put("cellvalue", (Object)cellValueFromSaveCache);
        } else {
            param.put("cellvalue", (Object)cellValueFromDeclareCache);
        }
        for (Map.Entry entry : param.entrySet()) {
            if (resultCache.get(entry.getValue()) == null) continue;
            entry.setValue(resultCache.get(entry.getValue()));
        }
        return param;
    }

    private void showAddRemark(String cellId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bdtaxr_declare_remark");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("cellid", (Object)cellId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bdtaxr_declare_remark");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showDetail(String cellId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bdtaxr_declare_detail");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("cellid", (Object)cellId);
        showParameter.setCustomParam("sbbid", (Object)this.getPageCache().get("sbbid"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bdtaxr_declare_detail");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showBaseData(Map<String, String> argsMap) {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, EVENT_SHOW_BASE_DATA);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)argsMap.get(BASEDATA_ENTITY_ID), (boolean)false, (int)2);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        if (showParameter.getBillFormId().equals("tpo_discount_tree")) {
            showParameter.setFormId("bos_treelistf7");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("template", "qysdsyj");
            customParams.put("type", "yhxm");
            showParameter.setCustomParams(customParams);
            listFilterParameter = showParameter.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(this.appendQfiler(argsMap.get("cellid")));
            TreeFilterParameter treeFilterParameter = showParameter.getTreeFilterParameter();
            treeFilterParameter.setQFilters(qFilters);
            listFilterParameter.getQFilters().add(new QFilter("isleaf", "=", (Object)"1"));
        } else {
            this.setFilter(argsMap, listFilterParameter);
        }
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private QFilter appendQfiler(String type) {
        QFilter q1 = null;
        if (type.startsWith("tccit_qysds_ext_dyn_") && type.endsWith("_item")) {
            q1 = new QFilter("longnumber", "like", (Object)"%YJ-JJSR2021%").or(new QFilter("longnumber", "like", (Object)"%YJ-MSSR2021%")).or(new QFilter("longnumber", "like", (Object)"%YJ-JJKC2021%"));
        } else if (type.startsWith("tccit_qysds_ext_dyn2_") && type.endsWith("_item")) {
            List collect = IntStream.rangeClosed(1, 15).boxed().map(s -> String.format("YJ-SDJM2021-%02d", s)).collect(Collectors.toList());
            collect.add("YJ-SDJM2021");
            q1 = new QFilter("number", "in", collect);
        }
        return q1;
    }

    private void setFilter(Map<String, String> argsMap, ListFilterParameter listFilterParameter) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null == customParams) {
            throw new IllegalArgumentException("Illegal parameters!!!");
        }
        JSONObject obj = JSONObject.parseObject((String)customParams.get("declareRequestData").toString());
        String templatetype = obj.get((Object)"templateType").toString();
        String startDate = obj.get((Object)"skssqq").toString();
        String endDate = obj.get((Object)"skssqz").toString();
        if ("fjsf".equals(templatetype)) {
            String cellid = argsMap.get("cellid");
            if ("tcvat_sb_fjsf_1_jmxzdm".equals(cellid)) {
                templatetype = "cswhjss";
            }
            if ("tcvat_sb_fjsf_2_jmxzdm".equals(cellid) || "tcvat_sb_fjsf#2#sdqyjmxzdm".equals(cellid)) {
                templatetype = "jyffj";
            }
            if ("tcvat_sb_fjsf_3_jmxzdm".equals(cellid) || "tcvat_sb_fjsf#3#sdqyjmxzdm".equals(cellid)) {
                templatetype = "dfjyffj";
            }
        }
        if (null != TaxDeductionConstant.getMap().get(templatetype)) {
            QFilter cateGoryFilter = new QFilter("taxcategory", "=", (Object)TaxDeductionConstant.getMap().get(templatetype));
            listFilterParameter.getQFilters().add(cateGoryFilter);
        }
        QFilter periodFilter = new QFilter("startDate", "<=", (Object)DateUtils.stringToDate(startDate)).and(new QFilter("endDate", ">=", (Object)DateUtils.stringToDate(endDate)).or("endDate", "is null", null));
        listFilterParameter.getQFilters().add(periodFilter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnData;
        Object returnObj = event.getReturnData();
        if (returnObj != null && "bdtaxr_declare_remark".equals(event.getActionId())) {
            Map returnData2 = (Map)returnObj;
            HashMap<String, String> remarkMap = TreeUtils.getCache(this.getPageCache(), CACHE_UPDATA_REMARK, Map.class);
            if (remarkMap == null) {
                remarkMap = new HashMap<String, String>(16);
            }
            String cellId = (String)returnData2.get("cellid");
            String remark = (String)returnData2.get("remark");
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)cellId) && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)remark)) {
                remarkMap.put(cellId, remark);
                TreeUtils.putCache(this.getPageCache(), CACHE_UPDATA_REMARK, remarkMap);
            }
        } else if (event.getActionId().startsWith(EVENT_SHOW_BASE_DATA) && returnObj != null) {
            String cellId = this.getPageCache().get("cellid");
            ListSelectedRowCollection returnList = (ListSelectedRowCollection)returnObj;
            if (returnList != null && !returnList.isEmpty()) {
                ListSelectedRow row = returnList.get(0);
                Map<String, String> dataMap = CacheUtils.getInstance().getDataResult(this.getCache());
                Map<String, String> saveFieldMap = this.getAllFieldToSave();
                String saveCellId = saveFieldMap.get(cellId);
                String beforeValue = dataMap.get(saveCellId);
                if (!row.getPrimaryKeyValue().toString().equals(beforeValue)) {
                    String sheetId = this.getPageCache().get("sheetid");
                    if (!this.duplicatCheck(cellId, row.getPrimaryKeyValue().toString())) {
                        return;
                    }
                    this.changeData(cellId, row.getPrimaryKeyValue().toString(), sheetId);
                }
            }
        } else if (returnObj != null && CELL_CLICK_POPUP.equals(event.getActionId()) && "tcvvt_detail_tz_dialog".equals((returnData = (Map)returnObj).get("fromForm"))) {
            String cellid = (String)returnData.get("cellid");
            cellid = cellid.replace("#", "_");
            DeclareRequestModel declareRequestModel = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_REQUEST, DeclareRequestModel.class);
            declareRequestModel.setSheetId((String)returnData.get("sheetid"));
            TreeUtils.putCache(this.getPageCache(), CACHE_DECLARE_REQUEST, declareRequestModel);
            this.changeData(cellid, (String)returnData.get("adjustsumamout"), (String)returnData.get("sheetid"));
        }
    }

    private void changeData(String cellId, String value, String sheetId) {
        HashMap<String, String> dataMap = TreeUtils.getCache(this.getPageCache(), CACHE_UPDATA_CELLID, Map.class);
        if (dataMap == null) {
            dataMap = new HashMap<String, String>(16);
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)cellId)) {
            Map<String, EntityField> typeMap = TemplateUtils.getAllFieldTypeToShow(this.getTemplateTables());
            if (cellId.contains("_")) {
                String cell = cellId.replaceAll("\\d+", "");
                EntityField entityField = null;
                for (Map.Entry<String, EntityField> entry : typeMap.entrySet()) {
                    if (!cell.equals(entry.getKey().replaceAll("\\d+", ""))) continue;
                    entityField = entry.getValue();
                    break;
                }
                if (null != entityField && "Decimal".equals(entityField.getFieldType())) {
                    value = kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)value) ? value.replaceAll(",", "") : "0";
                    value = TemplateUtils.dataFormatPreSave(value, entityField);
                }
            }
            dataMap.put(cellId, value);
            TreeUtils.putCache(this.getPageCache(), CACHE_UPDATA_CELLID, dataMap);
            DeclareResponseModel declareMode = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_DATA, DeclareResponseModel.class);
            Map<String, String> currentMap = TreeUtils.getCache(this.getPageCache(), CACHE_UPDATA_CELLID_SAVE, Map.class);
            if (null == currentMap) {
                currentMap = declareMode.getData();
            } else {
                declareMode.getData().putAll(currentMap);
                currentMap = declareMode.getData();
            }
            if (cellId.startsWith("tccit_qysds_ext_dyn") && cellId.endsWith("item")) {
                declareMode.getData().put(cellId + "amount", "");
                currentMap.put(cellId + "amount", "");
            }
            Map<String, String> showAllMap = TemplateUtils.getAllMapping(currentMap);
            HashMap changeMap = Maps.newHashMapWithExpectedSize((int)dataMap.size());
            dataMap.entrySet().forEach(v -> changeMap.put(showAllMap.get(v.getKey()), v.getValue()));
            if (showAllMap.get(cellId) != null) {
                FormulaRequestModel formulaRequestModel = new FormulaRequestModel();
                formulaRequestModel.setTemplateId(declareMode.getTemplateId());
                formulaRequestModel.setDynRowList(declareMode.getDynRowList());
                formulaRequestModel.setCellKey(showAllMap.get(cellId));
                formulaRequestModel.setCellValue(value);
                formulaRequestModel.setChangeMap(changeMap);
                DeclareRequestModel declareRequestModel = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_REQUEST, DeclareRequestModel.class);
                Map<String, String> businessMap = InitParamsService.getInitParams(declareRequestModel.getTemplateType()).buildBizParam(declareRequestModel);
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.putAll(businessMap);
                paramMap.putAll(declareMode.getData());
                formulaRequestModel.setParamMap(paramMap);
                Map<String, String> resultData = TemplateFormulaServiceHelper.cal(formulaRequestModel, declareMode.getMetaDataMap());
                currentMap.putAll(resultData);
            }
            TreeUtils.putCache(this.getPageCache(), CACHE_UPDATA_CELLID_SAVE, currentMap);
            if (sheetId != null) {
                this.getPageCache().put("sheetid", sheetId);
            }
            this.getPageCache().put(CACHE_UPDATA_FOCUS, cellId);
            String sheetName = this.getPageCache().get("sheetname");
            this.refresh(currentMap, sheetName, "edit");
        }
    }

    private boolean duplicatCheck(String cellId, String value) {
        Map dataMap = TreeUtils.getCache(this.getPageCache(), CACHE_UPDATA_CELLID, Map.class);
        DeclareResponseModel declareMode = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_DATA, DeclareResponseModel.class);
        Map<String, String> data = declareMode.getData();
        List<DynamicRowModel> dyData = declareMode.getDynRowList();
        if (null != data && !this.duplicatCheckMap(data, value)) {
            return false;
        }
        for (DynamicRowModel d : dyData) {
            if (null == d.getRowList()) continue;
            for (Map<String, String> m : d.getRowList()) {
                if (this.duplicatCheckMap(m, value)) continue;
                return false;
            }
        }
        return null == dataMap || this.duplicatCheckMap(dataMap, value);
    }

    private boolean duplicatCheckMap(Map<String, String> map, String value) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().startsWith("tccit_qysds_ext_dyn") && !entry.getKey().startsWith("tccit_nontax_summary_m") || !entry.getKey().endsWith("item") || !entry.getValue().equals(value)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"TaxDeclarePlugin_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public Map<String, String> saveClick(IPageCache pageCache, DeclareRequestModel declareRequestModel) {
        Map<String, String> newData;
        HashMap<String, String> resultMap = new HashMap();
        Long id = declareRequestModel.getId();
        Map updateMap = TreeUtils.getCache(pageCache, CACHE_UPDATA_CELLID, Map.class);
        Map<String, String> saveFieldMap = this.getAllFieldToSave();
        ArrayList<DynamicObject> hisList = new ArrayList<DynamicObject>();
        DeclareResponseModel responseModel = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_DATA, DeclareResponseModel.class);
        if (updateMap != null && !updateMap.isEmpty()) {
            Map<String, String> currMap = responseModel.getData();
            Map remarkMap = TreeUtils.getCache(pageCache, CACHE_UPDATA_REMARK, Map.class);
            HashMap basePkListMap = new HashMap();
            HashMap baseFieldListMap = new HashMap();
            HashMap cellTypeMap = new HashMap();
            HashMap<String, DynamicObject> baseValueMap = new HashMap<String, DynamicObject>();
            for (Map.Entry entry : basePkListMap.entrySet()) {
                QFilter qFilter = new QFilter("id", "in", entry.getValue());
                DynamicObjectCollection resultCollection = QueryServiceHelper.query((String)((String)entry.getKey()), (String)String.join((CharSequence)",", (Iterable)baseFieldListMap.get(entry.getKey())), (QFilter[])new QFilter[]{qFilter});
                if (resultCollection == null) continue;
                for (DynamicObject result : resultCollection) {
                    String valIndex = (String)entry.getKey() + result.getString("id");
                    baseValueMap.put(valIndex, result);
                }
            }
            Map<String, String> listTab = this.getTemplateTables();
            Map<String, EntityField> typeMap = TemplateUtils.getAllFieldTypeToShow(listTab);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tctb_declare_his");
            RequestContext context = RequestContext.get();
            for (Map.Entry entry : updateMap.entrySet()) {
                DynamicObject dObj = new DynamicObject((DynamicObjectType)mainEntityType);
                dObj.set("sbbid", (Object)this.getPageCache().get("sbbid"));
                dObj.set("cellid", entry.getKey());
                dObj.set("modifytype", (Object)"2");
                String formatValue = TemplateUtils.dataFormatPreSave(entry.getValue(), typeMap.get(entry.getKey()));
                if (null != typeMap.get(entry.getKey()) && "Decimal".equals(typeMap.get(entry.getKey()).getFieldType()) && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)formatValue)) {
                    formatValue = formatValue.replaceAll(",", "");
                }
                CellType cellType = (CellType)cellTypeMap.get(entry.getKey());
                String originalvalue = null;
                if (null != currMap) {
                    String key = saveFieldMap.get(entry.getKey());
                    originalvalue = currMap.get(key);
                    if (null != typeMap.get(entry.getKey()) && "Decimal".equals(typeMap.get(entry.getKey()).getFieldType()) && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)originalvalue)) {
                        originalvalue = originalvalue.replaceAll(",", "");
                    }
                }
                if (cellType != null && "5".equals(cellType.getCellType())) {
                    DynamicObject baseObj;
                    DynamicObject baseObj2;
                    BigDecimal origDec = BigDecimalUtil.toBigDecimal(originalvalue);
                    if (BigDecimal.ZERO.compareTo(origDec) != 0) {
                        baseObj2 = (DynamicObject)baseValueMap.get(cellType.getBaseEntityId() + origDec.longValue());
                        dObj.set("originalvalue", (Object)TemplateShowUtils.getDisplayText(cellType.getDisplayConfig(), baseObj2));
                    } else {
                        baseObj2 = (DynamicObject)baseValueMap.get(cellType.getBaseEntityId() + originalvalue);
                        dObj.set("originalvalue", (Object)TemplateShowUtils.getDisplayText(cellType.getDisplayConfig(), baseObj2));
                    }
                    BigDecimal tarDec = BigDecimalUtil.toBigDecimal(formatValue);
                    if (BigDecimal.ZERO.compareTo(origDec) != 0) {
                        baseObj = (DynamicObject)baseValueMap.get(cellType.getBaseEntityId() + tarDec.longValue());
                        dObj.set("targetvalue", (Object)TemplateShowUtils.getDisplayText(cellType.getDisplayConfig(), baseObj));
                    } else {
                        baseObj = (DynamicObject)baseValueMap.get(cellType.getBaseEntityId() + formatValue);
                        dObj.set("targetvalue", (Object)TemplateShowUtils.getDisplayText(cellType.getDisplayConfig(), baseObj));
                    }
                } else if (cellType != null && cellType.getItemMap() != null) {
                    dObj.set("originalvalue", (Object)this.getItemName(originalvalue, cellType.getItemMap()));
                    dObj.set("targetvalue", (Object)this.getItemName(formatValue, cellType.getItemMap()));
                } else {
                    dObj.set("originalvalue", originalvalue);
                    dObj.set("targetvalue", (Object)formatValue);
                }
                if (remarkMap != null) {
                    dObj.set("remark", remarkMap.get(entry.getKey()));
                }
                dObj.set("modifierfield", (Object)context.getUserId());
                dObj.set("modifydatefield", (Object)new Date());
                hisList.add(dObj);
                if (null == currMap) continue;
                currMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (null == (newData = TreeUtils.getCache(this.getPageCache(), CACHE_UPDATA_CELLID_SAVE, Map.class))) {
            newData = responseModel.getData();
        }
        declareRequestModel.setId(responseModel.getId());
        resultMap = DeclareServiceHelper.saveData(declareRequestModel, newData, responseModel.getData(), responseModel.getMetaDataMap());
        this.sendRiskCalRealTimeTask(declareRequestModel, updateMap, resultMap);
        DeclareRequestModel requestModel = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_REQUEST, DeclareRequestModel.class);
        requestModel.setRefresh(false);
        DeclareResponseModel responseModelNew = DeclareServiceHelper.queryData(requestModel);
        TreeUtils.putCache(this.getPageCache(), CACHE_DECLARE_DATA, responseModelNew);
        if (!CollectionUtils.isEmpty(hisList)) {
            DynamicObject[] arrInsertDobj = new DynamicObject[hisList.size()];
            arrInsertDobj = hisList.toArray(arrInsertDobj);
            SaveServiceHelper.save((DynamicObject[])arrInsertDobj);
            this.doUpdateNxxSign(pageCache.get("sbbid"));
        }
        try {
            String ssbId = this.getPageCache().get("sbbid");
            this.saveAttachment(ssbId, requestModel.getTemplateType());
        }
        catch (Exception e) {
            LOGGER.error("save attachments error", (Throwable)e);
        }
        return resultMap;
    }

    private void doUpdateNxxSign(String ssbId) {
        DynamicObject declareMain = BusinessDataServiceHelper.loadSingle((Object)ssbId, (String)"tcvat_nsrxx");
        if (declareMain != null) {
            declareMain.set("ismodified", (Object)1);
            SaveServiceHelper.update((DynamicObject)declareMain);
        }
    }

    private String getTemplate(String sheetName, String editFlag) {
        DeclareRequestModel declareModel = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_REQUEST, DeclareRequestModel.class);
        String templateType = declareModel.getTemplateType();
        String cacheKey = "TEMPLATE_" + editFlag + templateType + sheetName;
        String templateHtml = "";
        DeclareResponseModel declareMode = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_DATA, DeclareResponseModel.class);
        if (declareMode != null) {
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("operation", editFlag);
            customParams.put("sbbid", TreeUtils.getCache(this.getCache(), "sbbid", String.class));
            if (declareModel.getBusinessMap().containsKey("needremark")) {
                customParams.put("needremark", declareModel.getBusinessMap().get("needremark"));
            }
            ArrayList<String> sheetNames = null;
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)sheetName)) {
                String[] sheetAry;
                sheetNames = new ArrayList<String>(256);
                for (String name : sheetAry = sheetName.split(",")) {
                    sheetNames.add(name);
                }
            }
            templateHtml = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TemplateService", (String)"showTemplate", (Object[])new Object[]{declareMode.getTemplateId(), sheetNames, this.getView().getPageId(), customParams, JSONObject.toJSONString(declareMode.getDynRowList())});
            TreeUtils.putCache(this.getCache(), cacheKey, templateHtml);
        } else {
            LOGGER.info("TaxDeclarePlugin.getTemplate:\u7533\u62a5\u8868\u6a21\u677f\u4e3a\u7a7a\uff0c\u6a21\u677f\u7c7b\u578b:");
            this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7533\u62a5\u8868\u6a21\u677f\u5c1a\u672a\u7ef4\u62a4\uff0c\u6682\u4e0d\u652f\u6301\u7533\u62a5", (String)"TaxDeclarePlugin_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
        }
        return templateHtml.replace("{PAGE_ID}", this.getView().getPageId());
    }

    private List<String> queryHasHisCell() {
        String sbbid = this.getPageCache().get("sbbid");
        ArrayList<String> cellIdList = new ArrayList<String>();
        if (sbbid != null) {
            QFilter qFilter = new QFilter("sbbid", "=", (Object)sbbid);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_declare_his", (String)"cellid", (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject obj : collection) {
                String cellid = obj.getString("cellid");
                if (cellIdList.contains(cellid)) continue;
                cellIdList.add(cellid);
            }
        }
        return cellIdList;
    }

    private Map<String, String> changeToShow(Map<String, String> srcMap) {
        Map<String, String> listTab = this.getTemplateTables();
        Map<String, String> showAllMap = TemplateUtils.getAllFieldToShow(listTab);
        Map<String, EntityField> typeMap = TemplateUtils.getAllFieldTypeToShow(listTab);
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        Set<Map.Entry<String, String>> entrySet = srcMap.entrySet();
        for (Map.Entry<String, String> ent : entrySet) {
            String newkey = showAllMap.getOrDefault(ent.getKey(), ent.getKey());
            EntityField entityField = typeMap.get(newkey);
            String result = ent.getValue();
            if (newkey.contains("#")) {
                String key = newkey.replaceAll("#", "_");
                String[] ary = newkey.split("#");
                String taxTypeKey = ary[0] + "#" + ary[1] + "#taxtype";
                if ("tcret_ccxws_zb_hb".equals(ary[0]) && "ybse".equals(ary[2]) && result.contains(".") && ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"TaxDeclarePlugin_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(srcMap.get(taxTypeKey))) {
                    entityField = new EntityField();
                    entityField.setScale(2);
                    entityField.setFieldType("Decimal");
                    result = TemplateUtils.dataFormat(result, entityField);
                } else {
                    String ketTemp = ary[0] + "_1_" + ary[2];
                    result = TemplateUtils.dataFormat(ent.getValue(), typeMap.get(ketTemp));
                }
                newkey = key;
            } else {
                result = TemplateUtils.dataFormat(ent.getValue(), entityField);
            }
            dataMap.put(newkey, result);
        }
        return dataMap;
    }

    private Map<String, String> getAllFieldToSave() {
        String templateType = this.getPageCache().get("templatetype");
        Map<String, String> saveFieldMap = TreeUtils.getCache(this.getCache(), "AllFieldToSave" + templateType, Map.class);
        if (saveFieldMap == null) {
            saveFieldMap = TemplateUtils.getAllFieldToSave(this.getTemplateTables());
            TreeUtils.putCache(this.getCache(), "AllFieldToSave" + templateType, saveFieldMap);
        }
        return saveFieldMap;
    }

    private void refresh(Map<String, String> dataMap, String sheetName, String operation) {
        long start = System.currentTimeMillis();
        String sheetId = StringUtil.isNotBlank((CharSequence)this.getPageCache().get("sheetid")) ? this.getPageCache().get("sheetid") : "0";
        Map<String, String> showData = this.changeToShow(dataMap);
        this.queryBaseData(showData);
        String template = this.getPageCache().get(HTML_TEMPLATE);
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)template)) {
            template = this.getTemplate(sheetName, operation);
            this.getPageCache().put(HTML_TEMPLATE, template);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("template", template);
        map.put("operation", operation);
        map.put("sheetid", "tab-item-content" + this.getView().getPageId() + sheetId);
        map.put(CACHE_UPDATA_FOCUS, this.getPageCache().get(CACHE_UPDATA_FOCUS));
        map.put("pageid", this.getView().getPageId());
        CustomControl control = (CustomControl)this.getControl(CUSTOM_CONTROL);
        HashMap<String, Object> showDataMap = new HashMap<String, Object>(4);
        IPageCache pageCache = this.getCache();
        DeclareResponseModel declareMode = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_DATA, DeclareResponseModel.class);
        pageCache.put("templateid", declareMode.getTemplateId().toString());
        DeclareRequestModel declareModel = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_REQUEST, DeclareRequestModel.class);
        pageCache.put("templatetype", declareModel.getTemplateType());
        Map<String, String> currentMap = TreeUtils.getCache(this.getPageCache(), CACHE_UPDATA_CELLID_SAVE, Map.class);
        ArrayList checkFormulaList = (ArrayList)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"FormulaService", (String)"checkFormula", (Object[])new Object[]{JSON.toJSONString((Object)declareModel), null != currentMap ? currentMap : declareMode.getData(), declareMode.getParamMap()});
        if (checkFormulaList == null) {
            checkFormulaList = new ArrayList();
        }
        showDataMap.putAll(showData);
        showDataMap.put("riskwarning", checkFormulaList);
        showDataMap.put("riskwarningSize", checkFormulaList.size());
        map.put("data", showDataMap);
        if ("read".equals(operation)) {
            List<String> hisCellList = this.queryHasHisCell();
            ArrayList list = new ArrayList(hisCellList.size());
            for (String str : hisCellList) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("id", str);
                list.add(m);
            }
            map.put("hisCells", list);
        }
        control.setData(map);
        LOGGER.info("TaxDeclarePlugin.refresh:" + (System.currentTimeMillis() - start));
    }

    private void queryBaseData(Map<String, String> showData) {
        long start = System.currentTimeMillis();
        HashMap<String, List> pkListMap = new HashMap<String, List>();
        HashMap<String, List> basePkCellListMap = new HashMap<String, List>();
        HashMap<String, List<String>> baseSelectFieldMap = new HashMap<String, List<String>>();
        HashMap<String, String> displayPopMap = new HashMap<String, String>();
        DeclareRequestModel declareModel = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_REQUEST, DeclareRequestModel.class);
        String templateType = declareModel.getTemplateType();
        HashMap<String, FormulaVo> cellTypeMap = new HashMap<String, FormulaVo>();
        String formulasStr = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"FormulaService", (String)"queryDBCellConfig", (Object[])new Object[]{templateType, declareModel.getSkssqq(), declareModel.getSkssqz(), null == declareModel.getTemplateId() ? "" : Long.toString(declareModel.getTemplateId())});
        List<FormulaVo> formulas = JsonUtil.fromJsonList(formulasStr, FormulaVo.class);
        DeclareResponseModel declareMode = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_DATA, DeclareResponseModel.class);
        List<DynamicRowModel> dynamicRowList = declareMode.getDynRowList();
        for (FormulaVo formulaVo : formulas) {
            String celltype = formulaVo.getCellType();
            if (!"3".equals(celltype) && !"4".equals(celltype) && !"5".equals(celltype)) continue;
            cellTypeMap.put(formulaVo.getFormulaKey().replace('#', '_'), formulaVo);
            if (CollectionUtils.isEmpty(dynamicRowList)) continue;
            String[] formulakeySplit = formulaVo.getFormulaKey().split("#");
            String dynamicRowNo = formulakeySplit[0] + "#" + formulakeySplit[1];
            DynamicRowModel dynamicRowModel = dynamicRowList.stream().filter(e -> null != e.getDynRowNo() && e.getDynRowNo().equals(dynamicRowNo)).findFirst().orElse(null);
            if (null == dynamicRowModel || dynamicRowModel.getRowList() == null) continue;
            int dynamicRowSize = dynamicRowModel.getRowList().size();
            for (int i = Integer.parseInt(formulakeySplit[1]) + 1; i < dynamicRowSize + 1; ++i) {
                String formulakey = formulakeySplit[0] + '_' + i + '_' + formulakeySplit[2];
                cellTypeMap.put(formulakey, formulaVo);
            }
        }
        for (Map.Entry entry : cellTypeMap.entrySet()) {
            Map<String, String> itemMap;
            FormulaVo formulaVo;
            String celltype;
            String key = (String)entry.getKey();
            String text = showData.get(key);
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)kd.bos.dataentity.utils.StringUtils.trimToEmpty((String)text)) || !"3".equals(celltype = (formulaVo = (FormulaVo)cellTypeMap.get(key)).getCellType()) && !"4".equals(celltype) && !"5".equals(celltype)) continue;
            if ("3".equals(celltype) || "4".equals(celltype)) {
                String[] strs;
                for (String s2 : strs = text.split(",")) {
                    showData.put(key + s2, s2);
                }
                continue;
            }
            if (!"5".equals(celltype) || (itemMap = TemplateShowUtils.parseCellType(formulaVo.getFormulaName())).isEmpty()) continue;
            Map.Entry<String, String> cellTypeEntry = itemMap.entrySet().iterator().next();
            String baseId = cellTypeEntry.getKey() + "&" + key;
            String basetext = cellTypeEntry.getValue();
            String valIndex = baseId + text;
            List cellList = basePkCellListMap.getOrDefault(baseId, new ArrayList());
            showData.put(key + "_text", showData.get(key + "jsmsextval"));
            cellList.add(key);
            basePkCellListMap.put(valIndex, cellList);
            List pkList = pkListMap.getOrDefault(baseId, new ArrayList());
            if (!pkList.contains(text)) {
                pkList.add(text);
            }
            List<String> selectFieldList = TemplateShowUtils.parseBaseDataFieldList(basetext);
            baseSelectFieldMap.put(baseId, selectFieldList);
            pkListMap.put(baseId, pkList);
            displayPopMap.put(key, basetext);
        }
        for (Map.Entry entry : pkListMap.entrySet()) {
            QFilter qFilter = new QFilter("id", "in", ((List)entry.getValue()).stream().map(s -> Long.parseLong(s)).collect(Collectors.toList()));
            List fieldList = (List)baseSelectFieldMap.get(entry.getKey());
            DynamicObjectCollection resultCollection = QueryServiceHelper.query((String)((String)entry.getKey()).split("&")[0], (String)String.join((CharSequence)",", fieldList), (QFilter[])new QFilter[]{qFilter});
            if (resultCollection == null) continue;
            for (DynamicObject result : resultCollection) {
                String valIndex = (String)entry.getKey() + result.getString("id");
                List cellList = (List)basePkCellListMap.get(valIndex);
                if (cellList == null) {
                    cellList = (List)basePkCellListMap.get(valIndex + ".00");
                }
                if (cellList == null) continue;
                for (String key : cellList) {
                    String display = (String)displayPopMap.get(key);
                    showData.put(key + "_text", TemplateShowUtils.getDisplayText(display, result));
                }
            }
        }
        LOGGER.info("TaxDeclarePlugin.queryBaseData:" + (System.currentTimeMillis() - start));
    }

    private String getItemName(String value, Map<String, String> itemMap) {
        if (value == null || itemMap == null) {
            return null;
        }
        String[] strs = value.split(",");
        StringBuilder sb = new StringBuilder();
        int size = itemMap.size();
        for (String str : strs) {
            String text = itemMap.get(str);
            if (size == 1 && itemMap.containsKey(str) && kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)text)) {
                sb.append(ResManager.loadKDString((String)"\u9009\u62e9", (String)"TaxDeclarePlugin_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                continue;
            }
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)text)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(text);
        }
        return sb.toString();
    }

    private IPageCache getCache() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ParentCache = (String)customParams.get("ParentCache");
        if (Boolean.TRUE.toString().equals(ParentCache)) {
            String parentpageId = (String)customParams.get("rootPageId");
            IFormView parentView = this.getView().getParentView();
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)parentpageId)) {
                parentView = this.getView().getView(parentpageId);
            }
            IPageCache f = (IPageCache)parentView.getService(IPageCache.class);
            return f;
        }
        return this.getPageCache();
    }

    private Map<String, String> getTemplateTables() {
        DeclareResponseModel model = TreeUtils.getCache(this.getPageCache(), CACHE_DECLARE_DATA, DeclareResponseModel.class);
        Map<String, String> map = model.getMetaDataMap();
        if (EmptyCheckUtils.isNotEmpty(map)) {
            return map;
        }
        return Collections.emptyMap();
    }
}

