/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.db.DataSaveService;
import kd.taxc.bdtaxr.common.db.MapToTableUtils;
import kd.taxc.bdtaxr.common.db.NewObjectUtils;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.handler.QueryOrSaveDeclareHandler;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.declare.initparam.InitParamsService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.request.FormulaRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.service.DeclareService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.DraftMatchDeclareEnum;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.enums.tpo.ModelVersionEnum;
import kd.taxc.bdtaxr.common.helper.SourceOperateHelper;
import kd.taxc.bdtaxr.common.helper.YbnsrServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.datasynchronize.DataSynchronizeMQSender;
import kd.taxc.bdtaxr.common.mq.datasynchronize.SynchronizeParam;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class DeclareServiceHelper
implements QueryOrSaveDeclareHandler {
    private static final String GENERATE_SBBNO_LOCK_KEY = "GENERATE_SBBNO_";
    private static final long LOCK_TIMEOUT = 30000L;
    private static Log logger = LogFactory.getLog(DeclareServiceHelper.class);

    public static String generateSBBNo(String entityName) {
        return DeclareServiceHelper.generateSBBNo(entityName, null, null);
    }

    public static String generateSBBNo(String entityName, String orgId) {
        return DeclareServiceHelper.generateSBBNo(entityName, null, orgId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String generateSBBNo(String entityName, DynamicObject dynamicObject, String orgId) {
        if (StringUtils.isBlank((CharSequence)entityName)) {
            entityName = "tcvat_nsrxx";
        }
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        }
        try (DLock lock = DLock.create((String)(GENERATE_SBBNO_LOCK_KEY + entityName));){
            lock.lock();
            CodeRuleServiceHelper.getNumber((String)entityName, (DynamicObject)dynamicObject, (String)orgId);
            String string = CodeRuleServiceHelper.readNumber((String)entityName, (DynamicObject)dynamicObject, (String)orgId);
            return string;
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] batchGenerateSBBNos(String entityName, String orgId, int count) {
        if (StringUtils.isBlank((CharSequence)entityName)) {
            entityName = "tcvat_nsrxx";
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        try (DLock lock = DLock.create((String)(GENERATE_SBBNO_LOCK_KEY + entityName));){
            lock.lock();
            CodeRuleServiceHelper.getNumber((String)entityName, (DynamicObject)dynamicObject, (String)orgId);
            String[] stringArray = CodeRuleServiceHelper.getBatchNumber((String)entityName, (DynamicObject)dynamicObject, (String)orgId, (int)count);
            return stringArray;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public static Long generateSBBId(String entityName) {
        if (StringUtils.isNotBlank((CharSequence)entityName)) {
            return DBServiceHelper.genLongIds((String)entityName, (int)1)[0];
        }
        return DBServiceHelper.genLongIds((String)"tcvat_nsrxx", (int)1)[0];
    }

    public static DeclareResponseModel queryData(DeclareRequestModel declareModel) {
        Long templateId;
        DeclareResponseModel responseModel = new DeclareResponseModel();
        if (null == declareModel) {
            return responseModel;
        }
        Long id = declareModel.getId() != null ? declareModel.getId() : DeclareServiceHelper.generateSBBId(null);
        declareModel.setId(id);
        HashMap<String, String> data = new HashMap();
        Long l = templateId = declareModel.getTemplateId() != null ? declareModel.getTemplateId() : DeclareServiceHelper.getTemplateId(declareModel);
        if (null == templateId) {
            return responseModel;
        }
        HashMap<String, String> metaMap = new HashMap();
        declareModel.setTemplateId(templateId);
        metaMap = TemplateFormulaServiceHelper.getMetaDataListByTmpId(templateId);
        declareModel.setMetaDataMap(metaMap);
        List<DynamicRowModel> dynRowList = null;
        if (declareModel.getRefresh() == null) {
            declareModel.setRefresh(Boolean.FALSE);
        }
        FormulaRequestModel formulaRequest = new FormulaRequestModel();
        formulaRequest.setTemplateId(templateId);
        Map<String, String> businessMap = InitParamsService.getInitParams(declareModel.getTemplateType()).buildBizParam(declareModel);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, Object> ruleParamMap = new HashMap<String, Object>();
        ruleParamMap.put("sbbid", id);
        ruleParamMap.put("orgId", declareModel.getOrgId());
        if (declareModel.getExtendParams() != null && declareModel.getExtendParams().size() > 0) {
            ruleParamMap.putAll(declareModel.getExtendParams());
        }
        if (businessMap != null) {
            paramMap.putAll(businessMap);
            ruleParamMap.putAll(businessMap);
        }
        if (declareModel.getBusinessValue("maindataid") != null) {
            ruleParamMap.put("maindataid", Long.valueOf(declareModel.getBusinessValue("maindataid")));
        }
        formulaRequest.setRuleParamMap(ruleParamMap);
        formulaRequest.setParamMap(paramMap);
        if (declareModel.getRefresh().booleanValue()) {
            dynRowList = TemplateFormulaServiceHelper.getDynamicRowList(formulaRequest, declareModel.getRefresh(), null);
            formulaRequest.setDynRowList(dynRowList);
            DeclareService declareService = new DeclareService();
            Map<String, String> nsrxxMap = new DeclareService().createYbnsr(declareModel, true);
            logger.info("nsrxxMap:" + (nsrxxMap == null ? "null" : nsrxxMap.toString()));
            formulaRequest.setDataMap(nsrxxMap);
            Map<String, EntityField> typeMap = TemplateUtils.getAllFieldTypeToShow(metaMap);
            HashMap<String, EntityField> addedMetaTypeMap = new HashMap<String, EntityField>();
            for (Map.Entry<String, EntityField> entry : typeMap.entrySet()) {
                String key = entry.getKey().toString();
                DynamicRowModel dyn = DynamicRowService.matchDyn(dynRowList, key);
                if (dyn == null || dyn.getRowList() == null || dyn.getRowList().size() <= 1) continue;
                for (int i = 1; i < dyn.getRowList().size(); ++i) {
                    String newKey = DynamicRowService.getNewKey(key, i + 1);
                    addedMetaTypeMap.put(newKey, entry.getValue());
                }
            }
            if (!addedMetaTypeMap.isEmpty()) {
                typeMap.putAll(addedMetaTypeMap);
            }
            Map<String, String> calMap = TemplateFormulaServiceHelper.initCal(formulaRequest, metaMap, typeMap);
            Iterator<String> it = calMap.keySet().iterator();
            while (it.hasNext()) {
                String t = it.next();
                if (!StringUtil.isEmpty((CharSequence)t) && t.contains("#") && declareService.checkTable(metaMap, t) && !declareService.isDelKey(dynRowList, t)) continue;
                it.remove();
            }
            data.putAll(calMap);
            if (nsrxxMap != null) {
                data.putAll(nsrxxMap);
            }
            DeclareServiceHelper.addDefaultData(data, metaMap, dynRowList, templateId);
        } else {
            Map<String, DynamicObjectCollection> map = YbnsrService.queryYbnsrTable(String.valueOf(declareModel.getId()), metaMap);
            formulaRequest.setParamMap(paramMap);
            dynRowList = TemplateFormulaServiceHelper.getDynamicRowList(formulaRequest, declareModel.getRefresh(), map);
            data = MapToTableUtils.tableToMap(map, metaMap);
        }
        responseModel.setId(id);
        responseModel.setTemplateId(templateId);
        responseModel.setMetaDataMap(metaMap);
        responseModel.setData(data);
        responseModel.setDynRowList(dynRowList);
        HashMap<String, String> param = new HashMap<String, String>();
        for (Map.Entry entry : paramMap.entrySet()) {
            try {
                param.put((String)entry.getKey(), entry.getValue().toString());
            }
            catch (Exception e) {
                logger.error("Illigal params:" + e);
            }
        }
        responseModel.setParamMap(param);
        return responseModel;
    }

    private static void addDefaultData(Map<String, String> data, Map<String, String> metaMap, List<DynamicRowModel> dynRowList, Long templateId) {
        HashMap<String, String> dynTableMap = new HashMap<String, String>();
        if (dynRowList != null) {
            for (DynamicRowModel dynamicRowModel : dynRowList) {
                String dynRowNo = dynamicRowModel.getDynRowNo();
                String tableName = dynRowNo.split("#")[0];
                dynTableMap.put(tableName, tableName);
            }
        }
        Map<String, EntityField> entityFieldMap = TemplateUtils.getAllEntity(metaMap);
        Map<String, Set<String>> metadataRowList = TemplateFormulaServiceHelper.getMetadataRowList(templateId);
        entityFieldMap.entrySet().stream().forEach(v -> {
            String key = (String)v.getKey();
            String[] split = key.split("#");
            String tableName = split[0];
            EntityField fieldType = (EntityField)v.getValue();
            if ("Decimal".equals(fieldType.getFieldType()) && !data.containsKey(key) && !dynTableMap.containsKey(tableName)) {
                Set formulaRows = (Set)metadataRowList.get(tableName);
                if ("tctb_declare_entry".equals(tableName)) {
                    String prefix = split[0] + "#" + split[1] + "#";
                    if (formulaRows.contains(prefix)) {
                        data.put(key, TemplateUtils.dataFormatPreSave("0", fieldType));
                    }
                } else {
                    data.put(key, TemplateUtils.dataFormatPreSave("0", fieldType));
                }
            }
        });
    }

    @Override
    public Map<String, String> save(DeclareRequestModel declareRequest, Map<String, String> newData, Map<String, String> oldData, Map<String, String> metaMap) {
        return DeclareServiceHelper.saveData(declareRequest, newData, oldData, metaMap);
    }

    @Override
    public void savePost(DeclareRequestModel requestModel, DeclareResponseModel responseModel) {
        List checkFormulaList = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"FormulaService", (String)"checkFormulasNew", (Object[])new Object[]{requestModel, responseModel.getData(), responseModel.getParamMap(), responseModel.getDynRowList()});
        DeclareService declareService = new DeclareService();
        boolean b = declareService.saveRiskItem(responseModel.getId().toString(), checkFormulaList, null, 2);
    }

    @Override
    public DeclareResponseModel query(DeclareRequestModel declareModel) {
        return DeclareServiceHelper.queryData(declareModel);
    }

    public static Map<String, String> saveData(DeclareRequestModel declareRequest, Map<String, String> newData, Map<String, String> oldData, Map<String, String> metaMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (null == declareRequest || null == declareRequest.getId() || null == newData) {
            return result;
        }
        DynamicObject declareObj = null;
        Long id = declareRequest.getId();
        DLock lock = null;
        String unitKey = declareRequest.getUniKey();
        if (StringUtil.isNotBlank((CharSequence)unitKey)) {
            lock = DLock.create((String)unitKey);
            boolean getLock = lock.tryLock();
            if (!getLock) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u6b63\u5728\u4fdd\u5b58\u7684\u540c\u7ec4\u7ec7\u5c5e\u671f\u7684\u62a5\u8868\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01", (String)"DeclareServiceHelper_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            declareObj = YbnsrServiceHelper.queryYbnsrWithEx(String.valueOf(declareRequest.getOrgId()), declareRequest.getTemplateType(), declareRequest.getSkssqq(), declareRequest.getSkssqz(), declareRequest.getExtendParams());
        } else {
            QFilter qFilter = new QFilter("id", "=", (Object)id);
            declareObj = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"*", (QFilter[])new QFilter[]{qFilter});
        }
        try {
            boolean isCreate = false;
            if (declareObj != null) {
                isCreate = true;
                if (declareRequest.getRefresh().booleanValue() && "edit".equals(declareRequest.getOperation())) {
                    logger.info("\u8fdb\u6765\u91cd\u7f6e\uff01");
                    Long sbbId = declareObj.getLong("id");
                    declareRequest.setId(sbbId);
                    newData.put(NewObjectUtils.getIdByKey("tcvat_nsrxx"), String.valueOf(sbbId));
                    String billnoKey = "tcvat_nsrxx#1#billno";
                    newData.put(billnoKey, declareObj.getString("billno"));
                    DeclareServiceHelper.resetBySbbId(declareRequest);
                    HashMap<String, DynamicObjectCollection> data = new HashMap<String, DynamicObjectCollection>();
                    DynamicObjectCollection temp = new DynamicObjectCollection();
                    declareObj = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"*", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sbbId)});
                    temp.add((Object)declareObj);
                    data.put("tcvat_nsrxx", temp);
                    Map<String, String> map = MapToTableUtils.tableToMap(data, declareRequest.getTemplateType());
                    oldData = map;
                }
            } else {
                oldData = new HashMap<String, String>();
            }
            HashMap<String, String> tempMap = new HashMap<String, String>(16);
            newData.forEach((k, v) -> {
                if (k.contains("#")) {
                    tempMap.put((String)k, (String)v);
                }
            });
            newData = tempMap;
            Map<String, DynamicObjectCollection> map = DataSaveService.mapToTable("tcvat_nsrxx", newData, oldData, metaMap);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        SourceOperateHelper.saveSourceEntity(declareRequest.getTemplateType(), declareRequest.getId().toString());
        DataSaveService.updatePrepayBill(declareRequest);
        DeclareServiceHelper.revWriteDraft(declareRequest);
        DeclareServiceHelper.synchronizeEntryData(declareRequest);
        return result;
    }

    private static void synchronizeEntryData(DeclareRequestModel declareRequest) {
        Long sbbid = declareRequest.getId();
        SynchronizeParam param = new SynchronizeParam(sbbid, declareRequest.getTemplateType(), declareRequest.getOrgId());
        DataSynchronizeMQSender.sendMessage(param);
        DynamicObject nxxObj = BusinessDataServiceHelper.loadSingle((Object)sbbid, (String)"tcvat_nsrxx");
        DeclareMQSender.sendTaxableListMQ(nxxObj, nxxObj.getDate("skssqq"), nxxObj.getDate("skssqz"), DeclareMQType.DECLARE.name(), DeclareMQEvent.SAVE.name());
        DeclareMainServiceHelper.fireDeclareMainChangeEvent(Collections.singletonList(sbbid), Collections.singletonList(nxxObj), (ModelVersionEnum)ModelVersionEnum.MODEL2, (DeclareOperationEnum)DeclareOperationEnum.SAVE, (String)"bdtaxr", null);
    }

    private static void revWriteDraft(DeclareRequestModel requestModel) {
        String templateType = requestModel.getTemplateType();
        try {
            List<String> declareTypes = Arrays.asList("qysdsjb", "qysds_hdzs_jb", "qysdsnb", "qysdsnb_fzjg", "qysds_hdzs_nb", "zzsybnsr", "zzsxgmnsr", "zzsybnsr_ybhz", "zzsybnsr_yz_zjg", "zzsybnsr_hz_zjg");
            if (!declareTypes.contains(templateType)) {
                return;
            }
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"tctb_draft_main", (String)"id,isdeclare,sbbno", (QFilter[])new QFilter[]{new QFilter("startdate", "=", (Object)DateUtils.stringToDate(requestModel.getSkssqq())), new QFilter("enddate", "=", (Object)DateUtils.stringToDate(requestModel.getSkssqz())), new QFilter("org", "=", (Object)requestModel.getOrgId()), new QFilter("draftpurpose", "=", (Object)"nssb"), new QFilter("isdeclare", "=", (Object)"0"), new QFilter("templatetype", "=", (Object)DraftMatchDeclareEnum.getDraftByDeclare(requestModel.getTemplateType()))});
            if (object != null) {
                object.set("isdeclare", (Object)"1");
                object.set("sbbno", (Object)requestModel.getBillNo());
                if (StringUtil.isEmpty((CharSequence)requestModel.getBillNo())) {
                    object.set("sbbno", (Object)DeclareServiceHelper.getDeclareBillno(requestModel.getOrgId(), requestModel.getSkssqq(), requestModel.getSkssqz(), requestModel.getTemplateType()));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
        }
        catch (Exception e) {
            logger.info("\u5e95\u7a3f\u53cd\u5199\u7533\u62a5\u8868\u662f\u5426\u7533\u62a5\u5b57\u6bb5\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    private static String getDeclareBillno(Long orgid, String startdate, String enddate, String templatetype) {
        DynamicObject declare = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"billno", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgid), new QFilter("skssqq", "=", (Object)DateUtils.stringToDate(startdate)), new QFilter("skssqz", "=", (Object)DateUtils.stringToDate(enddate)), new QFilter("type", "in", (Object)templatetype)});
        if (declare == null) {
            return null;
        }
        return declare.getString("billno");
    }

    public static void deleteBySbbId(Long sbbId) {
        if (sbbId != null) {
            YbnsrService.deleteYbnsrTable(sbbId.toString());
        }
    }

    public static void resetBySbbId(DeclareRequestModel declareModel) {
        if (declareModel != null && declareModel.getId() != null) {
            DynamicObject declareMain = BusinessDataServiceHelper.loadSingle((Object)declareModel.getId(), (String)"tcvat_nsrxx");
            String templateId = declareMain.getString("templateid");
            if (StringUtil.isEmpty((CharSequence)templateId)) {
                templateId = String.valueOf(DeclareServiceHelper.getTemplateId(declareModel));
            }
            YbnsrService.resetYbnsrTable(String.valueOf(declareModel.getId()), templateId);
        }
    }

    public static Long getTemplateId(DeclareRequestModel declareModel) {
        if (null == declareModel || StringUtils.isBlank((CharSequence)declareModel.getSkssqq()) || StringUtils.isBlank((CharSequence)declareModel.getSkssqz()) || StringUtils.isBlank((CharSequence)declareModel.getTemplateType())) {
            return null;
        }
        return new DeclareService().getTemplateId(declareModel);
    }

    public static boolean exists(String sbbid) {
        if (EmptyCheckUtils.isNotEmpty(sbbid)) {
            return QueryServiceHelper.exists((String)"tcvat_nsrxx", (Object)Long.parseLong(sbbid));
        }
        return false;
    }

    public static DynamicObject queryOneProvisionPlan(List<Long> orgIdList, Date startDate, Date endDate, Long categoryId, Long taxationsysId, String draftType) {
        List data;
        TaxResult result = ProvisionSharePlanDataServiceHelper.querySharePlanByOrgIdsAndCategoryIdAndDateRange(orgIdList, (Long)categoryId, (Long)taxationsysId, (Date)startDate, (Date)endDate, (Boolean)("sjjt".equalsIgnoreCase(draftType) ? Boolean.valueOf(true) : null), (Boolean)("nssb".equalsIgnoreCase(draftType) ? Boolean.valueOf(true) : null));
        if (ObjectUtils.isNotEmpty((Object)result) && result.isSuccess() && ObjectUtils.isNotEmpty((Object)result.getData()) && !CollectionUtils.isEmpty((Collection)(data = (List)result.getData()))) {
            for (DynamicObject datum : data) {
                if (!datum.getBoolean("ruleentity.rule.isdimprovision")) continue;
                return datum;
            }
        }
        return null;
    }

    public static void setAccrualPlanId(String orgid, String startdate, String enddate, String draftpurpose, DynamicObject object) {
        DynamicObject provisionSharePlanObj = DeclareServiceHelper.queryOneProvisionPlan(Collections.singletonList(Long.valueOf(orgid)), DateUtils.stringToDate(startdate), DateUtils.stringToDate(enddate), 1L, 1L, draftpurpose);
        if (null != provisionSharePlanObj) {
            object.set("accrualplan", (Object)provisionSharePlanObj.getString("ruleentity.rule"));
        } else {
            object.set("accrualplan", null);
        }
    }
}

