/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.helper;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.DataSaveService;
import kd.taxc.bdtaxr.common.db.MapToTableUtils;
import kd.taxc.bdtaxr.common.db.NewObjectUtils;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.handler.QueryOrSaveDeclareHandler;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.declare.initparam.InitParamsService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.request.FormulaRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.service.DeclareService;
import kd.taxc.bdtaxr.common.helper.YbnsrServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class DrawBackDeclareServiceHelper
implements QueryOrSaveDeclareHandler {
    private static Log logger = LogFactory.getLog(DrawBackDeclareServiceHelper.class);
    public static final String ENTITY_MAIN = "tcetr_declare_main";

    public static Long generateSBBId(String entityName) {
        if (StringUtils.isNotBlank((CharSequence)entityName)) {
            return DBServiceHelper.genLongIds((String)entityName, (int)1)[0];
        }
        return DBServiceHelper.genLongIds((String)ENTITY_MAIN, (int)1)[0];
    }

    @Override
    public DeclareResponseModel query(DeclareRequestModel declareModel) {
        Long templateId;
        DeclareResponseModel responseModel = new DeclareResponseModel();
        if (null == declareModel) {
            return responseModel;
        }
        Long id = declareModel.getId() != null ? declareModel.getId() : DrawBackDeclareServiceHelper.generateSBBId(null);
        declareModel.setId(id);
        HashMap<String, String> data = new HashMap();
        Long l = templateId = declareModel.getTemplateId() != null ? declareModel.getTemplateId() : DrawBackDeclareServiceHelper.getTemplateId(declareModel);
        if (null == templateId) {
            return responseModel;
        }
        HashMap<String, String> metaMap = new HashMap();
        declareModel.setTemplateId(templateId);
        metaMap = TemplateFormulaServiceHelper.getMetaDataListByTmpId(templateId);
        List<DynamicRowModel> dynRowList = null;
        if (declareModel.getRefresh() == null) {
            declareModel.setRefresh(Boolean.FALSE);
        }
        FormulaRequestModel formulaRequest = new FormulaRequestModel();
        formulaRequest.setTemplateId(templateId);
        Map<String, String> businessMap = InitParamsService.getInitParams(declareModel.getTemplateType()).buildBizParam(declareModel);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, Object> ruleParamMap = new HashMap<String, Object>();
        ruleParamMap.put("orgId", declareModel.getOrgId());
        if (declareModel.getExtendParams() != null && declareModel.getExtendParams().size() > 0) {
            ruleParamMap.putAll(declareModel.getExtendParams());
        }
        if (businessMap != null) {
            paramMap.putAll(businessMap);
            ruleParamMap.putAll(businessMap);
        }
        formulaRequest.setRuleParamMap(ruleParamMap);
        formulaRequest.setParamMap(paramMap);
        if (declareModel.getRefresh().booleanValue()) {
            dynRowList = TemplateFormulaServiceHelper.getDynamicRowList(formulaRequest, declareModel.getRefresh(), null);
            formulaRequest.setDynRowList(dynRowList);
            DeclareService declareService = new DeclareService();
            Map<String, String> nsrxxMap = new DeclareService().createYbnsr(declareModel, true);
            formulaRequest.setDataMap(nsrxxMap);
            Map<String, EntityField> typeMap = TemplateUtils.getAllFieldTypeToShow(metaMap);
            HashMap<String, EntityField> addedMetaTypeMap = new HashMap<String, EntityField>();
            for (Map.Entry<String, EntityField> entry : typeMap.entrySet()) {
                String key = entry.getKey().toString();
                DynamicRowModel dyn = DynamicRowService.matchDyn(dynRowList, key);
                if (dyn == null || dyn.getRowList() == null || dyn.getRowList().size() <= 1) continue;
                for (int i = 1; i < dyn.getRowList().size(); ++i) {
                    String newKey = DynamicRowService.getNewKey(key, i + 1);
                    addedMetaTypeMap.put(newKey, entry.getValue());
                }
            }
            if (!addedMetaTypeMap.isEmpty()) {
                typeMap.putAll(addedMetaTypeMap);
            }
            Map<String, String> calMap = TemplateFormulaServiceHelper.initCal(formulaRequest, metaMap, typeMap);
            Iterator<String> it = calMap.keySet().iterator();
            while (it.hasNext()) {
                String t = it.next();
                if (!StringUtil.isEmpty((CharSequence)t) && t.contains("#") && declareService.checkTable(metaMap, t) && !declareService.isDelKey(dynRowList, t)) continue;
                it.remove();
            }
            data.putAll(calMap);
            data.putAll(nsrxxMap);
            DrawBackDeclareServiceHelper.addDefaultData(data, metaMap, dynRowList);
        } else {
            Map<String, DynamicObjectCollection> map = YbnsrService.queryYbnsrTable(String.valueOf(declareModel.getId()), metaMap);
            formulaRequest.setParamMap(paramMap);
            dynRowList = TemplateFormulaServiceHelper.getDynamicRowList(formulaRequest, declareModel.getRefresh(), map);
            data = MapToTableUtils.tableToMap(map, metaMap);
        }
        responseModel.setId(id);
        responseModel.setTemplateId(templateId);
        responseModel.setMetaDataMap(metaMap);
        responseModel.setData(data);
        responseModel.setDynRowList(dynRowList);
        HashMap<String, String> param = new HashMap<String, String>();
        for (Map.Entry entry : paramMap.entrySet()) {
            try {
                param.put((String)entry.getKey(), entry.getValue().toString());
            }
            catch (Exception e) {
                logger.error("Illigal params:" + e);
            }
        }
        responseModel.setParamMap(param);
        return responseModel;
    }

    private static void addDefaultData(Map<String, String> data, Map<String, String> metaMap, List<DynamicRowModel> dynRowList) {
        HashMap<String, String> dynTableMap = new HashMap<String, String>();
        if (dynRowList != null) {
            for (DynamicRowModel dynamicRowModel : dynRowList) {
                String dynRowNo = dynamicRowModel.getDynRowNo();
                String tableName = dynRowNo.split("#")[0];
                dynTableMap.put(tableName, tableName);
            }
        }
        Map<String, EntityField> entityFieldMap = TemplateUtils.getAllEntity(metaMap);
        entityFieldMap.entrySet().stream().forEach(v -> {
            String key = (String)v.getKey();
            String tableName = key.split("#")[0];
            EntityField fieldType = (EntityField)v.getValue();
            if ("Decimal".equals(fieldType.getFieldType()) && !data.containsKey(key) && !dynTableMap.containsKey(tableName)) {
                data.put(key, TemplateUtils.dataFormatPreSave("0", fieldType));
            }
        });
    }

    @Override
    public Map<String, String> save(DeclareRequestModel declareRequest, Map<String, String> newData, Map<String, String> oldData, Map<String, String> metaMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (null == declareRequest || null == declareRequest.getId() || null == newData) {
            return result;
        }
        DynamicObject declareObj = null;
        Long id = declareRequest.getId();
        DLock lock = null;
        String unitKey = declareRequest.getUniKey();
        if (StringUtil.isNotBlank((CharSequence)unitKey)) {
            lock = DLock.create((String)unitKey);
            boolean getLock = lock.tryLock();
            if (!getLock) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u6b63\u5728\u4fdd\u5b58\u7684\u540c\u7ec4\u7ec7\u5c5e\u671f\u7684\u62a5\u8868\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01", (String)"DrawBackDeclareServiceHelper_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            declareObj = YbnsrServiceHelper.queryYbnsrWithEx(String.valueOf(declareRequest.getOrgId()), declareRequest.getTemplateType(), declareRequest.getSkssqq(), declareRequest.getSkssqz(), declareRequest.getExtendParams());
        } else {
            QFilter qFilter = new QFilter("id", "=", (Object)id);
            declareObj = QueryServiceHelper.queryOne((String)ENTITY_MAIN, (String)"*", (QFilter[])new QFilter[]{qFilter});
        }
        boolean isCreate = false;
        try {
            if (declareObj != null) {
                isCreate = true;
                if (declareRequest.getRefresh().booleanValue() && "edit".equals(declareRequest.getOperation())) {
                    logger.error("\u8fdb\u6765\u91cd\u7f6e\uff01");
                    Long sbbId = declareObj.getLong("id");
                    declareRequest.setId(sbbId);
                    newData.put(NewObjectUtils.getIdByKey("tcvat_nsrxx"), String.valueOf(sbbId));
                    String billnoKey = "tcvat_nsrxx#1#billno";
                    newData.put(billnoKey, declareObj.getString("billno"));
                    DrawBackDeclareServiceHelper.resetBySbbId(declareRequest);
                    HashMap<String, DynamicObjectCollection> data = new HashMap<String, DynamicObjectCollection>();
                    DynamicObjectCollection temp = new DynamicObjectCollection();
                    declareObj = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"*", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sbbId)});
                    temp.add((Object)declareObj);
                    data.put(ENTITY_MAIN, temp);
                    Map<String, String> map = MapToTableUtils.tableToMap(data, declareRequest.getTemplateType());
                    oldData = map;
                }
            } else {
                oldData = new HashMap<String, String>(32);
            }
            HashMap<String, String> tempMap = new HashMap<String, String>(16);
            newData.entrySet().stream().filter(s -> ((String)s.getKey()).contains("#")).forEach(s -> {
                String cfr_ignored_0 = (String)tempMap.put((String)s.getKey(), (String)s.getValue());
            });
            newData = tempMap;
            Map<String, DynamicObjectCollection> map = DataSaveService.mapToTable(ENTITY_MAIN, newData, oldData, metaMap);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return result;
    }

    public static void deleteBySbbId(Long sbbId) {
        if (sbbId != null) {
            YbnsrService.deleteYbnsrTable(sbbId.toString());
        }
    }

    public static void resetBySbbId(DeclareRequestModel declareModel) {
    }

    public static Long getTemplateId(DeclareRequestModel declareModel) {
        if (null == declareModel || StringUtils.isBlank((CharSequence)declareModel.getSkssqq()) || StringUtils.isBlank((CharSequence)declareModel.getSkssqz()) || StringUtils.isBlank((CharSequence)declareModel.getTemplateType())) {
            return null;
        }
        return new DeclareService().getTemplateId(declareModel);
    }
}

