/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.DataSaveService;
import kd.taxc.bdtaxr.common.declare.handler.TaxBureauDataHandler;
import kd.taxc.bdtaxr.common.declare.handler.TaxBureauDataServiceFactory;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TaxBureauServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(TaxBureauServiceHelper.class);
    private static final String SPLITSTRING = "#";
    public static final String EWBLXH = "ewblxh";
    private static final String ORGID = "org";
    private static final String STATUS = "declarestatus";
    private static final String PAY_STATUS = "paystatus";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String NSRTYPE = "type";
    private static final String TAXLIMIT = "taxlimit";
    private static final String TEMPLATE_ID = "templateid";
    private static final String ID = "id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveData(DynamicObject nsrxx, String entryName, DeclareRequestModel requestModel, String data) {
        DLock dLock = DLock.create((String)TaxBureauServiceHelper.createLockKey(requestModel));
        try {
            if (dLock.tryLock()) {
                Map<String, String> object = TaxBureauServiceHelper.createYbnsr(nsrxx, entryName, requestModel, data);
                DataSaveService.mapToTable(entryName, object);
                TaxBureauDataHandler handler = TaxBureauDataServiceFactory.createHandler(requestModel.getTemplateType());
                if (handler != null) {
                    handler.saveTaxBureauData(entryName, requestModel, data);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u7533\u62a5\u8868\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        finally {
            dLock.unlock();
        }
    }

    private static String createLockKey(DeclareRequestModel requestModel) {
        StringBuilder sb = new StringBuilder();
        sb.append(requestModel.getId());
        sb.append("-").append(requestModel.getTemplateType());
        sb.append("-").append(requestModel.getSkssqq());
        sb.append("-").append(requestModel.getSkssqz());
        if (EmptyCheckUtils.isNotEmpty(requestModel.getExtendParams())) {
            for (Map.Entry<String, Object> entry : requestModel.getExtendParams().entrySet()) {
                Object value = entry.getValue();
                String appStr = "";
                if (value != null) {
                    appStr = StringUtil.isNotBlank((CharSequence)String.valueOf(value)) ? String.valueOf(value).replace("\\", "").replace("\n", "").replace("\t", "") : "";
                }
                sb.append("-").append(appStr);
            }
        }
        return sb.toString();
    }

    private static Map<String, String> createYbnsr(DynamicObject nsrxx, String entryName, DeclareRequestModel requestModel, String declaredata) {
        String orgId = String.valueOf(requestModel.getOrgId());
        String startDate = requestModel.getSkssqq();
        String endDate = requestModel.getSkssqz();
        Map<String, Object> extendParams = requestModel.getExtendParams();
        String type = requestModel.getTemplateType();
        HashMap<String, String> map = new HashMap<String, String>();
        Long id = null;
        if ("bdtaxr_history_sbb".equals(entryName) && EmptyCheckUtils.isNotEmpty(nsrxx)) {
            TaxBureauServiceHelper.set(map, entryName, "datatype", nsrxx.getString("datatype"));
            TaxBureauServiceHelper.set(map, entryName, "sbbid", nsrxx.getString(ID));
        } else if ("bdtaxr_taxbureau_sbb".equals(entryName)) {
            DynamicObject taxBureau = TaxBureauServiceHelper.queryTaxBureau(orgId, type, startDate, endDate, extendParams);
            if (EmptyCheckUtils.isNotEmpty(taxBureau)) {
                id = taxBureau.getLong(ID);
            }
            TaxBureauServiceHelper.set(map, entryName, "datatype", "3");
            TaxBureauServiceHelper.set(map, entryName, "comparestatus", "undo");
            TaxBureauServiceHelper.set(map, entryName, "convertstatus", "undo");
            if (EmptyCheckUtils.isNotEmpty(requestModel.getBusinessMap()) && EmptyCheckUtils.isNotEmpty(requestModel.getBusinessMap().get("declaredatatype"))) {
                String declareDataType = requestModel.getBusinessMap().get("declaredatatype");
                TaxBureauServiceHelper.set(map, entryName, "declaredatatype", declareDataType);
                if ("0".equals(declareDataType)) {
                    TaxBureauServiceHelper.set(map, entryName, "comparestatus", "noneed");
                    TaxBureauServiceHelper.set(map, entryName, "convertstatus", "noneed");
                }
            }
        }
        if (id == null) {
            id = DeclareServiceHelper.generateSBBId(entryName);
        }
        TaxBureauServiceHelper.set(map, entryName, ID, String.valueOf(id));
        String billno = DeclareServiceHelper.generateSBBNo(entryName, orgId);
        TaxBureauServiceHelper.set(map, entryName, "billno", billno);
        TaxBureauServiceHelper.set(map, entryName, ORGID, orgId);
        TaxBureauServiceHelper.set(map, entryName, STATUS, "declared");
        TaxBureauServiceHelper.set(map, entryName, PAY_STATUS, "unpaid");
        TaxBureauServiceHelper.set(map, entryName, SKSSQQ, startDate);
        TaxBureauServiceHelper.set(map, entryName, SKSSQZ, endDate);
        TaxBureauServiceHelper.set(map, entryName, NSRTYPE, type);
        TaxBureauServiceHelper.set(map, entryName, "declaredata_tag", declaredata);
        DynamicObject template = TemplateUtils.getTemplateObjectByConfig(type, orgId, DateUtils.stringToDate(startDate), DateUtils.stringToDate(endDate));
        if (template != null) {
            TaxBureauServiceHelper.set(map, entryName, TEMPLATE_ID, template.getString(ID));
        }
        TaxBureauServiceHelper.set(map, entryName, TAXLIMIT, DateUtils.getTaxLimit(DateUtils.stringToDate(startDate), DateUtils.stringToDate(endDate)));
        TaxBureauServiceHelper.set(map, entryName, EWBLXH, "1");
        TaxBureauServiceHelper.set(map, entryName, "creator", RequestContext.get().getUserId());
        TaxBureauServiceHelper.set(map, entryName, "createtime", DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        TaxBureauServiceHelper.set(map, entryName, "billstatus", "C");
        TaxBureauServiceHelper.set(map, entryName, "modifier", RequestContext.get().getUserId());
        TaxBureauServiceHelper.set(map, entryName, "modifytime", DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData();
        if (taxMain != null) {
            DynamicObjectCollection m;
            String actualaddress;
            DynamicObject taxorg = taxMain.getDynamicObject("taxorg");
            TaxBureauServiceHelper.set(map, entryName, "nsrsbh", TaxOrgUtil.getUnifiedsocialcode(taxorg));
            TaxBureauServiceHelper.set(map, entryName, "nsrmc", TaxOrgUtil.getTaxpayer(taxorg));
            TaxBureauServiceHelper.set(map, entryName, "taxauthority", taxMain.getString("taxoffice.id"));
            TaxBureauServiceHelper.set(map, entryName, "sshymc", taxMain.getString("codeandname.name"));
            TaxBureauServiceHelper.set(map, entryName, "fddbrxm", taxMain.getString("legalpeople"));
            TaxBureauServiceHelper.set(map, entryName, "registertype", taxMain.getString("registertype.name"));
            TaxBureauServiceHelper.set(map, entryName, "zcdz", "");
            TaxBureauServiceHelper.set(map, entryName, "scjydz", "");
            TaxBureauServiceHelper.set(map, entryName, "phonenum", taxMain.getString("contactinformation"));
            String registeraddress = taxMain.getString("registeraddress");
            if (StringUtils.isNotEmpty((CharSequence)registeraddress)) {
                String registeraddrdetail = taxMain.getString("registeraddrdetail");
                TaxBureauServiceHelper.set(map, entryName, "zcdz", registeraddrdetail);
            }
            if (StringUtils.isNotEmpty((CharSequence)(actualaddress = taxMain.getString("actualaddress")))) {
                TaxBureauServiceHelper.set(map, entryName, "scjydz", taxMain.getString("actualaddrdetail"));
            }
            if (null != (m = taxMain.getDynamicObjectCollection("entryentity")) && m.size() > 0) {
                TaxBureauServiceHelper.set(map, entryName, "khyh", ((DynamicObject)m.get(0)).getString("bankname"));
                TaxBureauServiceHelper.set(map, entryName, "yhzh", ((DynamicObject)m.get(0)).getString("bankacct"));
            }
        }
        TaxBureauServiceHelper.set(map, entryName, "sblx", "1");
        TaxBureauServiceHelper.set(map, entryName, "serialno", "0");
        if (null != extendParams && extendParams.size() != 0) {
            for (Map.Entry<String, Object> entry : extendParams.entrySet()) {
                TaxBureauServiceHelper.set(map, entryName, entry.getKey(), (String)entry.getValue());
            }
        }
        return map;
    }

    private static void set(Map<String, String> map, String entryName, String key, String value) {
        map.put(entryName + SPLITSTRING + "1" + SPLITSTRING + key, value);
    }

    public static DynamicObject queryTaxBureau(String orgid, String type, String startDate, String endDate, Map<String, Object> extendParams) {
        List<QFilter> qFilters = TaxBureauServiceHelper.getQFilters(orgid, type, startDate, endDate, 0, false, extendParams);
        return QueryServiceHelper.queryOne((String)"bdtaxr_taxbureau_sbb", (String)"id,billstatus", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public static List<QFilter> getQFilters(String orgid, String stype, String startData, String endData, int month, boolean dateRange, Map<String, Object> extendParams) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (!TaxBureauServiceHelper.checkGroupSubmmitted(stype, extendParams)) {
            qFilters.add(new QFilter(ORGID, "=", (Object)Long.parseLong(orgid)));
        }
        qFilters.add(new QFilter(NSRTYPE, "=", (Object)stype));
        if (dateRange) {
            qFilters.add(new QFilter(SKSSQQ, ">=", (Object)DateUtils.addMonth(DateUtils.stringToDate(startData), month)));
        } else {
            qFilters.add(new QFilter(SKSSQQ, "=", (Object)DateUtils.addMonth(DateUtils.stringToDate(startData), month)));
        }
        qFilters.add(new QFilter(SKSSQZ, "<=", (Object)DateUtils.getLastDateOfMonth(DateUtils.addMonth(DateUtils.stringToDate(endData), month))));
        qFilters.add(new QFilter(TAXLIMIT, "=", (Object)DateUtils.getTaxLimit(DateUtils.stringToDate(startData), DateUtils.stringToDate(endData))));
        return qFilters;
    }

    private static boolean checkGroupSubmmitted(String type, Map<String, Object> extendParams) {
        return StringUtils.equals((CharSequence)"qhjtbs", (CharSequence)type) && EmptyCheckUtils.isNotEmpty(extendParams) && StringUtils.isNotBlank((Object)extendParams.get("groupid"));
    }
}

