/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.helper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.TrasBizdefenEnum;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;

public class TemplateImportServiceHelper {
    private static Log logger = LogFactory.getLog(TemplateImportServiceHelper.class);
    private static final String SPLITSTRING = "#";
    private static final String GANG = "-";

    public static Map<String, String> getExcelIndex2DynamicRowNoMap(Long templateId, Map<String, EntityField> templateEntityMap) {
        List<String> dynRowNoList = DynamicRowService.getDynRowNoList(templateId);
        LinkedHashMap<String, String> dynamicRowMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, EntityField> entry : templateEntityMap.entrySet()) {
            int indexOf;
            String reportId = entry.getValue().getReportId();
            if (!dynRowNoList.contains(reportId.substring(0, indexOf = reportId.lastIndexOf(SPLITSTRING)))) continue;
            String excelKey = entry.getKey();
            String newKey = excelKey.substring(0, excelKey.lastIndexOf(SPLITSTRING));
            dynamicRowMap.putIfAbsent(newKey, reportId.substring(0, indexOf));
        }
        return dynamicRowMap;
    }

    public static Map<String, List<Integer>> getDynRowIndexMap(Map<String, String> resultMap, Map<String, FormulaVo> formulaVoMap, Map<String, String> excelIndex2DynamicRowNoMap, Map<String, String> importExcelDataMap, Map<String, String> templateExcelDataMap, Map<String, EntityField> templateEntityMap, Map<String, Integer> excelLastLineMap, Map<String, Object> declareMainInfos) {
        Map<String, List<Map.Entry<String, String>>> importExcelLineDataMap = importExcelDataMap.entrySet().stream().collect(Collectors.groupingBy(s -> ((String)s.getKey()).substring(0, ((String)s.getKey()).lastIndexOf(SPLITSTRING))));
        Map<String, List<Map.Entry<String, String>>> templateExcelLineDataMap = templateExcelDataMap.entrySet().stream().collect(Collectors.groupingBy(s -> ((String)s.getKey()).substring(0, ((String)s.getKey()).lastIndexOf(SPLITSTRING))));
        HashMap<String, List> dynRowDataMap = new HashMap<String, List>();
        LinkedHashMap<String, List<Integer>> dynRowIndexMap = new LinkedHashMap<String, List<Integer>>();
        Map<String, List<Integer>> dynamicRowColsMap = TemplateImportServiceHelper.getDynamicRowCols(excelIndex2DynamicRowNoMap, templateEntityMap);
        for (Map.Entry<String, EntityField> templateEntityFieldEntry : templateEntityMap.entrySet()) {
            String templateExcelCellIndex = templateEntityFieldEntry.getKey();
            String sheetName = templateExcelCellIndex.split(SPLITSTRING)[0];
            String templateExcelRowIndex = templateExcelCellIndex.substring(0, templateExcelCellIndex.lastIndexOf(SPLITSTRING));
            String dynamicRowNo = excelIndex2DynamicRowNoMap.get(templateExcelRowIndex);
            if (!EmptyCheckUtils.isNotEmpty(dynamicRowNo) || !EmptyCheckUtils.isNotEmpty(dynamicRowColsMap.get(dynamicRowNo))) continue;
            List<Integer> dynRowColsIndexList = dynamicRowColsMap.get(dynamicRowNo);
            Integer colNumber = dynRowColsIndexList.get(0);
            if (!Objects.equals(templateExcelCellIndex.split(SPLITSTRING)[2], colNumber.toString())) continue;
            int startIndex = Integer.parseInt(dynamicRowNo.split(SPLITSTRING)[1]);
            int previousDynRowCounts = TemplateImportServiceHelper.calcPreviousDynRowCounts(dynRowIndexMap, templateExcelRowIndex);
            int dynRowCountBeforeInCurrentSheet = TemplateImportServiceHelper.getDynRowCountBeforeInCurrentSheet(excelIndex2DynamicRowNoMap, templateExcelRowIndex);
            List<Integer> dynRowIndexs = TemplateImportServiceHelper.getDynRowIndexList(excelLastLineMap, previousDynRowCounts, dynRowCountBeforeInCurrentSheet, templateExcelRowIndex, excelIndex2DynamicRowNoMap, templateEntityMap, importExcelLineDataMap, templateExcelLineDataMap);
            dynRowIndexMap.put(templateExcelRowIndex, dynRowIndexs);
            for (int i = 0; i < dynRowIndexs.size(); ++i) {
                List list = dynRowDataMap.computeIfAbsent(dynamicRowNo, d -> new ArrayList());
                String dynRowIndex = sheetName + SPLITSTRING + dynRowIndexs.get(i);
                if (importExcelLineDataMap.get(dynRowIndex) == null) continue;
                HashMap<String, String> map = new HashMap<String, String>(dynRowColsIndexList.size());
                for (Integer col : dynRowColsIndexList) {
                    int newIndex = startIndex + i;
                    String excelDataIndex = templateExcelRowIndex + SPLITSTRING + col;
                    EntityField entityField = templateEntityMap.get(excelDataIndex);
                    if (entityField == null) continue;
                    String excelValueIndex = dynRowIndex + SPLITSTRING + col;
                    String rKey = entityField.getEntityId() + SPLITSTRING + newIndex + SPLITSTRING + entityField.getFieldId();
                    TemplateImportServiceHelper.setValue(formulaVoMap, resultMap, entityField, importExcelDataMap.get(excelValueIndex), rKey, declareMainInfos);
                    map.put(rKey, importExcelDataMap.get(excelValueIndex));
                }
                list.add(map);
            }
        }
        return dynRowIndexMap;
    }

    private static List<Integer> getDynRowIndexList(Map<String, Integer> excelLastLineMap, int previousDynRowCounts, int dynRowCountBeforeInCurrentSheet, String templateExcelRowIndex, Map<String, String> excelIndex2DynamicRowNoMap, Map<String, EntityField> templateEntityMap, Map<String, List<Map.Entry<String, String>>> importExcelLineDataMap, Map<String, List<Map.Entry<String, String>>> templateExcelLineDataMap) {
        String[] sheetNameRowCol = templateExcelRowIndex.split(SPLITSTRING);
        Integer excelLastLine = excelLastLineMap.getOrDefault(sheetNameRowCol[0], 0);
        int templateDynRow = Integer.parseInt(sheetNameRowCol[1]);
        String nextLine = sheetNameRowCol[0] + SPLITSTRING + (templateDynRow + 1);
        if (excelIndex2DynamicRowNoMap.get(nextLine) != null) {
            nextLine = sheetNameRowCol[0] + SPLITSTRING + (templateDynRow + 2);
        }
        List<Map.Entry<String, String>> nextLineTemplateData = templateExcelLineDataMap.get(nextLine);
        ArrayList<Integer> rowList = new ArrayList<Integer>();
        Integer startLine = templateDynRow + previousDynRowCounts - dynRowCountBeforeInCurrentSheet;
        for (int row = startLine.intValue(); row <= excelLastLine; ++row) {
            String newLine = sheetNameRowCol[0] + SPLITSTRING + row;
            List<Map.Entry<String, String>> newLineImportData = importExcelLineDataMap.get(newLine);
            if (newLineImportData == null || nextLineTemplateData == null) {
                rowList.add(row);
                continue;
            }
            boolean isSame = TemplateImportServiceHelper.isSameLine(templateEntityMap, newLineImportData, nextLineTemplateData);
            if (isSame) break;
            rowList.add(row);
        }
        return rowList;
    }

    private static int getDynRowCountBeforeInCurrentSheet(Map<String, String> excelIndex2DynamicRowNoMap, String templateExcelRowIndex) {
        int seq = 0;
        for (Map.Entry<String, String> entry : excelIndex2DynamicRowNoMap.entrySet()) {
            String[] split = entry.getKey().split(SPLITSTRING);
            String[] split2 = templateExcelRowIndex.split(SPLITSTRING);
            String sheetName = split[0];
            String row = split[1];
            if (!sheetName.equals(split2[0])) continue;
            if (row.equals(split2[1])) break;
            ++seq;
        }
        return seq;
    }

    private static int calcPreviousDynRowCounts(Map<String, List<Integer>> dynRowCountMap, String templateExcelRowIndex) {
        int count = 0;
        String[] split = templateExcelRowIndex.split(SPLITSTRING);
        for (Map.Entry<String, List<Integer>> entry : dynRowCountMap.entrySet()) {
            String[] split1 = entry.getKey().split(SPLITSTRING);
            if (!split[0].equals(split1[0]) || Integer.parseInt(split[1]) <= Integer.parseInt(split1[1]) || entry.getValue().size() <= 0) continue;
            count += entry.getValue().size();
        }
        return count;
    }

    private static boolean isSameLine(Map<String, EntityField> templateEntityMap, List<Map.Entry<String, String>> newLineImportData, List<Map.Entry<String, String>> nextLineTemplateData) {
        for (Map.Entry<String, String> nextLineTemplateDatum : nextLineTemplateData) {
            String index = nextLineTemplateDatum.getKey();
            String col = index.split(SPLITSTRING)[2];
            String value = nextLineTemplateDatum.getValue();
            if (templateEntityMap.get(index) != null) continue;
            for (Map.Entry<String, String> newLineImportDatum : newLineImportData) {
                String index1 = newLineImportDatum.getKey();
                String value1 = newLineImportDatum.getValue();
                if (!col.equals(index1.split(SPLITSTRING)[2]) || value.trim().equals(value1.trim())) continue;
                return false;
            }
        }
        return true;
    }

    private static Map<String, List<Integer>> getDynamicRowCols(Map<String, String> dynamicRowMap, Map<String, EntityField> templateEntityMap) {
        HashMap<String, List<Integer>> dynamicRowColsMap = new HashMap<String, List<Integer>>(dynamicRowMap.size());
        for (Map.Entry<String, String> entry : dynamicRowMap.entrySet()) {
            String dynamicRowNo = entry.getValue();
            ArrayList<Integer> dynamicRowCols = new ArrayList<Integer>();
            String entity = dynamicRowNo.split(SPLITSTRING)[0];
            for (Map.Entry<String, EntityField> entry1 : templateEntityMap.entrySet()) {
                if (!entry1.getValue().getEntityId().equals(entity)) continue;
                dynamicRowCols.add(Integer.parseInt(entry1.getKey().split(SPLITSTRING)[2]));
            }
            dynamicRowCols.sort(Comparator.comparingInt(o -> o));
            dynamicRowColsMap.put(dynamicRowNo, dynamicRowCols);
        }
        return dynamicRowColsMap;
    }

    public static Map<String, Integer> getOffsets(Map<String, List<Integer>> dynRowIndexMap, Map<String, EntityField> templateEntityMap, Map<String, String> excelIndex2DynamicRowNoMap) {
        String row;
        String sheetName;
        String[] split;
        HashMap<String, Integer> offsetMap = new HashMap<String, Integer>(templateEntityMap.size());
        HashMap<String, Map> dynRowCountMap = new HashMap<String, Map>();
        for (Map.Entry<String, String> entry : excelIndex2DynamicRowNoMap.entrySet()) {
            split = entry.getKey().split(SPLITSTRING);
            sheetName = split[0];
            row = split[1];
            int count = dynRowIndexMap.get(entry.getKey()) == null ? 0 : dynRowIndexMap.get(entry.getKey()).size();
            Map map = dynRowCountMap.computeIfAbsent(sheetName, d -> new LinkedHashMap());
            map.putIfAbsent(row, count);
        }
        for (Map.Entry<String, Object> entry : templateEntityMap.entrySet()) {
            split = entry.getKey().split(SPLITSTRING);
            sheetName = split[0];
            row = split[1];
            Map map = (Map)dynRowCountMap.get(sheetName);
            int count = 0;
            if (EmptyCheckUtils.isNotEmpty(map)) {
                for (Map.Entry integerEntry : map.entrySet()) {
                    String key = (String)integerEntry.getKey();
                    if (Integer.parseInt(row) <= Integer.parseInt(key)) continue;
                    count = count + (Integer)integerEntry.getValue() - 1;
                }
            }
            offsetMap.put(entry.getKey(), count);
        }
        return offsetMap;
    }

    public static void setValue(Map<String, FormulaVo> formulaVoMap, Map<String, String> resultMap, EntityField value, String inputValue, String rKey, Map<String, Object> declareMainInfos) {
        FormulaVo formulaVo;
        String ewblName = value.getEwblName();
        String fieldName = value.getFieldName();
        if (("Decimal".equals(value.getFieldType()) || "Integer".equals(value.getFieldType())) && TemplateImportServiceHelper.filterSpecialCharacter(inputValue)) {
            if (!(inputValue = inputValue.replaceAll(",", "")).matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
                logger.info("Excel\u5355\u5143\u683c\u6570\u636e\u6821\u9a8c\uff1a{}", (Object)inputValue);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\uff1a\u6570\u636e\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u6570\u503c\u7c7b\u578b\u5355\u5143\u683c\u53ea\u80fd\u662f\u963f\u62c9\u4f2f\u6570\u5b57\uff0c\u4e14\u6570\u5b57\u4e2d\u4e0d\u80fd\u5e26\u6709\u4efb\u4f55\u7b26\u53f7\uff08\u975e\u4e2d\u6587\u8f93\u5165\u6cd5\u5f55\u5165\u7684\u5c0f\u6570\u70b9\uff0c\u8d1f\u53f7\u9664\u5916\uff09\u3002\u8bf7\u4e25\u683c\u6309\u7167\u4e0a\u8ff0\u6a21\u677f\u683c\u5f0f\u5f15\u5165\u3002", (String)"TemplateImportServiceHelper_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ewblName, GANG, fieldName));
            }
        } else if ("Text".equals(value.getFieldType())) {
            int maxLength;
            int n = maxLength = value.getMaxLength() > 0 ? value.getMaxLength() : 2000;
            if (inputValue != null && inputValue.length() > maxLength) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\uff1a\u5f55\u5165\u6587\u672c\u5b57\u7b26\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TemplateImportServiceHelper_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ewblName, GANG, fieldName));
            }
        } else if ("Date".equals(value.getFieldType()) && (value.isMustInput() || EmptyCheckUtils.isNotEmpty(inputValue))) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                df.parse(inputValue);
            }
            catch (Exception e) {
                String entityId = value.getEntityName();
                String fieldId = value.getFieldName();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u300a%1$s\u300b\u7684\u201c%2$s\u201d\u5217\u8bf7\u6539\u4e3aYYYY-MM-DD\u7684\u683c\u5f0f\u3002", (String)"TemplateImportServiceHelper_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), entityId, fieldId, inputValue));
            }
        }
        if (null == (formulaVo = formulaVoMap.get(rKey))) {
            String[] split = rKey.split(SPLITSTRING);
            String regex = split[0] + "#(\\d+)#" + split[2];
            Optional<Map.Entry> first = formulaVoMap.entrySet().stream().filter(s -> ((String)s.getKey()).matches(regex)).findFirst();
            formulaVo = first.map(Map.Entry::getValue).orElse(null);
        }
        if (formulaVo != null && "3".equals(formulaVo.getFormulaType())) {
            String celltype = formulaVo.getCellType();
            if ("5".equals(celltype)) {
                Map<String, String> itemMap = TemplateShowUtils.parseCellType(formulaVo.getFormulaName());
                if (null == itemMap) {
                    return;
                }
                TemplateImportServiceHelper.queryDeductionData(itemMap, resultMap, inputValue, rKey, declareMainInfos);
            } else if ("2".equals(celltype) || "3".equals(celltype) || "4".equals(celltype)) {
                Map<String, String> comboMap = TemplateShowUtils.parseCellType(formulaVo.getFormulaName());
                for (Map.Entry<String, String> entry : comboMap.entrySet()) {
                    if (!StringUtils.deleteWhitespace((String)entry.getValue()).equals(StringUtils.deleteWhitespace((String)inputValue))) continue;
                    resultMap.put(rKey, entry.getKey());
                    break;
                }
            } else {
                resultMap.put(rKey, inputValue);
            }
        } else {
            resultMap.put(rKey, inputValue);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void queryDeductionData(Map<String, String> itemMap, Map<String, String> resultMap, String inputValue, String rKey, Map<String, Object> declareMainInfos) {
        QFilter numberFilter;
        QFilter[] filters;
        if (inputValue == null) {
            return;
        }
        String[] split = inputValue.split("\\|");
        Map.Entry<String, String> cellTypeEntry = itemMap.entrySet().iterator().next();
        String key = cellTypeEntry.getKey();
        List<String> selectFieldList = TemplateShowUtils.parseBaseDataFieldList(cellTypeEntry.getValue());
        if ("tpo_discount_tree".equals(key) || "tpo_yearitems_tree".equals(key)) {
            String skssqq = (String)declareMainInfos.get("skssqq");
            String skssqz = (String)declareMainInfos.get("skssqz");
            QFilter q1 = new QFilter("start", "<=", (Object)DateUtils.stringToDate(skssqq)).and("end", ">=", (Object)DateUtils.stringToDate(skssqz));
            QFilter q2 = new QFilter("start", "<=", (Object)DateUtils.stringToDate(skssqq)).and("end", "is null", null);
            QFilter q3 = new QFilter("enable", "=", (Object)"1");
            QFilter q4 = new QFilter("template", "=", (Object)"qysdsyj");
            if (ResManager.loadKDString((String)"\u5176\u4ed6", (String)"TemplateImportServiceHelper_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(inputValue)) {
                q4 = "tccit_qysds_ext_dyn".equals(rKey.split(SPLITSTRING)[0]) ? q4.and(new QFilter("number", "like", (Object)"JJSRQT")) : q4.and(new QFilter("number", "like", (Object)"SD999"));
            }
            QFilter dateFilter = q1.or(q2);
            filters = new QFilter[]{new QFilter(selectFieldList.get(1), "=", (Object)split[0]), dateFilter, q3, q4};
        } else if ("bastax_hscode".equals(key)) {
            QFilter dateFilter = new QFilter("startdate", "<=", (Object)new Date()).and(new QFilter("enddate", ">=", (Object)new Date()));
            filters = new QFilter[]{new QFilter(selectFieldList.get(1), "=", (Object)split[0]), dateFilter};
        } else if ("tpo_zdsy_bizdefen_tree".equals(key)) {
            Long bizdefid = TrasBizdefenEnum.getIdByNumber(rKey);
            QFilter bizdefIdQ = new QFilter("bizdefid", "=", (Object)bizdefid);
            QFilter isleafQ = new QFilter("isleaf", "=", (Object)true);
            filters = new QFilter[]{new QFilter(selectFieldList.get(1), "=", (Object)split[0]), bizdefIdQ, isleafQ};
        } else if ("tpo_tccit_bizdef_entry".equals(key) && rKey.endsWith("tzxzbasedata")) {
            numberFilter = new QFilter("number", "like", (Object)"CIT-TZXZ01-%");
            filters = new QFilter[]{new QFilter(selectFieldList.get(1), "=", (Object)split[0]), numberFilter};
        } else if ("tpo_tccit_bizdef_entry".equals(key) && (rKey.endsWith("fzjgxsqyyhbasedata") || rKey.endsWith("fzjgyhbasedata"))) {
            numberFilter = new QFilter(selectFieldList.get(1), "like", (Object)"%15%%");
            filters = new QFilter[]{new QFilter(selectFieldList.get(1), "=", (Object)split[0]), numberFilter};
        } else if ("tpo_taxdeduction".equals(key)) {
            if (split.length > 1) {
                String code = split[0];
                String number = code.length() >= 8 ? code : "0" + code;
                filters = new QFilter[]{new QFilter(selectFieldList.get(1), "=", (Object)number).and("enable", "=", (Object)"1")};
            } else {
                filters = new QFilter[]{new QFilter(selectFieldList.get(1), "=", (Object)split[0])};
            }
        } else if ("tpo_tcvat_assist_entry".equals(key)) {
            QFilter qFilter = new QFilter(selectFieldList.get(1), "=", (Object)split[0]);
            if (rKey.startsWith("tcvat_ybnsr_trccfhdncp#") && rKey.endsWith("#hyncpmc")) {
                qFilter.and(new QFilter("pid", "=", (Object)1639737498240406528L));
            } else if ((rKey.startsWith("tcvat_ybnsr_trccfhdncp#") || rKey.startsWith("tcvat_ybnsr_gjncpzjxshd#")) && rKey.endsWith("#cpmc")) {
                qFilter.and(new QFilter("pid", "=", (Object)1639737114872632320L));
            }
            filters = new QFilter[]{qFilter};
        } else {
            filters = new QFilter[]{new QFilter(selectFieldList.get(1), "=", (Object)split[0])};
        }
        DynamicObjectCollection objectList = QueryServiceHelper.query((String)key, (String)String.join((CharSequence)",", selectFieldList), (QFilter[])filters);
        if (null != objectList && objectList.size() == 1) {
            resultMap.put(rKey, ((DynamicObject)objectList.get(0)).getString("id"));
            return;
        }
        if (objectList != null && objectList.size() > 1) {
            if (split.length < 2) {
                if ("tpo_zdsy_bizdefen_tree".equals(key)) {
                    resultMap.put(rKey, "0");
                    return;
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801:\u3010%s\u3011\u5bf9\u5e94\u591a\u6761\u57fa\u7840\u8d44\u6599", (String)"TemplateImportServiceHelper_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), split[0]));
            }
            DynamicObjectCollection keywordList = QueryServiceHelper.query((String)"tpo_taxdeductionkeyword", (String)"id,number,name,keyword", (QFilter[])new QFilter[]{new QFilter(selectFieldList.get(1), "=", (Object)split[0])});
            String name = split[1];
            Optional<DynamicObject> keywordObj = keywordList.stream().filter(keyword -> name.contains(keyword.getString("keyword"))).findFirst();
            if (!keywordObj.isPresent()) throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u51cf\u514d\u6027\u8d28\u4ee3\u7801\u5b58\u5728\u591a\u6761\u51cf\u514d\u540d\u79f0\uff0c\u8bf7\u6309\u683c\u5f0f\u8981\u6c42\u6b63\u786e\u586b\u5199\u51cf\u514d\u540d\u79f0\u3002\u3010\u586b\u5199\u683c\u5f0f\uff1a\u51cf\u514d\u4ee3\u7801|\u51cf\u514d\u540d\u79f0\u3011", (String)"TemplateImportServiceHelper_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)key, (String)String.join((CharSequence)",", selectFieldList), (QFilter[])new QFilter[]{new QFilter(selectFieldList.get(1), "=", (Object)split[0]), new QFilter(selectFieldList.get(2), "=", (Object)keywordObj.get().getString("name")), new QFilter("enable", "=", (Object)"1")});
            if (dynamicObject != null) {
                resultMap.put(rKey, dynamicObject.getString("id"));
                return;
            }
            if (!"tpo_taxdeduction".equals(key)) return;
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u51cf\u514d\u6027\u8d28\u4ee3\u7801\u6570\u636e\u7ef4\u62a4\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u6280\u672f\u4eba\u5458\u8fdb\u884c\u4fee\u6539\u3002", (String)"TemplateImportServiceHelper_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if ("tpo_taxdeduction".equals(key)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51cf\u514d\u6027\u8d28\u4ee3\u7801\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TemplateImportServiceHelper_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (!"bastax_taxorgan".equals(key)) return;
        throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u52a1\u4e3b\u7ba1\u673a\u5173\u4e0d\u5b58\u5728\u7cfb\u7edf\u4e2d", (String)"TemplateImportServiceHelper_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
    }

    private static boolean filterSpecialCharacter(String inputValue) {
        return StringUtils.isNotBlank((CharSequence)inputValue) && !inputValue.equals("--") && !inputValue.equals("*");
    }

    public static Map<String, Integer> getLastLine(Map<String, String> importExcelDataMap) {
        HashMap<String, Integer> lastLineMap = new HashMap<String, Integer>();
        for (Map.Entry<String, String> entry : importExcelDataMap.entrySet()) {
            String[] splits = entry.getKey().split(SPLITSTRING);
            String sheetName = splits[0];
            Integer line = lastLineMap.getOrDefault(sheetName, 0);
            if (Integer.parseInt(splits[1]) <= line) continue;
            lastLineMap.put(sheetName, Integer.parseInt(splits[1]));
        }
        return lastLineMap;
    }
}

