/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.initparam;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.initparam.DefaultInitParams;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TcvatCurrentInitParams
extends DefaultInitParams {
    private static final String SBBID = "sbbid";
    private static final String YEARSBBID = "yearsbbid";
    public static final String STARTPERIOD = "strStartPeriod";
    public static final String ENDPERIOD = "strEndPeriod";
    public static final String START = "start";
    public static final String END = "end";
    public static final String MIDDLEPERIOD = "strMiddlePeriod";
    private static final String XGM_TAX_RATE_YEAR = "xgmyear";
    private static final String XGM_TAX_RATE_MONTH = "xgmmonth";
    private static final String REGISTERTYPE = "registertype";
    private static final String DEADLINE = "deadline";
    private static final String TYPE = "type";
    private static final String cswhjssenable = "cswhjssenable";
    private static final String jyffjenable = "jyffjenable";
    private static final String dfjyffjenable = "dfjyffjenable";
    public static final String ENABLE = "1";
    public static final String DISABLE = "0";
    public static final String MONTH = "month";

    @Override
    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        Map<String, String> param = super.buildBizParam(requestModel);
        Map<String, String> bizParam = this.setBizParam(requestModel.getBusinessMap(), String.valueOf(requestModel.getId()), requestModel.getTemplateType(), String.valueOf(requestModel.getOrgId()), requestModel.getSkssqq(), requestModel.getSkssqz());
        param.putAll(bizParam);
        return param;
    }

    public Map<String, String> setBizParam(Map<String, String> bizParams, String id, String type, String orgId, String startDate, String endDate) {
        HashMap<String, String> param = new HashMap<String, String>(16);
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.stringToDate(endDate, "yyyy-MM"));
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        param.put(XGM_TAX_RATE_YEAR, String.valueOf(year));
        param.put(XGM_TAX_RATE_MONTH, String.valueOf(month));
        param.put(STARTPERIOD, startDate.substring(0, 7));
        Date middleDate = DateUtils.stringToDate(startDate);
        middleDate = DateUtils.addMonth(middleDate, 1);
        param.put(MIDDLEPERIOD, DateUtils.formatMonth(middleDate));
        param.put(ENDPERIOD, endDate.substring(0, 7));
        param.put(START, startDate);
        param.put(END, endDate);
        String registerType = bizParams.get("registerType");
        if (StringUtils.isNotBlank((CharSequence)registerType)) {
            param.put(REGISTERTYPE, registerType);
        } else {
            DynamicObject data = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData();
            if (data != null) {
                param.put(REGISTERTYPE, data.getString("registertype.id"));
            }
        }
        param.put(DEADLINE, "aysb");
        param.put(TYPE, DISABLE);
        int startMonth = DateUtils.getMonthOfDate(DateUtils.stringToDate(startDate));
        int endMonth = DateUtils.getMonthOfDate(DateUtils.stringToDate(endDate));
        int offSet = -1;
        if (endMonth - startMonth == 2) {
            offSet = -3;
            param.put(TYPE, ENABLE);
            param.put(DEADLINE, "ajsb");
        }
        String sbbid = YbnsrService.queryYbnsrPre(orgId, type, startDate, endDate, offSet);
        String yearsbbid = bizParams.get(YEARSBBID);
        if (null == yearsbbid) {
            yearsbbid = YbnsrService.queryYbnsrPreYear(orgId, type, startDate, endDate);
        }
        param.put(SBBID, sbbid);
        param.put(YEARSBBID, yearsbbid);
        param.put("prestartDate", DateUtils.format(DateUtils.addMonth(DateUtils.stringToDate(startDate), offSet)));
        param.put("preendDate", DateUtils.format(DateUtils.getLastDateOfMonth(DateUtils.addMonth(DateUtils.stringToDate(endDate), offSet))));
        param.put(MONTH, String.valueOf(startMonth));
        param.put("endMonth", String.valueOf(endMonth));
        DynamicObject category = TaxBaseDataUtils.queryCategoryByTaxtype(Long.parseLong(orgId), "fjsf");
        if (category != null) {
            param.put(cswhjssenable, ENABLE.equals(category.getString(cswhjssenable)) ? ENABLE : DISABLE);
            param.put(jyffjenable, "2".equals(category.getString(jyffjenable)) ? ENABLE : DISABLE);
            param.put(dfjyffjenable, "3".equals(category.getString(dfjyffjenable)) ? ENABLE : DISABLE);
        }
        param.put("taxpayertype", bizParams.get("taxPayerType"));
        this.setNsrsbh(orgId, param);
        return param;
    }

    private void setNsrsbh(String orgId, Map<String, String> param) {
        QFilter orgIdFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"unifiedsocialcode", (QFilter[])new QFilter[]{orgIdFilter});
        if (dynamicObject != null) {
            param.put("nsrsbh", dynamicObject.getString("unifiedsocialcode"));
        }
    }

    public static String getXgmTaxRateYear() {
        return XGM_TAX_RATE_YEAR;
    }

    public static String getXgmTaxRateMonth() {
        return XGM_TAX_RATE_MONTH;
    }

    public static String getREGISTERTYPE() {
        return REGISTERTYPE;
    }
}

