/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.initparam;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.initparam.DefaultInitParams;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.enums.DraftTypeEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.admindivision.AdminDivisionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TcvatInitParams
extends DefaultInitParams {
    private static final String SBBID = "sbbid";
    private static final String YEARSBBID = "lastyearsbbid";
    private static final String cswhjssenable = "cswhjssenable";
    private static final String jyffjenable = "jyffjenable";
    private static final String dfjyffjenable = "dfjyffjenable";
    private static final String[] deleteKey = new String[]{"sbbid", "lastyearsbbid"};
    public static final String ENABLE = "1";
    public static final String DISABLE = "0";
    public static final String MONTH = "month";
    private static final String ZERO_VALUE = "0";
    private static final String YBHZ = "ybhz";
    private static final String TAXRATE = "taxrate";
    private static final String DEADLINE = "deadline";
    private static final String TYPE = "type";
    public static final String STARTPERIOD = "startPeriod";
    public static final String MIDDLEPERIOD = "middlePeriod";
    public static final String ENDPERIOD = "endPeriod";
    public static final String STARTPERIOD1 = "sPeriod";
    public static final String MIDDLEPERIOD1 = "mPeriod";
    public static final String ENDPERIOD1 = "ePeriod";
    public static final String FIRSTMONSEA = "firstmonsea";
    private static Map<String, String> collectionMap = new HashMap<String, String>(4){
        {
            this.put("cityarea", ResManager.loadKDString((String)"\u5e02\u533a\uff08\u589e\u503c\u7a0e\u9644\u5f81\uff09", (String)"TcvatInitParams_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.put("nocityarea", ResManager.loadKDString((String)"\u53bf\u57ce\u3001\u9547\uff08\u589e\u503c\u7a0e\u9644\u5f81\uff09", (String)"TcvatInitParams_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.put("otherarea", ResManager.loadKDString((String)"\u5176\u4ed6\uff08\u589e\u503c\u7a0e\u9644\u5f81\uff09", (String)"TcvatInitParams_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    };

    @Override
    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        Map<String, String> param = super.buildBizParam(requestModel);
        Map<String, String> bizParam = this.setBizParam(requestModel.getBusinessMap(), String.valueOf(requestModel.getId()), requestModel.getTemplateType(), String.valueOf(requestModel.getOrgId()), requestModel.getSkssqq(), requestModel.getSkssqz());
        param.putAll(bizParam);
        return param;
    }

    public Map<String, String> setBizParam(Map<String, String> bizParams, String id, String type, String orgId, String startDate, String endDate) {
        DynamicObject category;
        DynamicObject policyConfirm;
        QFilter draftPurposeFilter;
        QFilter dateFilter;
        QFilter orgFilter;
        TemplateEnum enumByDraftType;
        HashMap<String, String> bizParam = new HashMap<String, String>(32);
        String deadLine = "aysb";
        bizParam.put(TYPE, "0");
        Date skssqq = DateUtils.stringToDate2(startDate);
        Date skssqz = DateUtils.stringToDate2(endDate);
        int startMonth = DateUtils.getMonthOfDate(skssqq);
        int endMonth = DateUtils.getMonthOfDate(skssqz);
        bizParam.put(STARTPERIOD, startDate.substring(0, 7));
        bizParam.put(MIDDLEPERIOD, startDate.substring(0, 7));
        bizParam.put(ENDPERIOD, endDate.substring(0, 7));
        bizParam.put(STARTPERIOD1, startDate.substring(0, 7));
        bizParam.put(MIDDLEPERIOD1, startDate.substring(0, 7));
        bizParam.put(ENDPERIOD1, endDate.substring(0, 7));
        bizParam.put(FIRSTMONSEA, DateUtils.isFirstMonthWithinYear(skssqq) ? ENABLE : "0");
        int offSet = -1;
        if (endMonth - startMonth == 2) {
            offSet = -3;
            bizParam.put(TYPE, ENABLE);
            deadLine = "ajsb";
            Date middleDate = DateUtils.addMonth(skssqq, 1);
            bizParam.put(MIDDLEPERIOD, DateUtils.formatMonth(middleDate));
            bizParam.put(MIDDLEPERIOD1, DateUtils.formatMonth(middleDate));
        }
        bizParam.put(DEADLINE, deadLine);
        String preSbbid = bizParams.get(SBBID);
        if (StringUtil.isBlank((CharSequence)preSbbid)) {
            preSbbid = YbnsrService.queryYbnsrPre(orgId, type, startDate, endDate, offSet);
            if ("zzsybnsr".equals(type) && (ObjectUtils.isEmpty((Object)preSbbid) || "0".equals(preSbbid))) {
                String t;
                Iterator<String> iterator = Arrays.asList("zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg").iterator();
                while (iterator.hasNext() && (!ObjectUtils.isNotEmpty((Object)(preSbbid = YbnsrService.queryYbnsrPre(orgId, t = iterator.next(), startDate, endDate, offSet))) || "0".equals(preSbbid))) {
                }
            }
        }
        if (Arrays.asList(DraftTypeEnum.TCVAT.getTemplates()).contains(type) && (enumByDraftType = TemplateEnum.getEnumByDraftType(type)) != null && StringUtil.isNotBlank((CharSequence)enumByDraftType.getDeclareType())) {
            bizParam.put("predeclaresbbid", YbnsrService.queryYbnsrPre(orgId, enumByDraftType.getDeclareType(), startDate, endDate));
        }
        String taxPayerType = bizParams.get("taxPayerType");
        bizParam.put("taxpayertype", taxPayerType);
        String zlbid = bizParams.get("zlbid");
        if (StringUtils.isNotBlank((CharSequence)zlbid)) {
            bizParam.put("zlbid", zlbid);
        } else {
            DynamicObject zlb = YbnsrService.queryYbnsr(orgId, "draft_" + taxPayerType, startDate, endDate, 0, null);
            bizParams.put("zlbid", null == zlb ? "0" : zlb.getString("id"));
        }
        bizParam.put("presbbid", preSbbid);
        bizParam.put(SBBID, preSbbid);
        bizParam.put("currentSbbid", id);
        bizParam.put(YEARSBBID, preSbbid);
        bizParam.put("prestartDate", DateUtils.format(DateUtils.addMonth(skssqq, offSet)));
        bizParam.put("preendDate", DateUtils.format(DateUtils.getLastDateOfMonth(DateUtils.getLastDateOfMonth(DateUtils.addMonth(skssqz, offSet)))));
        bizParam.put("isHangkongOrg", this.isHangkongOrg(orgId, startDate, endDate) ? ENABLE : "0");
        bizParam.put(MONTH, String.valueOf(DateUtils.getMonthOfDate(skssqq)));
        bizParam.put("endMonth", String.valueOf(DateUtils.getMonthOfDate(skssqz)));
        bizParam.put("income", "0");
        bizParam.put("diff", "0");
        bizParam.put("deduct", "0");
        bizParam.put("amount", this.getAmount(orgId, startDate, endDate, "amount"));
        bizParam.put("taxamount", this.getAmount(orgId, startDate, endDate, "taxamount"));
        bizParam.put("ybamount", this.getYbAmount(orgId, startDate, endDate, "ybamount"));
        bizParam.put("ybtaxamount", this.getYbAmount(orgId, startDate, endDate, "ybtaxamount"));
        String bqsfsyjzzc = null;
        if ("zzsybnsr_ybhz".equals(type) || "draft_zzsybnsr_ybhz".equals(type) || "zzsybnsr_hz_zjg".equals(type) || "draft_zzsybnsr_hz_zjg".equals(type) || "zzsybnsr_yz_zjg".equals(type) || "draft_zzsybnsr_yz_zjg".equals(type) || "zzsybnsr_yz_fzjg".equals(type)) {
            QFilter skssqqzFilter;
            String zjgOrgId;
            orgFilter = null;
            QFilter payerTypeFilter = null;
            if ("zzsybnsr_yz_fzjg".equals(type) && StringUtils.isNotBlank((CharSequence)(zjgOrgId = OrgUtils.queryOrgGroupDetailForAggregator("zzs", ENABLE, orgId, skssqq, skssqz)))) {
                orgFilter = new QFilter("org", "=", (Object)Long.valueOf(zjgOrgId));
                payerTypeFilter = new QFilter("taxpayertype", "=", (Object)"zzsybnsr_yz_zjg");
            }
            if (orgFilter == null) {
                orgFilter = new QFilter("org", "=", (Object)Long.valueOf(orgId));
                payerTypeFilter = new QFilter("taxpayertype", "=", (Object)type);
            }
            if (QueryServiceHelper.exists((String)"tcvat_hz_account_summary", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter = new QFilter("startdate", "=", (Object)skssqq).and(new QFilter("enddate", "=", (Object)skssqz)), payerTypeFilter})) {
                bizParam.put("income", ENABLE);
            }
            if (QueryServiceHelper.exists((String)"tcvat_hz_diffdeduct_temp", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter})) {
                bizParam.put("diff", ENABLE);
                this.putDiffTypeCondition(bizParam, "tcvat_hz_diffdeduct_temp", orgFilter, skssqqzFilter, payerTypeFilter);
            } else {
                this.putDiffTypeconditionDefault(bizParam);
            }
            if (QueryServiceHelper.exists((String)"tcvat_hz_deduction_sum", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter})) {
                bizParam.put("deduct", ENABLE);
            }
            this.setFb5FjsfParams(orgId, startDate, endDate, bizParam);
            dateFilter = new QFilter("startdate", ">=", (Object)DateUtils.getDayFirst(skssqq)).and(new QFilter("enddate", "<=", (Object)DateUtils.getDayLast(skssqz)));
            draftPurposeFilter = new QFilter("draftpurpose", "=", (Object)bizParams.getOrDefault("draftpurpose", "nssb"));
            policyConfirm = QueryServiceHelper.queryOne((String)"tcvat_ybhz_policy_confirm", (String)"bqsfsyjzzc", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgId)), dateFilter, draftPurposeFilter});
            if (policyConfirm != null) {
                bqsfsyjzzc = policyConfirm.getString("bqsfsyjzzc");
            }
        }
        if ("zzsybnsr".equals(type) || "draft_zzsybnsr".equals(type)) {
            QFilter deadLineFilter;
            QFilter taxPeriodFilter;
            orgFilter = new QFilter("org", "=", (Object)Long.valueOf(orgId));
            if (QueryServiceHelper.exists((String)"tcvat_account_summary", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter = new QFilter("taxperiod", ">=", (Object)startDate.substring(0, 7)).and(new QFilter("taxperiod", "<=", (Object)endDate.substring(0, 7))), deadLineFilter = new QFilter(DEADLINE, "=", (Object)deadLine)})) {
                bizParam.put("income", ENABLE);
            }
            if (QueryServiceHelper.exists((String)"tcvat_diffdeduct_temp", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter})) {
                bizParam.put("diff", ENABLE);
                this.putDiffTypeCondition(bizParam, "tcvat_diffdeduct_temp", orgFilter, taxPeriodFilter, deadLineFilter);
            } else {
                this.putDiffTypeconditionDefault(bizParam);
            }
            dateFilter = new QFilter("reportperiod", ">=", (Object)DateUtils.getDayFirst(skssqq)).and(new QFilter("reportperiod", "<=", (Object)DateUtils.getDayLast(skssqz)));
            draftPurposeFilter = new QFilter("draftpurpose", "=", (Object)bizParams.getOrDefault("draftpurpose", "nssb"));
            policyConfirm = QueryServiceHelper.queryOne((String)"tcvat_policy_confirm", (String)"bqsfsyjzzc", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgId)), dateFilter, draftPurposeFilter});
            if (policyConfirm != null) {
                bqsfsyjzzc = policyConfirm.getString("bqsfsyjzzc");
            }
        }
        if ((category = TaxBaseDataUtils.queryCategoryByTaxtype(Long.parseLong(orgId), "fjsf")) != null) {
            bizParam.put(cswhjssenable, ENABLE.equals(category.getString(cswhjssenable)) ? ENABLE : "0");
            bizParam.put(jyffjenable, "2".equals(category.getString(jyffjenable)) ? ENABLE : "0");
            bizParam.put(dfjyffjenable, "3".equals(category.getString(dfjyffjenable)) ? ENABLE : "0");
        }
        this.getOrgParams(orgId, startDate, endDate, bizParam);
        String reliefPolicyType = TaxBaseDataUtils.getReliefPolicyType(Long.valueOf(orgId), skssqq, skssqz, false);
        if (bqsfsyjzzc == null) {
            bqsfsyjzzc = "gtgsh".equals(reliefPolicyType) ? ENABLE : "0";
        }
        bizParam.put("reliefpolicytype", "".equals(reliefPolicyType) ? null : reliefPolicyType);
        bizParam.put("bqsfsyjzzc", bqsfsyjzzc);
        bizParam.put("startDate", startDate);
        bizParam.put("endDate", endDate);
        this.setNsrsbh(orgId, bizParam);
        this.setTaxMainData(orgId, bizParam);
        String registeradd = (String)bizParam.get("registeradd");
        bizParam.put("ischongqing", String.valueOf(AdminDivisionUtils.isSameTargetLevel(ENABLE, "141", registeradd)));
        bizParam.put("isgansu", String.valueOf(AdminDivisionUtils.isSameTargetLevel(ENABLE, "274", registeradd)));
        bizParam.put("ishebei", String.valueOf(AdminDivisionUtils.isSameTargetLevel(ENABLE, "1073", registeradd)));
        bizParam.put("isshenzhen", String.valueOf(AdminDivisionUtils.isSameTargetLevel("2", "407", registeradd)));
        bizParam.put("ischengdu", String.valueOf(AdminDivisionUtils.isSameTargetLevel("2", "2933", registeradd)));
        bizParam.put("isningbo", String.valueOf(AdminDivisionUtils.isSameTargetLevel("2", "3547", registeradd)));
        bizParam.put("isshanxi", String.valueOf(AdminDivisionUtils.isSameTargetLevel(ENABLE, "2817", registeradd)));
        bizParam.put("isfujian", String.valueOf(AdminDivisionUtils.isSameTargetLevel(ENABLE, "179", registeradd)));
        return bizParam;
    }

    private String getAmount(String orgId, String startData, String endData, String name) {
        DynamicObject[] load_0;
        Date sdate = DateUtils.stringToDate(startData);
        Date edate = DateUtils.getDayLast(DateUtils.stringToDate(endData));
        QFilter orgIdFilter_0 = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter startFilter = new QFilter("taxperiod", ">=", (Object)DateUtils.getDayFirst(sdate));
        QFilter endFilter = new QFilter("taxperiod", "<=", (Object)edate);
        QFilter dataSourceFilter_0 = new QFilter("datasources", "=", (Object)"4");
        QFilter dataSourceFilter_1 = new QFilter("datasources", "=", (Object)"27");
        DynamicObjectCollection collection_0 = QueryServiceHelper.query((String)"til_jxdk_ncpjsdk_bill", (String)"entryentity.dataid", (QFilter[])new QFilter[]{orgIdFilter_0, startFilter, endFilter, dataSourceFilter_0});
        List zzsdataid = collection_0.stream().map(s -> s.getLong("entryentity.dataid")).distinct().collect(Collectors.toList());
        DynamicObjectCollection collection_1 = QueryServiceHelper.query((String)"til_jxdk_ncpjsdk_bill", (String)"entryentity.dataid", (QFilter[])new QFilter[]{orgIdFilter_0, startFilter, endFilter, dataSourceFilter_1});
        List qdzpdataid = collection_1.stream().map(s -> s.getLong("entryentity.dataid")).distinct().collect(Collectors.toList());
        if ("amount".equals(name)) {
            DynamicObject[] load_1;
            DynamicObject[] load_02;
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject dynamicObject : load_02 = BusinessDataServiceHelper.load((String)"rim_inv_electric", (String)"invoice_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", qdzpdataid)})) {
                BigDecimal invoice_amount = dynamicObject.getBigDecimal("invoice_amount");
                amount = amount.add(invoice_amount);
            }
            for (DynamicObject dynamicObject : load_1 = BusinessDataServiceHelper.load((String)"rim_inv_special", (String)"invoice_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", zzsdataid)})) {
                BigDecimal invoice_amount = dynamicObject.getBigDecimal("invoice_amount");
                amount = amount.add(invoice_amount);
            }
            return amount.toString();
        }
        BigDecimal taxamount = new BigDecimal(0);
        DynamicObject[] load_1 = load_0 = BusinessDataServiceHelper.load((String)"rim_inv_electric", (String)"effective_tax_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", qdzpdataid)});
        int n = load_1.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject dynamicObject = load_1[i];
            BigDecimal effective_tax_amount = dynamicObject.getBigDecimal("effective_tax_amount");
            taxamount = taxamount.add(effective_tax_amount);
        }
        for (DynamicObject dynamicObject : load_1 = BusinessDataServiceHelper.load((String)"rim_inv_special", (String)"effective_tax_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", zzsdataid)})) {
            BigDecimal effective_tax_amount = dynamicObject.getBigDecimal("effective_tax_amount");
            taxamount = taxamount.add(effective_tax_amount);
        }
        return taxamount.toString();
    }

    private String getYbAmount(String orgId, String startData, String endData, String name) {
        DynamicObject[] load_0;
        Date sdate = DateUtils.stringToDate(startData);
        Date edate = DateUtils.getDayLast(DateUtils.stringToDate(endData));
        QFilter startFilter = new QFilter("taxperiod", ">=", (Object)sdate);
        QFilter endFilter = new QFilter("taxperiod", "<=", (Object)edate);
        QFilter dataSourceFilter_0 = new QFilter("datasources", "=", (Object)"4");
        QFilter dataSourceFilter_1 = new QFilter("datasources", "=", (Object)"27");
        QFilter orgIdFilter_1 = new QFilter("orgrow.collectorg", "=", (Object)orgId);
        QFilter taxTypeFilter = new QFilter("taxtype", "=", (Object)"zzs");
        QFilter effectDateFilter = new QFilter("effectdate", ">=", (Object)sdate);
        QFilter invalidDateFilter = new QFilter("invaliddate", "<=", (Object)edate).or(new QFilter("invaliddate", "is null", null));
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        DynamicObjectCollection collection_2 = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.orgid", (QFilter[])new QFilter[]{orgIdFilter_1, taxTypeFilter, effectDateFilter, invalidDateFilter, statusFilter});
        List orglist = collection_2.stream().map(s -> s.getLong("orgrow.orgid")).distinct().collect(Collectors.toList());
        QFilter orgIdFilter_2 = new QFilter("org", "in", orglist);
        DynamicObjectCollection collection_3 = QueryServiceHelper.query((String)"til_jxdk_ncpjsdk_bill", (String)"entryentity.dataid", (QFilter[])new QFilter[]{orgIdFilter_2, startFilter, endFilter, dataSourceFilter_0});
        List ybzzsdataid = collection_3.stream().map(s -> s.getLong("entryentity.dataid")).distinct().collect(Collectors.toList());
        DynamicObjectCollection collection_4 = QueryServiceHelper.query((String)"til_jxdk_ncpjsdk_bill", (String)"entryentity.dataid", (QFilter[])new QFilter[]{orgIdFilter_2, startFilter, endFilter, dataSourceFilter_1});
        List ybqdzpdataid = collection_4.stream().map(s -> s.getLong("entryentity.dataid")).distinct().collect(Collectors.toList());
        if ("ybamount".equals(name)) {
            DynamicObject[] load_1;
            DynamicObject[] load_02;
            BigDecimal ybamount = BigDecimal.ZERO;
            for (DynamicObject dynamicObject : load_02 = BusinessDataServiceHelper.load((String)"rim_inv_electric", (String)"invoice_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", ybqdzpdataid)})) {
                BigDecimal invoice_amount = dynamicObject.getBigDecimal("invoice_amount");
                ybamount = ybamount.add(invoice_amount);
            }
            for (DynamicObject dynamicObject : load_1 = BusinessDataServiceHelper.load((String)"rim_inv_special", (String)"invoice_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", ybzzsdataid)})) {
                BigDecimal invoice_amount = dynamicObject.getBigDecimal("invoice_amount");
                ybamount = ybamount.add(invoice_amount);
            }
            return ybamount.toString();
        }
        BigDecimal ybtaxamount = BigDecimal.ZERO;
        DynamicObject[] load_1 = load_0 = BusinessDataServiceHelper.load((String)"rim_inv_electric", (String)"effective_tax_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", ybqdzpdataid)});
        int n = load_1.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject dynamicObject = load_1[i];
            BigDecimal invoice_amount = dynamicObject.getBigDecimal("effective_tax_amount");
            ybtaxamount = ybtaxamount.add(invoice_amount);
        }
        for (DynamicObject dynamicObject : load_1 = BusinessDataServiceHelper.load((String)"rim_inv_special", (String)"effective_tax_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", ybzzsdataid)})) {
            BigDecimal invoice_amount = dynamicObject.getBigDecimal("effective_tax_amount");
            ybtaxamount = ybtaxamount.add(invoice_amount);
        }
        return ybtaxamount.toString();
    }

    private void setFb5FjsfParams(String orgId, String startData, String endData, Map<String, String> param) {
        int i;
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter startFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate(startData));
        QFilter endFilter = new QFilter("enddate", "=", (Object)DateUtils.stringToDate(endData));
        QFilter declarationFilter = new QFilter("declaration", "=", (Object)"3");
        DynamicObjectCollection orgList = QueryServiceHelper.query((String)"tcvat_ybhz_zlb_jgfpb", (String)"suborg", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, declarationFilter}, (String)"seqx");
        List suborgList = orgList.stream().map(a -> a.getLong("suborg")).collect(Collectors.toList());
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainFjsfByOrgId(suborgList);
        Map<Long, DynamicObject> orgidMap = ((List)result.getData()).stream().filter(d -> EmptyCheckUtils.isNotEmpty(d.getDynamicObjectCollection("categoryentryentity"))).collect(Collectors.toMap(a -> a.getLong("taxorg.id"), b -> (DynamicObject)b.getDynamicObjectCollection("categoryentryentity").get(0), (m, n) -> m));
        for (i = 0; i < orgList.size(); ++i) {
            if (null == orgList.get(i) || ((DynamicObject)orgList.get(i)).get("suborg") == null) continue;
            Long suborg = ((DynamicObject)orgList.get(i)).getLong("suborg");
            DynamicObject taxMain = orgidMap.get(suborg);
            String cswhjssenable1 = taxMain != null && ENABLE.equals(taxMain.getString(cswhjssenable)) ? ENABLE : "0";
            String jyffjenable1 = taxMain != null && "2".equals(taxMain.getString(jyffjenable)) ? ENABLE : "0";
            String dfjyffjenable1 = taxMain != null && "3".equals(taxMain.getString(dfjyffjenable)) ? ENABLE : "0";
            String orgplace = taxMain != null ? taxMain.getString("orgplace") : "";
            param.put("pm" + i, collectionMap.getOrDefault(orgplace, "cityarea"));
            param.put("ybhzcswhjss" + i, cswhjssenable1);
            param.put("ybhzjyffj" + i, jyffjenable1);
            param.put("ybhzdfjyffj" + i, dfjyffjenable1);
            param.put("ybhzcswhjsstaxrate" + i, ENABLE.equals(cswhjssenable1) ? this.getPolicyParams("CSWHJSS", startData, endData, String.valueOf(suborg)) : "0");
            param.put("ybhzjyffjtaxrate" + i, ENABLE.equals(jyffjenable1) ? this.getPolicyParams("JYFFJ", startData, endData, String.valueOf(suborg)) : "0");
            param.put("ybhzdfjyffjtaxrate" + i, ENABLE.equals(dfjyffjenable1) ? this.getPolicyParams("DFJYFJ", startData, endData, String.valueOf(suborg)) : "0");
        }
        for (i = orgList.size(); i < 10; ++i) {
            param.put("pm" + i, collectionMap.get("cityarea"));
        }
    }

    private String getPolicyParams(String param, String startdate, String enddate, String orgId) {
        List<String> paramList = AssistService.queryAssistParams(param, orgId, startdate, enddate);
        if (paramList.size() > 0) {
            return paramList.get(0);
        }
        return "0";
    }

    private boolean isHangkongOrg(String orgid, String startData, String endData) {
        QFilter orgFilter = new QFilter("orgrow.orgid", "=", (Object)Long.valueOf(orgid));
        QFilter summaryorgtypeFilter = new QFilter("summaryorgtype", "=", (Object)ENABLE);
        QFilter effectdateFilter = new QFilter("effectdate", "<=", (Object)DateUtils.stringToDate(startData));
        QFilter invaliddateFilter = new QFilter("invaliddate", ">=", (Object)DateUtils.stringToDate(endData)).or(QFilter.isNull((String)"invaliddate"));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tctb_org_group_latest", (String)"summaryorgtype,id", (QFilter[])new QFilter[]{orgFilter, summaryorgtypeFilter, effectdateFilter, invaliddateFilter});
        if (dynamicObject != null) {
            return ENABLE.equals(dynamicObject.getString("summaryorgtype"));
        }
        return false;
    }

    private void getOrgParams(String orgId, String startData, String endData, Map<String, String> param) {
        int i;
        QFilter declarationFilter;
        QFilter endFilter;
        QFilter startFilter;
        QFilter orgIdFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        DynamicObjectCollection orgList = QueryServiceHelper.query((String)"tcvat_ybhz_zlb_jgfpb", (String)"suborg", (QFilter[])new QFilter[]{orgIdFilter, startFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate(startData)), endFilter = new QFilter("enddate", "=", (Object)DateUtils.stringToDate(endData)), declarationFilter = new QFilter("declaration", "=", (Object)"3")}, (String)"seqx");
        if (EmptyCheckUtils.isNotEmpty(orgList)) {
            for (i = 0; i < orgList.size(); ++i) {
                if (null == orgList.get(i) || ((DynamicObject)orgList.get(i)).get("suborg") == null) continue;
                QFilter orgFilter = new QFilter("org", "=", ((DynamicObject)orgList.get(i)).get("suborg"));
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"unifiedsocialcode, taxpayer", (QFilter[])new QFilter[]{orgFilter});
                param.put("unifiedsocialcode" + i, dynamicObject.getString("unifiedsocialcode"));
                param.put("taxpayer" + i, dynamicObject.getString("taxpayer"));
            }
        }
        for (i = orgList.size(); i < 10; ++i) {
            param.put("unifiedsocialcode" + i, "");
            param.put("taxpayer" + i, "");
        }
    }

    private void setNsrsbh(String orgId, Map<String, String> param) {
        QFilter orgIdFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"unifiedsocialcode", (QFilter[])new QFilter[]{orgIdFilter});
        if (dynamicObject != null) {
            param.put("nsrsbh", dynamicObject.getString("unifiedsocialcode"));
        }
    }

    private void setTaxMainData(String orgId, Map<String, String> param) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId));
        if (EmptyCheckUtils.isNotEmpty(result.getData())) {
            param.put("registeradd", ((DynamicObject)result.getData()).getString("registeraddress"));
        }
    }

    private void putDiffTypeconditionDefault(Map<String, String> param) {
        param.put("difftaxrate6", "0");
        param.put("difftaxrate9", "0");
        param.put("difftaxrate13", "0");
        param.put("difftypes", "0");
        param.put("difftypejsjts", "0");
    }

    private void putDiffTypeCondition(Map<String, String> param, String entity, QFilter orgFilter, QFilter skssqqzFilter, QFilter payerTypeFilter) {
        QFilter jzjt = new QFilter("jzjt", "=", (Object)ENABLE);
        DynamicObjectCollection query = QueryServiceHelper.query((String)entity, (String)"difftype", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter, jzjt});
        Set difftype = query.stream().map(a -> a.getString("difftype")).collect(Collectors.toSet());
        int difftaxrate6 = difftype.contains("859352590188589058") || difftype.contains("859352590188589059") ? 1 : 0;
        int difftaxrate9 = difftype.contains("859352590188589057") ? 1 : 0;
        int difftaxrate13 = difftype.contains("859352590188589056") ? 1 : 0;
        int diffTypes = difftaxrate6 + difftaxrate9 + difftaxrate13;
        param.put("difftaxrate6", String.valueOf(difftaxrate6));
        param.put("difftaxrate9", String.valueOf(difftaxrate9));
        param.put("difftaxrate13", String.valueOf(difftaxrate13));
        param.put("difftypes", String.valueOf(diffTypes));
        param.put("difftypejsjts", String.valueOf(query.size()));
    }
}

