/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.initparam;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.initparam.DefaultInitParams;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import org.apache.commons.collections4.CollectionUtils;

public class TcvatJzjtInitParams
extends DefaultInitParams {
    private static final String jmxmmc1 = "jmxmmc_jzjt_1";
    private static final String jmxmmc2 = "jmxmmc_jzjt_2";
    private static final String jmxmmc4 = "jmxmmc_jzjt_4";
    private static final String jmxmmc5 = "jmxmmc_jzjt_5";
    private static final Map<String, String> tsfsMap = new HashMap<String, String>(){
        {
            this.put(TcvatJzjtInitParams.jmxmmc1, "csfts");
            this.put(TcvatJzjtInitParams.jmxmmc2, "ablts");
            this.put(TcvatJzjtInitParams.jmxmmc4, "csfts");
            this.put(TcvatJzjtInitParams.jmxmmc5, "csfts");
        }
    };

    @Override
    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        Map<String, String> param = super.buildBizParam(requestModel);
        Map<String, String> bizParam = this.setBizParam(requestModel);
        param.putAll(bizParam);
        return param;
    }

    public Map<String, String> setBizParam(DeclareRequestModel requestModel) {
        TaxResult result;
        Long orgid = requestModel.getOrgId();
        Date skssqq = DateUtils.stringToDate(requestModel.getSkssqq());
        Date skssqz = DateUtils.stringToDate(requestModel.getSkssqz());
        HashMap<String, String> param = new HashMap<String, String>(16);
        Map<String, Object> extendParams = requestModel.getExtendParams();
        if (extendParams.get("sbbid") != null) {
            param.put("sbbid", (String)extendParams.get("sbbid"));
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter bayxqFilter = new QFilter("bayxqq", "<=", (Object)skssqq).and(new QFilter("bayxqz", ">=", (Object)skssqz));
        DynamicObjectCollection jzjtFilings = QueryServiceHelper.query((String)"tcvat_jzjt_filing", (String)"jmxmmc.number as jmxmmc,jmxmmc.id as jmxmmcId", (QFilter[])new QFilter[]{orgFilter, bayxqFilter, new QFilter("billstatus", "=", (Object)"C")}, (String)"billno");
        param.put("sqrlx", "0");
        param.put("tsfs", "-");
        if (CollectionUtils.isNotEmpty((Collection)jzjtFilings)) {
            String jmxmmc = ((DynamicObject)jzjtFilings.get(0)).getString("jmxmmc");
            param.put("tsfs", tsfsMap.get(jmxmmc));
            param.put("jmxmmc", jmxmmc);
            param.put("jmxmmcId", jzjtFilings.stream().map(o -> o.getString("jmxmmcId")).collect(Collectors.joining(",")));
        }
        if ((result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid)).isSuccess() && result.getData() != null) {
            DynamicObject taxMain = (DynamicObject)result.getData();
            param.put("nsrmc", taxMain.getString("taxorg.taxpayer"));
            param.put("nsrsbh", taxMain.getString("taxorg.unifiedsocialcode"));
        }
        DynamicObjectCollection draftList = null;
        if (extendParams.get("draftIds") != null) {
            String draftIds = (String)extendParams.get("draftIds");
            Object[] drafIdArr = Stream.of(draftIds.split(",")).map(Long::new).toArray();
            draftList = QueryServiceHelper.query((String)"tcvat_tsjs_draft_query", (String)"skssqq,skssqz,entryentity.sbbid as sbbid,entryentity.jzjtytsje as jzjtytsje", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)drafIdArr)});
        }
        Map<Object, Object> sbbMap = new HashMap();
        if (draftList != null && CollectionUtils.isNotEmpty(draftList)) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"tcvat_zzs_declare_list", (String)"id,entryentity.sjje as sjje", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)draftList.stream().map(o -> o.getLong("sbbid")).toArray()), new QFilter("entryentity.taxtypes", "=", (Object)"1")});
            sbbMap = query.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        }
        BigDecimal jzjttsjehj = BigDecimal.ZERO;
        for (int i = 0; i < 5; ++i) {
            param.put("sksssq" + (i + 1), "");
            param.put("sz" + (i + 1), "");
            if (draftList == null || draftList.size() <= i) continue;
            DynamicObject draft = (DynamicObject)draftList.get(i);
            param.put("sksssq" + (i + 1), DateUtils.format(draft.getDate("skssqq"), DateUtils.YYYYMMDD_CHINESE) + "-" + DateUtils.format(draft.getDate("skssqz"), DateUtils.YYYYMMDD_CHINESE));
            param.put("sz" + (i + 1), ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"TcvatJzjtInitParams_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            DynamicObject sbb = (DynamicObject)sbbMap.get(draft.getLong("sbbid"));
            if (sbb != null) {
                param.put("sjje" + (i + 1), BigDecimalUtil.format(sbb.getBigDecimal("sjje"), "0.00#"));
            }
            jzjttsjehj = jzjttsjehj.add(draft.getBigDecimal("jzjtytsje"));
        }
        param.put("jzjttsjehj", BigDecimalUtil.format(jzjttsjehj, "0.00#"));
        return param;
    }
}

