/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.initparam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.initparam.DefaultInitParams;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class TcvatVatRtaInitParams
extends DefaultInitParams {
    @Override
    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        Map<String, String> param = super.buildBizParam(requestModel);
        Map<String, String> bizParam = this.setBizParam(requestModel);
        param.putAll(bizParam);
        return param;
    }

    public Map<String, String> setBizParam(DeclareRequestModel requestModel) {
        TaxResult result;
        String sbbStatus;
        Long orgid = requestModel.getOrgId();
        String startdate = requestModel.getSkssqq();
        String enddate = requestModel.getSkssqz();
        Map<String, Object> extendParams = requestModel.getExtendParams();
        Date skssqq = DateUtils.stringToDate2(startdate);
        Date skssqz = DateUtils.stringToDate2(enddate);
        HashMap<String, String> param = new HashMap<String, String>(16);
        String deadLine = "aysb";
        String sjjtdeadline = "aysb";
        String startPeriod = startdate.substring(0, 7);
        param.put("startPeriod", startPeriod);
        param.put("middlePeriod", startPeriod);
        param.put("endPeriod", enddate.substring(0, 7));
        String taxLimit = DateUtils.getTaxLimit(skssqq, skssqz);
        if ("season".equals(taxLimit)) {
            deadLine = "ajsb";
            Date middleDate = DateUtils.addMonth(skssqq, 1);
            param.put("middlePeriod", DateUtils.formatMonth(middleDate));
        }
        param.put("deadline", deadLine);
        String taxPayerType = (String)extendParams.get("taxPayerType");
        param.put("taxpayertype", taxPayerType);
        String sjjtType = "draft_zzsybnsr_sjjt";
        if (StringUtils.isNotBlank((CharSequence)taxPayerType)) {
            sjjtType = "draft_" + taxPayerType + "_sjjt";
        }
        param.put("sjjttype", sjjtType);
        param.put("sjjtdraftstatus", "A");
        DynamicObjectCollection collection = this.querAllSjjtDraft(orgid, sjjtType, skssqq, skssqz);
        if (CollectionUtils.isNotEmpty((Collection)collection)) {
            Date skssqz1;
            Date skssqq1;
            String taxLimit1;
            String billstatus = ((DynamicObject)collection.get(0)).getString("billstatus");
            param.put("sjjtdraftstatus", billstatus);
            if ("ajsb".equals(deadLine) && "season".equals(taxLimit1 = DateUtils.getTaxLimit(skssqq1 = ((DynamicObject)collection.get(0)).getDate("skssqq"), skssqz1 = ((DynamicObject)collection.get(0)).getDate("skssqz")))) {
                sjjtdeadline = "ajsb";
            }
        }
        param.put("sjjtdeadline", sjjtdeadline);
        param.put("startdate", startdate);
        param.put("enddate", enddate);
        param.put("orgid", orgid.toString());
        param.put("startDate", startdate);
        param.put("endDate", enddate);
        param.put("firstStartDate", DateUtils.format(DateUtils.getFirstDateOfMonth(skssqq)));
        param.put("firstEndDate", DateUtils.format(DateUtils.getLastDateOfMonth(skssqq)));
        param.put("lastStartDate", DateUtils.format(DateUtils.getFirstDateOfMonth(skssqz)));
        param.put("lastEndDate", DateUtils.format(DateUtils.getLastDateOfMonth(skssqz)));
        String sbbid = "0";
        DynamicObject dyo = YbnsrService.queryYbnsr(orgid.toString(), taxPayerType, startdate, enddate, null);
        if (null != dyo && "declared".equals(sbbStatus = dyo.getString("declarestatus"))) {
            sbbid = dyo.getString("id");
        }
        param.put("sbbid", sbbid);
        param.put("jmxmmc", "");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter bayxqFilter = new QFilter("bayxqq", "<=", (Object)skssqq).and(new QFilter("bayxqz", ">=", (Object)skssqz));
        DynamicObjectCollection jzjtFilings = QueryServiceHelper.query((String)"tcvat_jzjt_filing", (String)"jmxmmc.number as jmxmmc,jmxmmc.id as jmxmmcId", (QFilter[])new QFilter[]{orgFilter, bayxqFilter, new QFilter("billstatus", "=", (Object)"C")}, (String)"billno");
        if (CollectionUtils.isNotEmpty((Collection)jzjtFilings)) {
            String jmxmmc = ((DynamicObject)jzjtFilings.get(0)).getString("jmxmmc");
            param.put("jmxmmc", jmxmmc);
        }
        if ((result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid)).isSuccess() && result.getData() != null) {
            DynamicObject taxMain = (DynamicObject)result.getData();
            param.put("orgname", taxMain.getString("orgid.name"));
        }
        return param;
    }

    private DynamicObjectCollection querAllSjjtDraft(Long orgId, String templatetype, Date startDate, Date endDate) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter and = new QFilter("org", "=", (Object)orgId).and(new QFilter("templatetype", "=", (Object)templatetype));
        filterList.add(and);
        filterList.add(new QFilter("skssqq", ">=", (Object)startDate).and(new QFilter("skssqz", "<=", (Object)endDate)));
        DynamicObjectCollection draftCollect = QueryServiceHelper.query((String)"tcvat_sjjt_draft_query", (String)"templatetype,skssqq,skssqz,billstatus", (QFilter[])filterList.toArray(new QFilter[0]));
        return draftCollect;
    }
}

