/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.draft;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.service.DeclareService;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.helper.tctrc.RiskCalculateHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class DraftService {
    private static final String ABNORMAL = "abnormal";
    private static final String NORMAL = "normal";
    private static Log LOGGER = LogFactory.getLog(DraftService.class);
    public static final int ONLY_RISK = 1;
    public static final int ALL_RISK = 2;
    public static Map<String, String> RISK_CONTENT_MAP = new HashMap<String, String>(4);
    public static final List<String> DRAFT_RISK_TYPES;

    public static String getRiskContentNormalStr() {
        return ResManager.loadKDString((String)"\u6b63\u5e38", (String)"DraftService_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    public static String getRiskContentAbnormalStr() {
        return ResManager.loadKDString((String)"\u5f02\u5e38", (String)"DraftService_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    public void sendRiskCalRealTimeTask(String orgid, String startdate, String enddate, String zlbSbbTemplateType) {
        LOGGER.info("\u89e6\u53d1\u98ce\u9669\u8ba1\u7b97\uff1aorgId:{},startdate:{},enddate:{},zlbSbbTemplateType:{}", new Object[]{orgid, startdate, enddate, zlbSbbTemplateType});
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setOrgId(Long.parseLong(orgid));
        requestModel.setSkssqq(startdate);
        requestModel.setSkssqz(enddate);
        requestModel.setTemplateType(zlbSbbTemplateType);
        requestModel.setTaxationsys(1L);
        Map<String, Object> params = this.buildTaskParams(requestModel);
        RiskCalculateHelper.calculateRiskAsync(params);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOGGER.error((Throwable)e);
        }
    }

    private Map<String, Object> buildTaskParams(DeclareRequestModel requestModel) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgid", requestModel.getOrgId());
        params.put("skssqq", requestModel.getSkssqq());
        params.put("skssqz", requestModel.getSkssqz());
        params.put("taxationsys", requestModel.getTaxationsys());
        params.put("modelid", requestModel.getModelId());
        params.put("templateid", requestModel.getTemplateId());
        params.put("templatenumber", requestModel.getTemplateNumber());
        params.put("templatetype", requestModel.getTemplateType());
        Map<String, Object> extendParams = requestModel.getExtendParams();
        if (EmptyCheckUtils.isNotEmpty(extendParams)) {
            params.put("taxcategory", extendParams.getOrDefault("taxcategory", "0"));
            params.put("taxareagroup", extendParams.getOrDefault("taxareagroup", "0"));
            params.put("draftpurpose", extendParams.getOrDefault("draftpurpose", ""));
        }
        return params;
    }

    public boolean saveRiskItem(String draftTable, String draftId, String sbbid, List<Map<String, String>> checkResultList, List<Map<String, String>> riskResultList, int saveType) {
        LOGGER.info("\u4fdd\u5b58\u98ce\u9669\u4e8b\u9879\u7684draftId\uff1a{}", (Object)draftId);
        if (StringUtils.isNotEmpty((CharSequence)draftId) && !"0".equals(draftId)) {
            Long draftidvalue = Long.valueOf(draftId);
            DynamicObjectCollection collection = new DynamicObjectCollection();
            if (EmptyCheckUtils.isNotEmpty(checkResultList) || EmptyCheckUtils.isNotEmpty(riskResultList)) {
                DynamicObject dynamicObject;
                long currUserId = RequestContext.getOrCreate().getCurrUserId();
                if (saveType == 2 && EmptyCheckUtils.isNotEmpty(checkResultList)) {
                    for (Map<String, String> map : checkResultList) {
                        dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdtaxr_draft_risk"));
                        dynamicObject.set("draftid", (Object)draftidvalue);
                        dynamicObject.set("sbbid", (Object)sbbid);
                        dynamicObject.set("itemtype", (Object)"1");
                        dynamicObject.set("drafttable", (Object)draftTable);
                        dynamicObject.set("itemname", (Object)map.get("title"));
                        dynamicObject.set("riskdesc", (Object)map.get("content"));
                        dynamicObject.set("creater", (Object)currUserId);
                        collection.add((Object)dynamicObject);
                    }
                }
                if (EmptyCheckUtils.isNotEmpty(riskResultList)) {
                    for (Map<String, String> map : riskResultList) {
                        dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdtaxr_draft_risk"));
                        dynamicObject.set("draftid", (Object)draftidvalue);
                        dynamicObject.set("sbbid", (Object)sbbid);
                        dynamicObject.set("itemtype", (Object)"2");
                        dynamicObject.set("drafttable", (Object)draftTable);
                        dynamicObject.set("riskresolveid", (Object)map.get("id"));
                        dynamicObject.set("itemname", (Object)map.get("tctrcriskname"));
                        dynamicObject.set("riskdesc", (Object)map.get("tctrcriskdesc"));
                        dynamicObject.set("creater", (Object)currUserId);
                        collection.add((Object)dynamicObject);
                    }
                }
            }
            try (TXHandle h = TX.required();){
                try {
                    LOGGER.info("\u66f4\u65b0\u98ce\u9669\u5f02\u5e38\u72b6\u6001\u7684draftId\uff1a{} table:{}", (Object)draftidvalue, (Object)draftTable);
                    QFilter qfilter = new QFilter("id", "=", (Object)draftidvalue);
                    DynamicObject draft = BusinessDataServiceHelper.loadSingle((String)draftTable, (String)"id,riskcontent", (QFilter[])new QFilter[]{qfilter});
                    if (null != draft) {
                        String riskcontent;
                        QFilter qFilter1;
                        boolean exists;
                        String curruntRisksContent;
                        QFilter qFilter = new QFilter("draftid", "=", (Object)draftidvalue).and("drafttable", "=", (Object)draftTable);
                        if (saveType == 1) {
                            qFilter.and("itemtype", "=", (Object)"2");
                        }
                        DeleteServiceHelper.delete((String)"bdtaxr_draft_risk", (QFilter[])qFilter.toArray());
                        if (collection.size() > 0) {
                            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])collection.toArray((Object[])new DynamicObject[collection.size()])));
                        }
                        if (!(curruntRisksContent = (exists = QueryServiceHelper.exists((String)"bdtaxr_draft_risk", (QFilter[])(qFilter1 = new QFilter("draftid", "=", (Object)draftidvalue).and("drafttable", "=", (Object)draftTable)).toArray())) ? ABNORMAL : NORMAL).equals(riskcontent = draft.getString("riskcontent"))) {
                            draft.set("riskcontent", (Object)curruntRisksContent);
                            SaveServiceHelper.update((DynamicObject)draft);
                        }
                    }
                }
                catch (Throwable t) {
                    h.markRollback();
                    LOGGER.error("\u4fdd\u5b58\u98ce\u9669\u4e8b\u9879\u5355\u5f02\u5e38\u7684draftId\uff1a" + draftId + " table:" + draftTable, t);
                    boolean bl = false;
                    if (h != null) {
                        if (var10_19 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                var10_19.addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                    return bl;
                }
            }
        }
        return true;
    }

    public void deleteRiskItem(String draftTable, Set<Object> draftids) {
        if (EmptyCheckUtils.isNotEmpty(draftids)) {
            QFilter qFilter = new QFilter("draftid", "in", draftids).and("drafttable", "=", (Object)draftTable);
            DeleteServiceHelper.delete((String)"bdtaxr_draft_risk", (QFilter[])qFilter.toArray());
        }
    }

    public void setDefaultRiskInfoNoZlb(String draftpurpose, String orgId, String startdate, String enddate, String templatetype) {
        DynamicObject statusBill = StatusUtils.queryOne(templatetype, orgId, startdate, enddate, draftpurpose);
        if (statusBill != null) {
            String draftId = statusBill.getString("id");
            this.setDefaultRiskInfoNoZlb(draftId, draftpurpose);
        }
    }

    private void setDefaultRiskInfoNoZlb(String draftId, String draftpurpose) {
        LOGGER.info("\u4fdd\u5b58\u9ed8\u8ba4\u7533\u62a5\u4e8b\u9879\u7684draftId\uff1a{}", (Object)draftId);
        String draftTable = DraftService.getDraftTable(draftpurpose);
        ArrayList<Map<String, String>> checkFormulaList = new ArrayList<Map<String, String>>(4);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("title", ResManager.loadKDString((String)"\u7eb3\u7a0e\u603b\u89c8\u8868\u5f02\u5e38", (String)"DraftService_0", (String)"taxc-tctb-common", (Object[])new Object[0]));
        map.put("content", ResManager.loadKDString((String)"\u672a\u751f\u6210\u7eb3\u7a0e\u603b\u89c8\u8868", (String)"DraftService_1", (String)"taxc-tctb-common", (Object[])new Object[0]));
        checkFormulaList.add(map);
        this.saveRiskItem(draftTable, draftId, "0", checkFormulaList, null, 2);
    }

    public void calcDraftRiskInfoHasDraft(String draftId, String draftpurpose, String orgId, String startdate, String enddate, String zlbSbbTemplateType, Map<String, String> resultMap, IPageCache pageCache) {
        LOGGER.info("\u8ba1\u7b97\u5e76\u4fdd\u5b58\u5e95\u7a3f\u98ce\u9669\uff1adraftId:{},orgId:{},startdate:{},enddate:{},zlbSbbTemplateType:{},draftpurpose:{}", new Object[]{draftId, orgId, startdate, enddate, zlbSbbTemplateType, draftpurpose});
        if (EmptyCheckUtils.isEmpty(draftId)) {
            DynamicObject statusBill = StatusUtils.queryOne(zlbSbbTemplateType, orgId, startdate, enddate, draftpurpose);
            if (statusBill != null) {
                draftId = statusBill.getString("id");
            } else {
                LOGGER.info("statusBill\u4e3a\u627e\u5230");
            }
        }
        if (EmptyCheckUtils.isNotEmpty(draftId)) {
            this.doSave(draftId, draftpurpose, orgId, startdate, enddate, zlbSbbTemplateType, resultMap, pageCache);
        }
    }

    public void calcDraftRiskInfo(String orgId, String startdate, String enddate, String draftpurpose, String draftTemplateType, String zlbSbbTemplateType, Map<String, String> resultMap, IPageCache cache) {
        LOGGER.info("\u65e0draftid\u8ba1\u7b97\u5e76\u4fdd\u5b58\u5e95\u7a3f\u98ce\u9669\uff1aorgId:{},startdate:{},enddate:{},draftTemplateType{},zlbSbbTemplateType:{},draftpurpose:{}", new Object[]{orgId, startdate, enddate, draftTemplateType, zlbSbbTemplateType, draftpurpose});
        DynamicObject statusBill = StatusUtils.queryOne(draftTemplateType, orgId, startdate, enddate, draftpurpose);
        if (statusBill != null) {
            String draftId = statusBill.getString("id");
            this.doSave(draftId, draftpurpose, orgId, startdate, enddate, zlbSbbTemplateType, resultMap, cache);
        } else {
            LOGGER.info("statusBill\u4e3a\u627e\u5230");
        }
    }

    private void doSave(String draftId, String draftpurpose, String orgId, String startdate, String enddate, String zlbSbbTemplateType, Map<String, String> resultMap, IPageCache cache) {
        this.sendRiskCalRealTimeTask(orgId, startdate, enddate, zlbSbbTemplateType);
        List<Map<String, String>> checkFormulaList = FormulaService.checkFormula(cache);
        List<Map<String, String>> tctrcResult = new DeclareService().queryTctrcResult(orgId, zlbSbbTemplateType, startdate, enddate);
        String draftTable = DraftService.getDraftTable(draftpurpose);
        String sbbid = resultMap.get("tcvat_nsrxx#1#id");
        this.saveRiskItem(draftTable, draftId, sbbid, checkFormulaList, tctrcResult, 2);
    }

    public void deleteRiskInfoByQueryDraft(String orgid, String startdate, String enddate, String draftpurpose, String draftTemplateType) {
        if (EmptyCheckUtils.isNotEmpty(draftTemplateType)) {
            String draftTable = DraftService.getDraftTable(draftpurpose);
            DynamicObject statusBill = StatusUtils.queryOne(draftTemplateType, orgid, startdate, enddate, draftpurpose);
            if (statusBill != null) {
                try (TXHandle h = TX.required();){
                    Object draftId = statusBill.get("id");
                    try {
                        this.deleteRiskItem(draftTable, Collections.singleton(draftId));
                        QFilter qfilter = new QFilter("id", "=", draftId);
                        DynamicObject draft = BusinessDataServiceHelper.loadSingle((String)draftTable, (String)"id,riskcontent", (QFilter[])new QFilter[]{qfilter});
                        if (draft != null) {
                            draft.set("riskcontent", (Object)NORMAL);
                            SaveServiceHelper.update((DynamicObject)draft);
                        }
                    }
                    catch (Throwable t) {
                        h.markRollback();
                        LOGGER.error("\u4fdd\u5b58\u98ce\u9669\u4e8b\u9879\u5355\u5f02\u5e38\u7684draftId\uff1a" + draftId + " table:" + draftTable, t);
                    }
                }
            }
        }
    }

    public static void showRiskDialog(String draftid, String entityId, IFormView view) {
        String draftTable = "";
        if ("tcvat_query_ybnsr".equals(entityId)) {
            draftTable = "tctb_draft_main";
        } else if ("tcvat_sjjt_draft_query".equals(entityId)) {
            draftTable = "tpo_declare_main_tsd";
        } else {
            return;
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bdtaxr_draft_risk_view");
        HashMap<String, String> customParams = new HashMap<String, String>(4);
        customParams.put("draftid", draftid);
        customParams.put("drafttable", draftTable);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(param);
    }

    public static String getDraftTable(String draftPurpose) {
        String draftTable = "nssb".equals(draftPurpose) ? "tctb_draft_main" : "tpo_declare_main_tsd";
        return draftTable;
    }

    public Map<String, List<Map<String, String>>> queryRiskInfo(String draftId, String draftTable) {
        HashMap<String, List<Map<String, String>>> map = new HashMap<String, List<Map<String, String>>>(16);
        ArrayList checkFormulaList = new ArrayList(16);
        ArrayList tctrcwarningList = new ArrayList(16);
        if (StringUtils.isNotEmpty((CharSequence)draftId) && !"0".equals(draftId)) {
            Long draftidvalue = Long.valueOf(draftId);
            QFilter qFilter = new QFilter("draftid", "=", (Object)draftidvalue).and("drafttable", "=", (Object)draftTable);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bdtaxr_draft_risk", (String)"itemtype,itemname,riskdesc,riskresolveid", (QFilter[])qFilter.toArray());
            for (DynamicObject object : query) {
                String itemtype = object.getString("itemtype");
                HashMap<String, String> itemInfo = new HashMap<String, String>(16);
                if ("1".equals(itemtype)) {
                    itemInfo.put("title", object.getString("itemname"));
                    itemInfo.put("content", object.getString("riskdesc"));
                    checkFormulaList.add(itemInfo);
                }
                if (!"2".equals(itemtype)) continue;
                itemInfo.put("id", object.getString("riskresolveid"));
                itemInfo.put("tctrcriskname", object.getString("itemname"));
                itemInfo.put("tctrcriskdesc", object.getString("riskdesc"));
                tctrcwarningList.add(itemInfo);
            }
        }
        map.put("riskwarning", checkFormulaList);
        map.put("tctrcwarning", tctrcwarningList);
        return map;
    }

    static {
        RISK_CONTENT_MAP.put(NORMAL, DraftService.getRiskContentNormalStr());
        RISK_CONTENT_MAP.put(ABNORMAL, DraftService.getRiskContentAbnormalStr());
        RISK_CONTENT_MAP.put(DraftService.getRiskContentNormalStr(), NORMAL);
        RISK_CONTENT_MAP.put(DraftService.getRiskContentAbnormalStr(), ABNORMAL);
        DRAFT_RISK_TYPES = Lists.newArrayList((Object[])new String[]{"draft_zzsybnsr_sjjt", "draft_zzsybnsr", "draft_zzsxgmnsr_sjjt", "draft_zzsxgmnsr", "draft_zzsybnsr_yz_zjg_sjjt", "draft_zzsybnsr_yz_fzjg_Sjjt", "draft_zzsybnsr_ybhz_sjjt", "draft_zzsybnsr_hz_zjg_sjjt"});
    }
}

