/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.enums;

import java.util.Arrays;
import java.util.List;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;

public enum AccrualListEnum {
    ZZS(BaseTaxCategory.ZZS, "zzs", "zzs", "", "tcvat", "tcvat_sjjt_draft_query", false),
    QYSDSJB(BaseTaxCategory.QYSDS, "qysdsjb", "qysds", "", "tccit", "tccit_sjjt_list", false),
    QYSDSJTSBBD(BaseTaxCategory.QYSDS, "JTSX-0060", "CITRTA", "qysds", "", "tccit", "tccit_citrta_query", false),
    SDSJT_BD(BaseTaxCategory.QYSDS, "sdsjt_bd", "qysds", "bdzt", "itp", "itp_draft_query_list", false),
    SDSJT_JT(BaseTaxCategory.QYSDS, "sdsjt_jt", "qysds", "jtzt", "itp", "itp_draft_query_list", false),
    YHS(BaseTaxCategory.YHS, "JTSX-0018", "yhs", "yhs", "", "tcret", "tcret_fcs_accrual_draft", true),
    FCS(BaseTaxCategory.FCS, "JTSX-0019", "fcs", "fcs", "", "tcret", "tcret_fcs_accrual_draft", true),
    CZTDSYS(BaseTaxCategory.CZTDSYS, "JTSX-0020", "cztdsys", "cztdsys", "", "tcret", "tcret_fcs_accrual_draft", true),
    HJBHS(BaseTaxCategory.HBS, "JTSX-0021", "hjbhs", "hjbhs", "", "tcret", "tcret_fcs_accrual_draft", true),
    CCS(BaseTaxCategory.CCS, "JTSX-0022", "ccs", "ccs", "", "tcret", "tcret_fcs_accrual_draft", false),
    SZYS(BaseTaxCategory.SZYS, "JTSX-0044", "szys", "szys", "", "tcret", "tcret_fcs_accrual_draft", false),
    GHJF(BaseTaxCategory.GHJF, "", "ghjf", "ghjf", "", "totf", "totf_sjjt_bill", false),
    SLJSJJ(BaseTaxCategory.SLJSJJ, "", "sljsjj", "sljsjj", "", "totf", "totf_sjjt_bill", false),
    LJCLF(BaseTaxCategory.LJCLF, "", "czljclf", "czljclf", "", "totf", "totf_sjjt_bill", false),
    WHSYJSF(BaseTaxCategory.WHSYJSF, "", "whsyjsf", "whsyjsf", "", "totf", "totf_sjjt_bill", false),
    CJRJYBZJ(BaseTaxCategory.CJRJYBZJ, "", "cjrjybzj", "cjrjybzj", "", "totf", "totf_sjjt_bill", false),
    GHCBJ(BaseTaxCategory.GHCBJ, "", "ghcbj", "ghcbj", "", "totf", "totf_sjjt_bill", false),
    DWFHF(BaseTaxCategory.DWFHF, "", "dwfhf", "dwfhf", "", "totf", "totf_sjjt_bill", false),
    HW_QYSDS(0L, "", "hwqysds", "hwqysds", "", "gtcp", "gtcp_normal_jt_list", false),
    HW_ZZS(0L, "", "hwzzs", "hwzzs", "", "gtcp", "gtcp_normal_jt_list", false);

    private Long baseTaxId;
    private String provistonItemNumber;
    private String category;
    private String taxtype;
    private String accountsettype;
    private String appId;
    private String entryentity;
    private boolean dimprovision;

    private AccrualListEnum(Long baseTaxId, String category, String taxtype, String accountsettype, String appId, String entryentity, boolean dimprovision) {
        this.baseTaxId = baseTaxId;
        this.category = category;
        this.taxtype = taxtype;
        this.accountsettype = accountsettype;
        this.appId = appId;
        this.entryentity = entryentity;
        this.dimprovision = dimprovision;
    }

    private AccrualListEnum(Long baseTaxId, String provistonItemNumber, String category, String taxtype, String accountsettype, String appId, String entryentity, boolean dimprovision) {
        this.baseTaxId = baseTaxId;
        this.provistonItemNumber = provistonItemNumber;
        this.category = category;
        this.taxtype = taxtype;
        this.accountsettype = accountsettype;
        this.appId = appId;
        this.entryentity = entryentity;
        this.dimprovision = dimprovision;
    }

    public Long getBaseTaxId() {
        return this.baseTaxId;
    }

    public String getProvistonItemNumber() {
        return this.provistonItemNumber;
    }

    public String getCategory() {
        return this.category;
    }

    public String getTaxtype() {
        return this.taxtype;
    }

    public String getAccountsettype() {
        return this.accountsettype;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getEntryentity() {
        return this.entryentity;
    }

    public boolean isDimprovision() {
        return this.dimprovision;
    }

    public static AccrualListEnum valueOfBaseTaxId(Long baseTaxId) {
        for (AccrualListEnum value : AccrualListEnum.values()) {
            if (!value.getBaseTaxId().equals(baseTaxId)) continue;
            return value;
        }
        return null;
    }

    public static AccrualListEnum valueOfCateGory(String category) {
        for (AccrualListEnum value : AccrualListEnum.values()) {
            if (!value.getCategory().equals(category)) continue;
            return value;
        }
        return null;
    }

    public static AccrualListEnum valueOfBaseTaxIdAndAccountsettype(Long baseTaxId, String accountsettype) {
        for (AccrualListEnum value : AccrualListEnum.values()) {
            if (!value.getBaseTaxId().equals(baseTaxId) || !value.getAccountsettype().equals(accountsettype)) continue;
            return value;
        }
        return null;
    }

    public static AccrualListEnum valueOfBaseTaxIdAndAccountsettype(Long baseTaxId, String accountsettype, String category) {
        for (AccrualListEnum value : AccrualListEnum.values()) {
            if (value.getBaseTaxId().equals(baseTaxId) && "CITRTA".equals(category)) {
                return QYSDSJTSBBD;
            }
            if (value.getBaseTaxId().equals(baseTaxId) && value.getAccountsettype().equals(accountsettype)) {
                return value;
            }
            if (!"USA_CIT".equals(category) && !"Overseas_CIT".equals(category) && !"Overseas_VAT".equals(category) || !HW_ZZS.getCategory().equals(value.getCategory()) && !HW_QYSDS.getCategory().equals(value.getCategory())) continue;
            return value;
        }
        return null;
    }

    public static Long getBaseTaxIdByCategory(String category) {
        for (AccrualListEnum value : AccrualListEnum.values()) {
            if (!value.getCategory().equals(category)) continue;
            return value.getBaseTaxId();
        }
        return null;
    }

    public static List<AccrualListEnum> needInvokeTax() {
        return Arrays.asList(HW_QYSDS, HW_ZZS);
    }
}

