/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.enums;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;

public enum DataType {
    ZJQS("zjqs", new MultiLangEnumBridge("\u76f4\u63a5\u53d6\u6570", "DataType_0", "taxc-bdtaxr-common")),
    JSFLQS("jsflqs", new MultiLangEnumBridge("\u542b\u7a0e\u4ef7\u6362\u7b97\u4e0d\u542b\u7a0e\u4ef7", "DataType_1", "taxc-bdtaxr-common")),
    CYSLDSQS("cysldsqs", new MultiLangEnumBridge("\u7a0e\u989d\u6362\u7b97\u4e0d\u542b\u7a0e\u4ef7", "DataType_2", "taxc-bdtaxr-common")),
    SEHSHSJ("sehshsj", new MultiLangEnumBridge("\u7a0e\u989d\u6362\u7b97\u542b\u7a0e\u4ef7", "DataType_3", "taxc-bdtaxr-common")),
    HSJHSSE("hsjhsse", new MultiLangEnumBridge("\u542b\u7a0e\u4ef7\u6362\u7b97\u7a0e\u989d", "DataType_4", "taxc-bdtaxr-common")),
    BHSJHSSE("bhsjhsse", new MultiLangEnumBridge("\u4e0d\u542b\u7a0e\u4ef7\u6362\u7b97\u7a0e\u989d", "DataType_5", "taxc-bdtaxr-common")),
    GJQS("gjqs", new MultiLangEnumBridge("\u9ad8\u7ea7\u53d6\u6570", "DataType_7", "taxc-bdtaxr-common")),
    BHSJHSHSJ("bhsjhshsj", new MultiLangEnumBridge("\u4e0d\u542b\u7a0e\u4ef7\u6362\u7b97\u542b\u7a0e\u4ef7", "DataType_6", "taxc-bdtaxr-common"));

    private String code;
    private MultiLangEnumBridge bridge;

    private DataType(String code, MultiLangEnumBridge bridge) {
        this.code = code;
        this.bridge = bridge;
    }

    public String getCode() {
        return this.code;
    }

    public MultiLangEnumBridge getBridge() {
        return this.bridge;
    }

    public static List<ComboItem> buildDataType(List<DataType> dataTypes) {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>();
        for (DataType dataType : DataType.values()) {
            if (dataTypes != null && !dataTypes.contains((Object)dataType)) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(dataType.getCode());
            comboItem.setCaption(new LocaleString(dataType.getBridge().getDescription()));
            result.add(comboItem);
        }
        return result;
    }
}

