/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.enums;

import java.util.Arrays;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;

public enum DeclareCateGory {
    ZZS("zzs", "tcvat", TemplateTypeConstant.getTypeMap().get("zzs")),
    QYSDSNB("qysdsnb", "tccit", new String[]{"qysdsnb", "qysdsnb_fzjg", "qysds_hdzs_nb"}),
    QYSDSJB("qysdsjb", "tccit", new String[]{"qysdsjb", "qysdsyb", "qysds_hdzs_jb"}),
    CCXWS("ccxws", "tcret", new String[]{"ccxws"}),
    WHSYJSF("whsyjsf", "totf", new String[]{"whsyjsf"}),
    QTSFTYSBB("qtsf_tysbb", "totf", new String[]{"qtsf_tysbb"}),
    QTSF_FSSTYSBB("qtsf_fsstysbb", "totf", new String[]{"qtsf_fsstysbb"}),
    CWBB_ND("cwbbnd", "tcvvt", TemplateTypeConstant.getTypeMap().get("cwbbnd")),
    CWBB_FND("cwbbfnd", "tcvvt", TemplateTypeConstant.getTypeMap().get("cwbbfnd")),
    XFSJFJ("xfsjfj", "tcct", TemplateTypeConstant.getTypeMap().get("xfsjfj")),
    HW_QYSDS("hwqysds", "gtcp", new String[]{"Overseas_CIT", "USA_CIT"}),
    HW_ZZS("hwzzs", "gtcp", new String[]{"Overseas_VAT"});

    private String category;
    private String appId;
    private String[] templateType;

    private DeclareCateGory(String category, String appId) {
        this.category = category;
        this.appId = appId;
    }

    private DeclareCateGory(String category, String appId, String[] templateTypes) {
        this.category = category;
        this.appId = appId;
        this.templateType = templateTypes;
    }

    public String[] getTemplateType() {
        return this.templateType;
    }

    public String getCategory() {
        return this.category;
    }

    public String getAppId() {
        return this.appId;
    }

    public static DeclareCateGory valueOfCode(String category) {
        for (DeclareCateGory value : DeclareCateGory.values()) {
            if (!value.getCategory().equals(category)) continue;
            return value;
        }
        return null;
    }

    public static DeclareCateGory valueOfTemplateType(String templateType) {
        for (DeclareCateGory value : DeclareCateGory.values()) {
            String[] templateTypes = value.getTemplateType();
            if (templateTypes == null || !Arrays.asList(templateTypes).contains(templateType)) continue;
            return value;
        }
        return null;
    }
}

