/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.enums;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.DeclareTable;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public enum MultiTableEnum {
    TSCOO1("TSC001", "tpo_declare_main_tsc", "tpo_declare_detail_tsc"),
    TSD001("TSD001", "tpo_declare_main_tsd", "tpo_declare_detail_tsd");

    private String model;
    private String declareMainTable;
    private String declareDetailTabled;
    public static Map<String, String> MODEL_MAP;

    private MultiTableEnum(String model, String declareMainTable, String declareDetailTabled) {
        this.model = model;
        this.declareMainTable = declareMainTable;
        this.declareDetailTabled = declareDetailTabled;
    }

    public static MultiTableEnum getMultiTableByModelNumber(String number) {
        for (MultiTableEnum tableEnum : MultiTableEnum.values()) {
            if (!tableEnum.model.equalsIgnoreCase(number)) continue;
            return tableEnum;
        }
        return null;
    }

    public static DeclareTable getDeclareTable(Long modelId) {
        if (modelId == null) {
            return null;
        }
        String model = MODEL_MAP.get(modelId.toString());
        if (StringUtil.isEmpty((CharSequence)model)) {
            return null;
        }
        for (MultiTableEnum value : MultiTableEnum.values()) {
            if (!value.model.equals(model)) continue;
            return new DeclareTable(value.declareMainTable, value.declareDetailTabled);
        }
        return null;
    }

    public static Long getModelIdByNumber(String number) {
        for (Map.Entry<String, String> entry : MODEL_MAP.entrySet()) {
            if (!entry.getValue().equals(number)) continue;
            return Long.valueOf(entry.getKey());
        }
        return null;
    }

    public static String getDetailTable(Long modelId) {
        if (modelId == null) {
            return null;
        }
        String model = MODEL_MAP.get(modelId.toString());
        if (StringUtil.isEmpty((CharSequence)model)) {
            return null;
        }
        for (MultiTableEnum value : MultiTableEnum.values()) {
            if (!value.model.equals(model)) continue;
            return value.declareDetailTabled;
        }
        return null;
    }

    public static String getModelNumberById(String id) {
        for (Map.Entry<String, String> entry : MODEL_MAP.entrySet()) {
            if (!entry.getKey().equals(id)) continue;
            return entry.getValue();
        }
        return null;
    }

    public String getDeclareMainTable() {
        return this.declareMainTable;
    }

    public String getDeclareDetailTabled() {
        return this.declareDetailTabled;
    }

    public String getModel() {
        return this.model;
    }

    static {
        MODEL_MAP = new HashMap<String, String>(10);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"tpo_model", (String)"id,number", null);
        if (coll != null) {
            for (DynamicObject obj : coll) {
                String fid = obj.getString("id");
                String fnumber = obj.getString("number");
                if (!StringUtil.isNotEmpty((CharSequence)fid) || !StringUtil.isNotEmpty((CharSequence)fnumber)) continue;
                MODEL_MAP.put(fid, fnumber);
            }
        }
    }
}

