/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.enums;

import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;

public enum PayRecordTaxtypeEnum {
    ZZS(BaseTaxCategory.ZZS, "zzs"),
    QYSDS(BaseTaxCategory.QYSDS, "qysds"),
    YHS(BaseTaxCategory.YHS, "yhs"),
    FCS(BaseTaxCategory.FCS, "fcs"),
    FJSF(BaseTaxCategory.FJSF, "fjsf"),
    CZTDSYS(BaseTaxCategory.CZTDSYS, "cztdsys"),
    HBS(BaseTaxCategory.HBS, "hbs"),
    XFS(BaseTaxCategory.XFS, "xfs"),
    ZYS(BaseTaxCategory.ZYS, "zys"),
    SZYS(BaseTaxCategory.SZYS, "szys"),
    CSWHJSS(BaseTaxCategory.CSWHJSS, "cswhjss"),
    JYFFJ(BaseTaxCategory.JYFFJ, "jyffj"),
    DFJYFJ(BaseTaxCategory.DFJYFFJ, "dfjyfj"),
    CCS(BaseTaxCategory.CCS, "ccs"),
    QS(BaseTaxCategory.QS, "qs"),
    TVPT(BaseTaxCategory.TVPT, "tvpt"),
    GDZYS(BaseTaxCategory.GDZYS, "gdzys"),
    TDZZS(BaseTaxCategory.TDZZS, "tdzzs"),
    YYS(BaseTaxCategory.YYS, "yys"),
    GHJF(BaseTaxCategory.GHJF, "ghjf"),
    SLJSJJ(BaseTaxCategory.SLJSJJ, "sljsjj"),
    LJCLF(BaseTaxCategory.LJCLF, "ljclf"),
    WHSYJSF(BaseTaxCategory.WHSYJSF, "whsyjsf"),
    GHCBJ(BaseTaxCategory.GHCBJ, "ghcbj"),
    DWFHF(BaseTaxCategory.DWFHF, "dwfhf"),
    TOTF_CJRJYBZJ(BaseTaxCategory.CJRJYBZJ, "totf_cjrjybzj");

    private Long baseTaxId;
    private String taxtype;

    private PayRecordTaxtypeEnum(Long baseTaxId, String taxtype) {
        this.baseTaxId = baseTaxId;
        this.taxtype = taxtype;
    }

    public Long getBaseTaxId() {
        return this.baseTaxId;
    }

    public String getTaxtype() {
        return this.taxtype;
    }

    public static String getTaxtypeByBaseTaxId(Long baseTaxId) {
        for (PayRecordTaxtypeEnum value : PayRecordTaxtypeEnum.values()) {
            if (!value.getBaseTaxId().equals(baseTaxId)) continue;
            return value.taxtype;
        }
        return "";
    }

    public static String getTaxtypeByBaseTaxId(String baseTaxId) {
        for (PayRecordTaxtypeEnum value : PayRecordTaxtypeEnum.values()) {
            if (!String.valueOf(value.getBaseTaxId()).equals(baseTaxId)) continue;
            return value.taxtype;
        }
        return "";
    }

    public static String getBaseTaxIdByTaxtype(String taxtype) {
        for (PayRecordTaxtypeEnum value : PayRecordTaxtypeEnum.values()) {
            if (!String.valueOf(value.getTaxtype()).equals(taxtype)) continue;
            return String.valueOf(value.getBaseTaxId());
        }
        return "";
    }
}

