/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.enums;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public enum PayRefundHyperlinkParamsEnum {
    OVERSEAS_CIT("Overseas_CIT", new MultiLangEnumBridge("\u7533\u62a5\u5e95\u7a3f\u7f16\u5236", "PayRefundHyperlinkParamsEnum_0", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createGtcpFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "gtcp_normal_declare";
        }
    }
    ,
    USA_CIT("USA_CIT", new MultiLangEnumBridge("\u7533\u62a5\u5e95\u7a3f\u7f16\u5236", "PayRefundHyperlinkParamsEnum_0", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createGtcpFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "gtcp_accrual_declare_than";
        }
    }
    ,
    DEFAULT("default", new MultiLangEnumBridge("\u7533\u62a5\u5e95\u7a3f\u7f16\u5236", "PayRefundHyperlinkParamsEnum_0", "taxc-bdtaxr-common"));

    private String templatetype;
    private MultiLangEnumBridge draftName;

    private PayRefundHyperlinkParamsEnum(String templatetype, MultiLangEnumBridge draftName) {
        this.templatetype = templatetype;
        this.draftName = draftName;
    }

    public String getTemplatetype() {
        return this.templatetype;
    }

    public MultiLangEnumBridge getDraftName() {
        return this.draftName;
    }

    public static PayRefundHyperlinkParamsEnum getEnumByTemplateType(String templatetype) {
        for (PayRefundHyperlinkParamsEnum hyperlinkParamsEnum : PayRefundHyperlinkParamsEnum.values()) {
            if (!hyperlinkParamsEnum.getTemplatetype().equals(templatetype)) continue;
            return hyperlinkParamsEnum;
        }
        return DEFAULT;
    }

    public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
        return this.createDefaultFormShowParameter(dynamicObject);
    }

    public FormShowParameter createDefaultFormShowParameter(DynamicObject dynamicObject) {
        FormShowParameter param = new FormShowParameter();
        HashMap<String, String> customParams = new HashMap<String, String>(4);
        customParams.put("orgid", dynamicObject.getString("org.id"));
        customParams.put("orgname", dynamicObject.getDynamicObject("org").getString("name"));
        Date skssqq = dynamicObject.getDate("skssqq");
        Date skssqz = dynamicObject.getDate("skssqz");
        customParams.put("templatetype", this.templatetype);
        customParams.put("skssqq", DateUtils.format(skssqq, "yyyy-MM-dd"));
        customParams.put("skssqz", DateUtils.format(skssqz, "yyyy-MM-dd"));
        param.setCustomParams(customParams);
        param.setCaption(this.draftName.loadKDString());
        return param;
    }

    public String getDraftNumber() {
        return TemplateEnum.getEnumByDeclareType(this.templatetype).getDeclarePage();
    }

    public FormShowParameter createGtcpFormShowParameter(DynamicObject dynamicObject) {
        FormShowParameter formShowParameter = this.createDefaultFormShowParameter(dynamicObject);
        Map customParams = formShowParameter.getCustomParams();
        customParams.put("billno", dynamicObject.getString("billno"));
        customParams.put("taxationsys", dynamicObject.getLong("taxsystem.id"));
        customParams.put("taxcategory", dynamicObject.getLong("taxtype.id"));
        customParams.put("taxcategory.number", dynamicObject.getString("taxtype.number"));
        customParams.put("taxareagroup", dynamicObject.getLong("taxareagroup.id"));
        formShowParameter.setFormId(this.getDraftNumber());
        formShowParameter.setCustomParams(customParams);
        return formShowParameter;
    }
}

