/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.enums;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public enum ProvisionHyperlinkParamsEnum {
    DRAFT_QYSDSJB("draft_qysdsjb", new MultiLangEnumBridge("\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_0", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createQysdsFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tccit_seasonal_declare";
        }
    }
    ,
    SDSJT_BD("sdsjt_bd", new MultiLangEnumBridge("\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_1", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createItpJtFormShowParameter(dynamicObject);
        }
    }
    ,
    SDSJT_JT("sdsjt_jt", new MultiLangEnumBridge("\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_1", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createItpJtFormShowParameter(dynamicObject);
        }
    }
    ,
    JTYSBBD_BD("jtysbbd_bd", new MultiLangEnumBridge("\u8ba1\u63d0\u4e0e\u7533\u62a5\u6bd4\u5bf9\u7f16\u5236", "ProvisionHyperlinkParamsEnum_13", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createItpJtysbbdFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "itp_accrual_declare_than";
        }
    }
    ,
    JTYSBBD_JT("jtysbbd_jt", new MultiLangEnumBridge("\u8ba1\u63d0\u4e0e\u7533\u62a5\u6bd4\u5bf9\u7f16\u5236", "ProvisionHyperlinkParamsEnum_13", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createItpJtysbbdFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "itp_accrual_declare_than";
        }
    }
    ,
    DRAFT_ZZSYBNSR_SJJT("draft_zzsybnsr_sjjt", new MultiLangEnumBridge("\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_0", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createQysdsFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tcvat_draft_page_sjjt";
        }
    }
    ,
    DRAFT_ZZSXGMNSR_SJJT("draft_zzsxgmnsr_sjjt", new MultiLangEnumBridge("\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_0", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createQysdsFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tcvat_draft_page_sjjt";
        }
    }
    ,
    DRAFT_ZZSYBNSR_YBHZ_SJJT("draft_zzsybnsr_ybhz_sjjt", new MultiLangEnumBridge("\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_0", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createQysdsFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tcvat_draft_page_sjjt";
        }
    }
    ,
    DRAFT_ZZSYBNSR_YZ_ZJG_SJJT("draft_zzsybnsr_yz_zjg_sjjt", new MultiLangEnumBridge("\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_0", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createQysdsFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tcvat_draft_page_sjjt";
        }
    }
    ,
    DRAFT_ZZSYBNSR_HZ_ZJG_SJJT("draft_zzsybnsr_hz_zjg_sjjt", new MultiLangEnumBridge("\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_0", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createQysdsFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tcvat_rta_edit";
        }
    }
    ,
    VAT_RTA("VAT_RTA", new MultiLangEnumBridge("\u8ba1\u63d0\u4e0e\u7533\u62a5\u6bd4\u5bf9\u7f16\u5236", "ProvisionHyperlinkParamsEnum_11", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createQysdsFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tcvat_draft_page_sjjt";
        }
    }
    ,
    CITRTA("CITRTA", new MultiLangEnumBridge("\u8ba1\u63d0\u4e0e\u7533\u62a5\u6bd4\u5bf9\u7f16\u5236", "ProvisionHyperlinkParamsEnum_11", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createQysdsFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tccit_sjjt_list";
        }
    }
    ,
    DRAFT_TCRET_YHS("yhs", new MultiLangEnumBridge("\u5370\u82b1\u7a0e\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_2", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTcretFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tcret_yhs_acccrual";
        }
    }
    ,
    DRAFT_TCRET_FCS("fcs", new MultiLangEnumBridge("\u623f\u4ea7\u7a0e\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_3", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTcretFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tcret_fcs_accrual_draft";
        }
    }
    ,
    DRAFT_TCRET_CZTDSYS("cztdsys", new MultiLangEnumBridge("\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_4", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTcretFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tcret_fcs_accrual_draft";
        }
    }
    ,
    DRAFT_TCRET_HJBHS("hjbhs", new MultiLangEnumBridge("\u73af\u4fdd\u7a0e\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_5", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTcretFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tcret_hbs_accrual_draft";
        }
    }
    ,
    DRAFT_TCRET_CCS("ccs", new MultiLangEnumBridge("\u8f66\u8239\u7a0e\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_6", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTcretFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tcret_ccs_accrual_draft";
        }
    }
    ,
    DRAFT_TCRET_SZYS("szys", new MultiLangEnumBridge("\u6c34\u8d44\u6e90\u7a0e\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_12", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTcretFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tcret_szys_accrual_draft";
        }
    }
    ,
    DRAFT_TCRET_YHS_BD("yhs_bd", new MultiLangEnumBridge("\u5370\u82b1\u7a0e\u8ba1\u63d0\u6bd4\u5bf9\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_7", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTcretBDFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tcret_compare_yhs";
        }
    }
    ,
    DRAFT_TCRET_FCS_BD("fcs_bd", new MultiLangEnumBridge("\u623f\u4ea7\u7a0e\u8ba1\u63d0\u6bd4\u5bf9\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_8", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTcretBDFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tcret_compare_fcs";
        }
    }
    ,
    DRAFT_TCRET_CZTDSYS_BD("cztdsys_bd", new MultiLangEnumBridge("\u571f\u5730\u4f7f\u7528\u7a0e\u8ba1\u63d0\u6bd4\u5bf9\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_9", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTcretBDFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "tcret_compare_tds";
        }
    }
    ,
    OVERSEAS_CIT("Overseas_CIT", new MultiLangEnumBridge("\u901a\u7528\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_10", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createGtcpFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "gtcp_accrual_declare_than";
        }
    }
    ,
    USA_CIT("USA_CIT", new MultiLangEnumBridge("\u901a\u7528\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_10", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createGtcpFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "gtcp_accrual_declare_than";
        }
    }
    ,
    OVERSEAS_VAT_RTA("Overseas_VAT_RTA", new MultiLangEnumBridge("\u8ba1\u63d0\u4e0e\u7533\u62a5\u6bd4\u5bf9\u7f16\u5236", "ProvisionHyperlinkParamsEnum_11", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createGtcpFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "gtcp_jt_declare_than";
        }
    }
    ,
    OVERSEAS_CIT_RTA("Overseas_CIT_RTA", new MultiLangEnumBridge("\u8ba1\u63d0\u4e0e\u7533\u62a5\u6bd4\u5bf9\u7f16\u5236", "ProvisionHyperlinkParamsEnum_11", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createGtcpFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "gtcp_jt_declare_than";
        }
    }
    ,
    USA_CIT_RTA("USA_CIT_RTA", new MultiLangEnumBridge("\u8ba1\u63d0\u4e0e\u7533\u62a5\u6bd4\u5bf9\u7f16\u5236", "ProvisionHyperlinkParamsEnum_11", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createGtcpFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "gtcp_jt_declare_than";
        }
    }
    ,
    DRAFT_SLJSJJ("sljsjj", new MultiLangEnumBridge("\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_0", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTotfFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "totf_sjjt_bill";
        }
    }
    ,
    DRAFT_DWFHF("dwfhf", new MultiLangEnumBridge("\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_0", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTotfFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "totf_sjjt_bill";
        }
    }
    ,
    DRAFT_WHSYJSF("whsyjsf", new MultiLangEnumBridge("\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_0", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTotfFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "totf_sjjt_bill";
        }
    }
    ,
    DRAFT_GHJF("ghjf", new MultiLangEnumBridge("\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_0", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTotfFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "totf_sjjt_bill";
        }
    }
    ,
    DRAFT_GHCBJ("ghcbj", new MultiLangEnumBridge("\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_0", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTotfFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "totf_sjjt_bill";
        }
    }
    ,
    DRAFT_CZLJCLF("czljclf", new MultiLangEnumBridge("\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_0", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTotfFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "totf_sjjt_bill";
        }
    }
    ,
    DRAFT_CJRJYBZJ("cjrjybzj", new MultiLangEnumBridge("\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_0", "taxc-bdtaxr-common")){

        @Override
        public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
            return this.createTotfFormShowParameter(dynamicObject);
        }

        @Override
        public String getDraftNumber() {
            return "totf_sjjt_bill";
        }
    }
    ,
    DEFAULT("default", new MultiLangEnumBridge("\u5e95\u7a3f\u7f16\u5236", "ProvisionHyperlinkParamsEnum_1", "taxc-bdtaxr-common"));

    private String templatetype;
    private MultiLangEnumBridge draftName;

    private ProvisionHyperlinkParamsEnum(String templatetype, MultiLangEnumBridge draftName) {
        this.templatetype = templatetype;
        this.draftName = draftName;
    }

    public String getTemplatetype() {
        return this.templatetype;
    }

    public MultiLangEnumBridge getDraftName() {
        return this.draftName;
    }

    public static ProvisionHyperlinkParamsEnum getEnumByTemplateType(String templatetype) {
        for (ProvisionHyperlinkParamsEnum hyperlinkParamsEnum : ProvisionHyperlinkParamsEnum.values()) {
            if (!hyperlinkParamsEnum.getTemplatetype().equals(templatetype)) continue;
            return hyperlinkParamsEnum;
        }
        return DEFAULT;
    }

    public FormShowParameter createFormShowParameter(DynamicObject dynamicObject) {
        return this.createDefaultFormShowParameter(dynamicObject);
    }

    public FormShowParameter createDefaultFormShowParameter(DynamicObject dynamicObject) {
        FormShowParameter param = new FormShowParameter();
        HashMap<String, String> customParams = new HashMap<String, String>(4);
        customParams.put("orgid", dynamicObject.getDynamicObject("org").getString("id"));
        customParams.put("orgname", dynamicObject.getDynamicObject("org").getString("name"));
        Date skssqq = dynamicObject.getDate("skssqq");
        Date skssqz = dynamicObject.getDate("skssqz");
        customParams.put("templatetype", this.templatetype);
        customParams.put("skssqq", DateUtils.format(skssqq, "yyyy-MM-dd"));
        customParams.put("skssqz", DateUtils.format(skssqz, "yyyy-MM-dd"));
        param.setCustomParams(customParams);
        param.setCaption(this.draftName.loadKDString());
        return param;
    }

    public String getDraftNumber() {
        return TemplateEnum.getEnumByDeclareType(this.templatetype).getDeclarePage();
    }

    protected FormShowParameter createItpJtFormShowParameter(DynamicObject dynamicObject) {
        FormShowParameter formShowParameter = this.createDefaultFormShowParameter(dynamicObject);
        Map customParams = formShowParameter.getCustomParams();
        customParams.put("taxationsys", dynamicObject.getLong("taxsystem.id"));
        customParams.put("zt_type", dynamicObject.getString("accountsettype"));
        customParams.put("billno", dynamicObject.getString("billno"));
        customParams.put("comment", dynamicObject.getString("remarks"));
        customParams.put("papers_status", dynamicObject.getString("billstatus"));
        customParams.put("comparisontype", dynamicObject.getString("comparisontype"));
        customParams.put("isadjustperiod", dynamicObject.getBoolean("isadjustperiod"));
        customParams.put("adjustperiod", dynamicObject.getString("adjustperiod"));
        formShowParameter.setFormId(this.getDraftNumber());
        formShowParameter.setCustomParams(customParams);
        return formShowParameter;
    }

    protected FormShowParameter createItpJtysbbdFormShowParameter(DynamicObject dynamicObject) {
        FormShowParameter formShowParameter = this.createDefaultFormShowParameter(dynamicObject);
        Map customParams = formShowParameter.getCustomParams();
        customParams.put("taxationsys", dynamicObject.getLong("taxsystem.id"));
        customParams.put("zt_type", dynamicObject.getString("accountsettype"));
        customParams.put("billno", dynamicObject.getString("billno"));
        customParams.put("comment", dynamicObject.getString("remarks"));
        customParams.put("papers_status", dynamicObject.getString("billstatus"));
        customParams.put("comparisontype", dynamicObject.getString("comparisontype"));
        formShowParameter.setFormId(this.getDraftNumber());
        formShowParameter.setCustomParams(customParams);
        return formShowParameter;
    }

    public FormShowParameter createGtcpFormShowParameter(DynamicObject dynamicObject) {
        FormShowParameter formShowParameter = this.createDefaultFormShowParameter(dynamicObject);
        Map customParams = formShowParameter.getCustomParams();
        customParams.put("billno", dynamicObject.getString("billno"));
        customParams.put("taxationsys", dynamicObject.getLong("taxsystem.id"));
        customParams.put("taxcategory", dynamicObject.getLong("taxtype.id"));
        customParams.put("taxareagroup", dynamicObject.getLong("taxareagroup.id"));
        formShowParameter.setFormId(this.getDraftNumber());
        formShowParameter.setCustomParams(customParams);
        return formShowParameter;
    }

    protected FormShowParameter createQysdsFormShowParameter(DynamicObject dynamicObject) {
        boolean openDraftPage = true;
        FormShowParameter formShowParameter = this.createDefaultFormShowParameter(dynamicObject);
        Map customParams = formShowParameter.getCustomParams();
        Date skssqq = dynamicObject.getDate("skssqq");
        Date skssqz = dynamicObject.getDate("skssqz");
        customParams.put("skssqq", DateUtils.format(skssqq, "yyyy-MM-dd"));
        customParams.put("skssqz", DateUtils.format(skssqz, "yyyy-MM-dd"));
        customParams.put("draftpurpose", dynamicObject.getString("draftpurpose"));
        String templatetype = dynamicObject.getString("templatetype.number");
        if (EmptyCheckUtils.isEmpty(templatetype)) {
            templatetype = this.templatetype;
        }
        TemplateEnum draftEnum = TemplateEnum.getEnumByDraftType(templatetype);
        if (openDraftPage) {
            customParams.put("viewDraft", "true");
            customParams.put("limit", DateUtils.getTaxLimit(skssqq, skssqz));
            formShowParameter.setFormId(draftEnum.getDraftPage());
        } else {
            formShowParameter.setFormId(draftEnum.getDeclarePage());
        }
        formShowParameter.setCustomParams(customParams);
        return formShowParameter;
    }

    protected FormShowParameter createTcretFormShowParameter(DynamicObject dynamicObject) {
        AccrualListEnum accrualListEnum;
        String accrualDraftType = dynamicObject.getString("templatetype.number");
        if (EmptyCheckUtils.isEmpty(accrualDraftType) && (accrualListEnum = AccrualListEnum.valueOfBaseTaxId(dynamicObject.getLong("taxtype.id"))) != null) {
            accrualDraftType = accrualListEnum.getTaxtype();
        }
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("drafttype", accrualDraftType);
        String formId = "tcret_fcs_accrual_draft";
        switch (accrualDraftType) {
            case "fcs": {
                formId = "tcret_fcs_accrual_draft";
                break;
            }
            case "cztdsys": {
                formId = "tcret_fcs_accrual_draft";
                break;
            }
            case "yhs": {
                formId = "tcret_yhs_acccrual";
                break;
            }
            case "hjbhs": {
                formId = "tcret_hbs_accrual_draft";
                break;
            }
            case "ccs": {
                formId = "tcret_ccs_accrual_draft";
                break;
            }
            case "szys": {
                formId = "tcret_szys_accrual_draft";
            }
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setCustomParams(customParams);
        billShowParameter.setPkId(dynamicObject.getPkValue());
        billShowParameter.setStatus(OperationStatus.EDIT);
        billShowParameter.setFormId(formId);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return billShowParameter;
    }

    protected FormShowParameter createTcretBDFormShowParameter(DynamicObject dynamicObject) {
        AccrualListEnum accrualListEnum;
        String accrualDraftType = dynamicObject.getString("templatetype.number");
        if (EmptyCheckUtils.isEmpty(accrualDraftType) && (accrualListEnum = AccrualListEnum.valueOfBaseTaxId(dynamicObject.getLong("taxtype.id"))) != null) {
            accrualDraftType = accrualListEnum.getTaxtype();
        }
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("drafttype", accrualDraftType);
        String formId = "tcret_compare_fcs";
        switch (accrualDraftType) {
            case "fcs": {
                formId = "tcret_compare_fcs";
                break;
            }
            case "cztdsys": {
                formId = "tcret_compare_tds";
                break;
            }
            case "yhs": {
                formId = "tcret_compare_yhs";
            }
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setCustomParams(customParams);
        billShowParameter.setPkId(dynamicObject.getPkValue());
        billShowParameter.setStatus(OperationStatus.EDIT);
        billShowParameter.setFormId(formId);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return billShowParameter;
    }

    protected FormShowParameter createTotfFormShowParameter(DynamicObject dynamicObject) {
        HashMap customParams = new HashMap();
        String formId = "totf_sjjt_bill";
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setCustomParams(customParams);
        billShowParameter.setPkId(dynamicObject.getPkValue());
        billShowParameter.setFormId(formId);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return billShowParameter;
    }
}

