/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.enums;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.constant.ZspmConstant;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;

public enum ZspmEnum {
    GHJH("qtsf_tysbb", ZspmConstant.ID_GHJH_ZPSM, "0086", new MultiLangEnumBridge("\u5de5\u4f1a\u7ecf\u8d39", "ZspmEnum_0", "taxc-bdtaxr-common"), "zerodeclare_ghjf", ZspmConstant.zeroFields_ty, ZspmConstant.emptyFields, BaseTaxCategory.QTSR),
    GHCBJ("qtsf_tysbb", ZspmConstant.ID_GHCBJ_ZPSM, "0087", new MultiLangEnumBridge("\u5de5\u4f1a\u7b79\u5907\u91d1", "ZspmEnum_1", "taxc-bdtaxr-common"), "zerodeclare_ghcbj", ZspmConstant.zeroFields_ty, ZspmConstant.emptyFields, BaseTaxCategory.QTSR),
    DFSLJSJJ("qtsf_tysbb", ZspmConstant.ID_DFSLJSJJ_ZPSM, "0089", new MultiLangEnumBridge("\u5730\u65b9\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", "ZspmEnum_2", "taxc-bdtaxr-common"), "zerodeclare", ZspmConstant.zeroFields_ty, ZspmConstant.emptyFields, BaseTaxCategory.SLHSZXSR),
    DWFHF("qtsf_tysbb", ZspmConstant.ID_DWFHF_ZPSM, "0090", new MultiLangEnumBridge("\u5824\u56f4\u9632\u62a4\u8d39", "ZspmEnum_3", "taxc-bdtaxr-common"), BaseTaxCategory.SLHSZXSR),
    CZLJCLF("qtsf_fsstysbb", ZspmConstant.ID_CZLJCLF_ZPSM, "0091", new MultiLangEnumBridge("\u57ce\u9547\u5783\u573e\u5904\u7406\u8d39", "ZspmEnum_4", "taxc-bdtaxr-common"), "zerodeclare_czljcl", ZspmConstant.zeroFields_fssrty, ZspmConstant.emptyFields, BaseTaxCategory.JSXZSYXSFSR),
    DFSLJSJJFS("qtsf_fsstysbb", ZspmConstant.ID_DFSLJSJJ_ZPSM, "0089", new MultiLangEnumBridge("\u5730\u65b9\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", "ZspmEnum_2", "taxc-bdtaxr-common"), "zerodeclare", ZspmConstant.zeroFields_fssrty, ZspmConstant.emptyFields, BaseTaxCategory.SLHSZXSR),
    WHSYJSF("whsyjsf", ZspmConstant.ID_WHSYJSF_ZPSM, "0096", new MultiLangEnumBridge("\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39", "ZspmEnum_5", "taxc-bdtaxr-common"), BaseTaxCategory.WHSYJSF),
    STBCBCF("qtsf_fsstysbb", ZspmConstant.ID_STBCBCF_ZPSM, "301760101", new MultiLangEnumBridge("\u6c34\u571f\u4fdd\u6301\u8865\u507f\u8d39\u6536\u5165", "ZspmEnum_6", "taxc-bdtaxr-common"), BaseTaxCategory.STBCBCF),
    STBCBCF_JSQSR("qtsf_fsstysbb", ZspmConstant.ID_STBCBCF_JSQSR_ZPSM, "301760102", new MultiLangEnumBridge("\u6c34\u571f\u4fdd\u6301\u8865\u507f\u8d39\u6536\u5165-\u5efa\u8bbe\u671f\u6536\u5165", "ZspmEnum_7", "taxc-bdtaxr-common"), BaseTaxCategory.STBCBCF),
    STBCBCF_KCQSR("qtsf_fsstysbb", ZspmConstant.ID_STBCBCF_KCQSR_ZPSM, "301760103", new MultiLangEnumBridge("\u6c34\u571f\u4fdd\u6301\u8865\u507f\u8d39\u6536\u5165-\u5f00\u91c7\u671f\u6536\u5165", "ZspmEnum_8", "taxc-bdtaxr-common"), BaseTaxCategory.STBCBCF),
    STBCBCF_QTSR("qtsf_fsstysbb", ZspmConstant.ID_STBCBCF_QTSR_ZPSM, "301760104", new MultiLangEnumBridge("\u6c34\u571f\u4fdd\u6301\u8865\u507f\u8d39\u6536\u5165-\u5176\u4ed6\u6536\u5165", "ZspmEnum_9", "taxc-bdtaxr-common"), BaseTaxCategory.STBCBCF);

    private String templateType;
    private Long id;
    private String number;
    private MultiLangEnumBridge name;
    private String paramKey;
    private List<String> zeroFields;
    private List<String> emptyFields;
    private Long taxcatetory;

    private ZspmEnum(String templateType, Long id, String number, MultiLangEnumBridge name, Long taxcatetory) {
        this.templateType = templateType;
        this.id = id;
        this.number = number;
        this.name = name;
        this.taxcatetory = taxcatetory;
    }

    private ZspmEnum(String templateType, Long id, String number, MultiLangEnumBridge name, String paramKey, List<String> zeroFields, List<String> emptyFields, Long taxcatetory) {
        this.templateType = templateType;
        this.id = id;
        this.number = number;
        this.name = name;
        this.paramKey = paramKey;
        this.zeroFields = zeroFields;
        this.emptyFields = emptyFields;
        this.taxcatetory = taxcatetory;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    public Long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public String getParamKey() {
        return this.paramKey;
    }

    public List<String> getZeroFields() {
        return this.zeroFields;
    }

    public List<String> getEmptyFields() {
        return this.emptyFields;
    }

    public Long getTaxcatetory() {
        return this.taxcatetory;
    }

    public static Long getZspmIdByNameAndTemplateType(String zspmName, String templateType) {
        for (ZspmEnum zspmEnum : ZspmEnum.values()) {
            if (!zspmEnum.getName().equals(zspmName) || !zspmEnum.getTemplateType().equals(templateType)) continue;
            return zspmEnum.getId();
        }
        return null;
    }

    public static Long getTaxcatetoryByNameAndTemplateType(String zspmName, String templateType) {
        for (ZspmEnum zspmEnum : ZspmEnum.values()) {
            if (!zspmEnum.getName().equals(zspmName) || !zspmEnum.getTemplateType().equals(templateType)) continue;
            return zspmEnum.getTaxcatetory();
        }
        return null;
    }

    public static List<Long> getZspmIdsByTemplateType(String templateType) {
        ArrayList<ZspmEnum> zspmEnums = new ArrayList<ZspmEnum>();
        for (ZspmEnum zspmEnum : ZspmEnum.values()) {
            if (!zspmEnum.getTemplateType().equals(templateType)) continue;
            zspmEnums.add(zspmEnum);
        }
        return zspmEnums.stream().map(ZspmEnum::getId).collect(Collectors.toList());
    }

    public static List<ZspmEnum> getZeroZspmEnums(String templateType) {
        ArrayList<ZspmEnum> zeroZspmList = new ArrayList<ZspmEnum>();
        for (ZspmEnum zspmEnum : ZspmEnum.values()) {
            if (!zspmEnum.getTemplateType().equals(templateType) || zspmEnum.getParamKey() == null) continue;
            zeroZspmList.add(zspmEnum);
        }
        return zeroZspmList;
    }

    public static ZspmEnum valueOfNumber(String number) {
        for (ZspmEnum zspmEnum : ZspmEnum.values()) {
            if (!zspmEnum.getNumber().equals(number)) continue;
            return zspmEnum;
        }
        return null;
    }

    public static Long getTaxcatetoryByZspmId(String ZspmId) {
        for (ZspmEnum zspmEnum : ZspmEnum.values()) {
            if (!String.valueOf(zspmEnum.getId()).equals(ZspmId)) continue;
            return zspmEnum.getTaxcatetory();
        }
        return null;
    }

    public static ZspmEnum valueOfZspmId(Long zspmId) {
        for (ZspmEnum zspmEnum : ZspmEnum.values()) {
            if (!zspmEnum.getId().equals(zspmId)) continue;
            return zspmEnum;
        }
        return null;
    }
}

