/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.db.DataSaveService;
import kd.taxc.bdtaxr.common.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.formula.context.CalFormulaContent;
import kd.taxc.bdtaxr.common.formula.context.CheckFormulaContent;
import kd.taxc.bdtaxr.common.formula.service.CacheFormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.utils.JsonUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;

public class FormulaContentService {
    private static Log logger = LogFactory.getLog(FormulaContentService.class);

    public static Map<String, String> initCal(IPageCache cache, Map<String, String> dyoMap) {
        long time = System.currentTimeMillis();
        CalFormulaContent c = new CalFormulaContent(CacheUtils.getInstance().getParam(cache));
        logger.info("sql\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        CacheUtils.removeTemplateId(cache);
        Map<String, String> maps = c.initCal(dyoMap, CacheUtils.getInstance().getParam(cache), CacheFormulaService.getFormulas(cache), CacheFormulaService.getSformulas(cache));
        logger.info("\u521d\u59cb\u5316\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return maps;
    }

    public static Map<String, String> cal(IPageCache cache, String key, String value) {
        Map<String, String> values = CacheUtils.getInstance().getDataResult(cache);
        values.put(key, value);
        Map<String, String> map = new CalFormulaContent().cal(values, CacheUtils.getInstance().getParam(cache), CacheFormulaService.getFormulas(cache), CacheFormulaService.getQformulas(cache), key);
        CacheUtils.getInstance().setDataResult(cache, map);
        return map;
    }

    public static List<Map<String, String>> checkFormula(IPageCache cache) {
        return new CheckFormulaContent().cal(CacheUtils.getInstance().getDataResult(cache), CacheUtils.getInstance().getParam(cache), CacheFormulaService.queryCheckFormulas(cache));
    }

    public static List<Map<String, String>> checkFormula(IPageCache cache, boolean refreshCheckFormula) {
        if (refreshCheckFormula) {
            CacheFormulaService.removeCheckCache(cache);
        }
        return FormulaContentService.checkFormula(cache);
    }

    public static Map<String, DynamicObjectCollection> saveData(Map<String, String> data) {
        return DataSaveService.mapToTable("tcvat_nsrxx", data, new HashMap<String, String>());
    }

    public static Map<String, DynamicObjectCollection> saveData(IPageCache cache) {
        Map<String, String> newMap = CacheUtils.getInstance().getDataResult(cache);
        logger.info("\u3010FormulaContentService\u3011\u4fdd\u5b58\u6570\u636e\uff0cnewMap={}", (Object)JsonUtils.mapToStr(newMap));
        TemplateUtils.handleSpecialFieldValuePreSave(cache.get("templatetype"), newMap);
        Map<String, String> oldMap = CacheUtils.getInstance().getOrginalDataResult(cache);
        logger.info("\u3010FormulaContentService\u3011\u4fdd\u5b58\u6570\u636e\uff0coldMap={}", (Object)JsonUtils.mapToStr(oldMap));
        Map<String, DynamicObjectCollection> maps = DataSaveService.mapToTable("tcvat_nsrxx", newMap, oldMap);
        CacheUtils.getInstance().setOrginalDataResult(cache, JsonUtils.mapToStr(newMap));
        return maps;
    }

    public static Map<String, DynamicObjectCollection> initSyncTask(String orgId, Map<String, Object> extendParams, Map<String, String> mainInfoMap) {
        Map<String, DynamicObjectCollection> returnData = new HashMap<String, DynamicObjectCollection>(16);
        Long groupId = Long.parseLong(extendParams.get("groupid").toString());
        QFilter qFilter = new QFilter("groupplan", "=", (Object)groupId);
        List<Map<String, String>> dataList = TemplateUtils.dataToMapSpecial("tcvvt_roll_list", "#", new QFilter[]{qFilter});
        for (Map<String, String> singleMap : dataList) {
            singleMap.putAll(mainInfoMap);
            Map<String, DynamicObjectCollection> collectionMap = FormulaContentService.saveData(singleMap);
            if (!singleMap.get("tcvvt_clique_mcinfo#1#org").equals(orgId)) continue;
            returnData = collectionMap;
        }
        return returnData;
    }
}

