/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.biz;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.db.MapToTableUtils;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.formula.FormulaContentService;
import kd.taxc.bdtaxr.common.formula.biz.impl.InitParamsSerivce;
import kd.taxc.bdtaxr.common.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.formula.service.CacheFormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections.map.HashedMap;

public class FormulaService {
    private static Log logger = LogFactory.getLog(FormulaService.class);
    private static final String APANAGE = "apanage";
    private static final String SERIALNO = "serialno";
    private static final String SBLX = "sblx";
    private static final String TCRETTYPE = "tcrettype";
    private static final String TAX_LIMIT = "taxlimit";
    private static final List<String> NO_DEFAULT_VALUE_TABLES = Lists.newArrayList((Object[])new String[]{"tctb_declare_entry"});

    public static Map<String, String> query(IPageCache cache, String type, String orgId, String startData, String endData, boolean isUpdate) {
        Map<String, DynamicObjectCollection> map;
        Map<String, String> params;
        DynamicObject dyo;
        long time = System.currentTimeMillis();
        Map<String, String> data = CacheUtils.getInstance().getDataResult(cache);
        if (data != null && !data.isEmpty() && !isUpdate) {
            logger.info("\u4ece\u7f13\u5b58\u4e2d\u8bfb\u53d6\u65f6\u95f4:" + (System.currentTimeMillis() - time));
            return data;
        }
        Map<String, Object> extendParams = FormulaService.getExtendParamsByType(type, cache);
        if (null != cache.get("taxorg")) {
            cache.put("orgid", orgId);
            orgId = cache.get("taxorg");
        }
        if (null == (dyo = TemplateTypeConstant.SINGLE_TAXLIMIT_TYPE.contains(type) ? YbnsrService.queryYbnsr(cache.get("sbbid")) : YbnsrService.queryYbnsr(orgId, type, startData, endData, extendParams))) {
            params = InitParamsSerivce.getInitParams(type).setSelfParam(cache, type, orgId, startData, endData);
            String originaltype = cache.get("originaltype");
            params.put("originaltype", originaltype == null ? "" : originaltype);
            CacheUtils.getInstance().setParamsValue(cache, orgId, startData, endData, type, params);
            CacheUtils.getInstance().setDataResult(cache, null);
            String id = DBServiceHelper.genLongIds((String)"tcvat_nsrxx", (int)1)[0] + "";
            logger.info("\u5f00\u59cb\u8ba1\u7b97--\u7b2c\u4e00\u6b21\u751f\u6210\u6570\u636e\u65f6\u95f4:" + (System.currentTimeMillis() - time));
            map = FormulaService.initCalSave(cache, true, id, type, orgId, startData, endData, extendParams);
            logger.info("\u5f00\u59cb\u8ba1\u7b97--\u7b2c\u4e00\u6b21\u751f\u6210\u6570\u636e\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        } else {
            String id = dyo.getString("id");
            if (isUpdate) {
                params = InitParamsSerivce.getInitParams(type).setSelfParam(cache, type, orgId, startData, endData);
                String originaltype = cache.get("originaltype");
                params.put("originaltype", originaltype == null ? "" : originaltype);
                CacheUtils.getInstance().setParamsValue(cache, orgId, startData, endData, type, params);
                CacheUtils.getInstance().setDataResult(cache, null);
                YbnsrService.deleteYbnsrTable(type, id, orgId, extendParams);
                logger.info("\u5f00\u59cb\u8ba1\u7b97--\u66f4\u65b0\u6570\u636e\u65f6\u95f4:" + (System.currentTimeMillis() - time));
                map = FormulaService.initCalSave(cache, false, id, type, orgId, startData, endData, extendParams);
                logger.info("\u5f00\u59cb\u8ba1\u7b97--\u66f4\u65b0\u6570\u636e\u65f6\u95f4:" + (System.currentTimeMillis() - time));
            } else {
                CacheUtils.getInstance().setParamsValue(cache, orgId, startData, endData, type, null);
                map = YbnsrService.queryYbnsrTable(type, id, orgId, extendParams);
                logger.info("\u67e5\u8be2\u6570\u636e\u65f6\u95f4:" + (System.currentTimeMillis() - time));
            }
        }
        Map<String, String> maps = MapToTableUtils.tableToMap(map, type);
        CacheUtils.getInstance().setDataAndOrginalResult(cache, maps);
        logger.info("\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return maps;
    }

    private static Map<String, Object> getExtendParamsByType(String type, IPageCache cache) {
        HashMap<String, Object> extendParams = new HashMap<String, Object>();
        if ("fcscztdsys".equals(type)) {
            if (FormulaService.isImport(cache)) {
                extendParams.put(TCRETTYPE, "fcscztdsys");
            } else {
                extendParams.put(APANAGE, cache.get(APANAGE));
                extendParams.put(TCRETTYPE, cache.get(TCRETTYPE));
            }
        }
        if ("zzsyjskb".equals(type)) {
            if (cache.get(APANAGE) == null || cache.get("declareserialno") == null || cache.get(SBLX) == null) {
                DynamicObject nxx = BusinessDataServiceHelper.loadSingle((Object)cache.get("sbbid"), (String)"tcvat_nsrxx");
                cache.put(APANAGE, nxx.getString(APANAGE));
                cache.put("declareserialno", nxx.getString(SERIALNO));
                cache.put(SBLX, nxx.getString(SBLX));
            }
            extendParams.put(APANAGE, cache.get(APANAGE));
            extendParams.put(SERIALNO, cache.get("declareserialno"));
            extendParams.put(SBLX, cache.get(SBLX));
        }
        if ("qhjtbs".equals(type) && StringUtils.equals((CharSequence)"3", (CharSequence)cache.get("submittedType"))) {
            extendParams.put("groupid", cache.get("groupid"));
        }
        return extendParams;
    }

    private static boolean isImport(IPageCache cache) {
        return null == cache.get(TAX_LIMIT) && null == cache.get(APANAGE) && null == cache.get(TCRETTYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, DynamicObjectCollection> initCalSave(IPageCache cache, boolean isCreate, String id, String type, String orgId, String startData, String endData, Map<String, Object> extendParams) {
        long time = System.currentTimeMillis();
        Map<String, String> mainInfoMap = YbnsrService.createYbnsr(id, cache.get("billno"), type, orgId, startData, endData, isCreate, extendParams, null);
        Object collectionMap = new HashedMap(16);
        DistributeSessionlessCache disCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        if (StringUtil.isBlank((CharSequence)((CharSequence)disCache.get(FormulaService.getCacheKey(orgId, type, startData, endData))))) {
            logger.info("========================initCalSave=======,cacheKey=" + FormulaService.getCacheKey(orgId, type, startData, endData));
            disCache.put(FormulaService.getCacheKey(orgId, type, startData, endData), (Object)"1", 90, TimeUnit.SECONDS);
            try {
                if (FormulaService.checkGroupSubmmitted(type, extendParams)) {
                    collectionMap = FormulaContentService.initSyncTask(orgId, extendParams, mainInfoMap);
                } else {
                    logger.info("\u5f00\u59cb\u8ba1\u7b97----" + (System.currentTimeMillis() - time));
                    FormulaContentService.initCal(cache, mainInfoMap);
                    FormulaService.addDefaultData(mainInfoMap, type);
                    logger.info("\u7ed3\u675f\u8ba1\u7b97----" + (System.currentTimeMillis() - time));
                    collectionMap = FormulaContentService.saveData(mainInfoMap);
                    logger.info("\u7ed3\u675f\u4fdd\u5b58----" + (System.currentTimeMillis() - time));
                }
            }
            catch (Exception e) {
                logger.error("\u521b\u5efa\u7533\u62a5\u6570\u636e\u5f02\u5e38", (Throwable)e);
            }
            finally {
                logger.info("========================initCalSave=======,remove cacheKey=" + FormulaService.getCacheKey(orgId, type, startData, endData));
                disCache.remove(FormulaService.getCacheKey(orgId, type, startData, endData));
            }
        }
        return collectionMap;
    }

    private static boolean checkGroupSubmmitted(String type, Map<String, Object> extendParams) {
        return StringUtils.equals((CharSequence)"qhjtbs", (CharSequence)type) && EmptyCheckUtils.isNotEmpty(extendParams) && StringUtils.isNotBlank((Object)extendParams.get("groupid"));
    }

    private static void addDefaultData(Map<String, String> data, String type) {
        Map<String, EntityField> entityFieldMap = TemplateUtilsOld.getAllEntityByType(type, "#");
        entityFieldMap.entrySet().stream().forEach(v -> {
            String key = (String)v.getKey();
            EntityField fieldType = (EntityField)v.getValue();
            if (!(!"Decimal".equals(fieldType.getFieldType()) || data.containsKey(key) || key.contains("#") && NO_DEFAULT_VALUE_TABLES.contains(key.split("#")[0]))) {
                data.put(key, TemplateUtilsOld.dataFormatPreSave("0", fieldType));
            }
        });
    }

    private static String getCacheKey(String orgId, String type, String startData, String endData) {
        return String.format("tax_%s_%s_%s_%s", orgId, type, startData, endData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> cal(IPageCache cache, String key, String value) {
        long time = System.currentTimeMillis();
        logger.info("\u7f13\u5b58\u4e2d\u53d6\u6570\u636e\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        Map<String, String> map = null;
        DLock lock = DLock.create((String)cache.getPageId());
        lock.lock();
        try {
            map = FormulaContentService.cal(cache, key, value);
        }
        finally {
            lock.unlock();
        }
        logger.info("\u7ea7\u8054\u8ba1\u7b97\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return map;
    }

    public static void cancel(IPageCache cache) {
        Map<String, String> data = CacheUtils.getInstance().getOrginalDataResult(cache);
        CacheUtils.getInstance().setDataResult(cache, data);
    }

    public static void save(IPageCache cache) {
        DLock lock = DLock.create((String)cache.getPageId());
        lock.lock();
        try {
            FormulaContentService.saveData(cache);
        }
        finally {
            lock.unlock();
        }
    }

    public static Map<String, String> queryFormulaTemplate(String templateId) {
        return CacheFormulaService.getFormulaTemplate(templateId);
    }

    public static Map<String, FormulaVo> queryCellConfig(String type, String startData, String endData, String templateid) {
        return CacheFormulaService.queryCellConfig(type, startData, endData, templateid);
    }

    public static List<Map<String, String>> checkFormula(IPageCache cache) {
        long time = System.currentTimeMillis();
        List<Map<String, String>> list = FormulaContentService.checkFormula(cache, true);
        logger.info("\u98ce\u9669\u8ba1\u7b97\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return list;
    }
}

