/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.biz.impl;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.table.QysdsnbdgService;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.formula.biz.InitParams;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tccit.common.ApitudeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TccitInitParams
extends InitParams {
    private static final String SBBID = "sbbid";
    private static final String YEARSBBID = "yearsbbid";
    private static final String DECLAREYEAR = "declareyear";
    private static final String DRAFTSBBID = "draftsbbid";
    private static final String LASTYEAR_STARTDATE = "lastYearStartDate";
    private static final String LASTYEAR_ENDDATE = "lastYearEndDate";
    private static final String ISSUEDATE_1 = "issuedate_1";
    private static final String ISSUEDATE_2 = "issuedate_2";
    private static final String CERTIFICATENO_1 = "certificateno_1";
    private static final String CERTIFICATENO_2 = "certificateno_2";
    private static final String IS_BUY_DG_SERVICE = "isbuydgservice";
    private static final String REG_TYPE_GROUP = "reg_type_group";
    private static final String IS_JR_COMPANY = "isjrcompany";
    private static final String PREYEARSBBID = "preyearsbbid";
    private static final String[] deleteKey = new String[]{"sbbid", "yearsbbid", "declareyear", "draftsbbid", "issuedate_1", "issuedate_2", "certificateno_1", "certificateno_2", "lastYearStartDate", "lastYearEndDate", "isbuydgservice", "reg_type_group", "isjrcompany"};
    private static final String XEDK_NUMBER = "6635";

    @Override
    public void deleteSelfCache(IPageCache cache) {
        for (String key : deleteKey) {
            cache.remove(key);
        }
    }

    @Override
    public Map<String, String> setBizParam(IPageCache cache, String type, String orgId, String startData, String endData) {
        HashMap<String, String> param = new HashMap<String, String>(16);
        int declareyear = DateUtils.getYearOfDate(DateUtils.stringToDate(startData));
        String sbbid = cache.get(SBBID);
        if (StringUtil.isBlank((CharSequence)sbbid) || "null".equals(sbbid)) {
            sbbid = YbnsrService.queryYbnsrPre(orgId, type, startData, endData, -12);
            sbbid = StringUtil.isBlank((CharSequence)sbbid) ? "0" : sbbid;
            cache.put(SBBID, sbbid);
        }
        param.put(SBBID, sbbid);
        String declareid = cache.get("declareid");
        if (null == declareid) {
            param.put("declareid", QysdsnbdgService.queryId(orgId, startData, endData));
        }
        param.put(DECLAREYEAR, String.valueOf(declareyear));
        String draftsbbid = cache.get(DRAFTSBBID);
        if (StringUtil.isEmpty((CharSequence)draftsbbid)) {
            DynamicObject dynamicObject = YbnsrService.queryYbnsr(orgId, "qysdsnb_dg", startData, endData, null);
            draftsbbid = dynamicObject == null ? "0" : dynamicObject.getString("id");
            cache.put(DRAFTSBBID, sbbid);
        }
        param.put(DRAFTSBBID, draftsbbid);
        param.put("xedk", this.xedk(orgId) ? "1" : "0");
        param.put(LASTYEAR_STARTDATE, DateUtils.format(DateUtils.addYear(DateUtils.stringToDate(startData), -1)));
        param.put(LASTYEAR_ENDDATE, DateUtils.format(DateUtils.addYear(DateUtils.stringToDate(endData), -1)));
        param.put(IS_BUY_DG_SERVICE, this.getIsBuyDgService(Long.valueOf(orgId), DateUtils.stringToDate(startData), DateUtils.stringToDate(endData)));
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData();
        param.put(REG_TYPE_GROUP, this.getRegisterType(taxMain));
        param.put(IS_JR_COMPANY, this.getIndustryCodeAndName(taxMain));
        Map<String, String> certificateNoAndDate = this.getCertificateNoAndDate(orgId);
        param.put(ISSUEDATE_1, certificateNoAndDate.getOrDefault(ISSUEDATE_1, ""));
        param.put(ISSUEDATE_2, certificateNoAndDate.getOrDefault(ISSUEDATE_2, ""));
        param.put(CERTIFICATENO_1, certificateNoAndDate.getOrDefault(CERTIFICATENO_1, ""));
        param.put(CERTIFICATENO_2, certificateNoAndDate.getOrDefault(CERTIFICATENO_2, ""));
        HashMap<String, Object> extendParams = new HashMap<String, Object>();
        extendParams.put("declarestatus", "declared");
        String preStartData = DateUtils.format(DateUtils.getFirstDateOfYear(DateUtils.addYear(DateUtils.stringToDate(startData), -1)));
        String preEndData = DateUtils.format(DateUtils.getLastDateOfYear(DateUtils.addYear(DateUtils.stringToDate(endData), -1)));
        DynamicObject preYear = YbnsrService.queryYbnsr(orgId, "qysdsnb", preStartData, preEndData, 0, extendParams);
        param.put(PREYEARSBBID, preYear != null ? preYear.getString("id") : "");
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        QFilter startFilter = new QFilter("startdate", ">=", (Object)DateUtils.stringToDate(startData));
        QFilter endFilter = new QFilter("startdate", "<=", (Object)DateUtils.stringToDate(endData));
        Map<String, String> map = this.getMap(orgFilter, startFilter, endFilter);
        for (int i = 1; i <= 10; ++i) {
            String value = map.get(String.valueOf(i));
            if (StringUtil.isNotBlank((CharSequence)value)) {
                param.put("guoji_" + i, value);
                continue;
            }
            param.put("guoji_" + i, "");
        }
        return param;
    }

    private String getIndustryCodeAndName(DynamicObject taxMain) {
        String jrNumber = String.valueOf(this.getNumberByName(taxMain, "codeandname.id"));
        if (jrNumber.startsWith("66") || jrNumber.startsWith("67") || jrNumber.startsWith("68") || jrNumber.startsWith("69")) {
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    private String getRegisterType(DynamicObject taxMain) {
        String result = "";
        int regNumber = this.getNumberByName(taxMain, "registertype.id");
        if (400 <= regNumber && regNumber <= 433) {
            result = "gtjy";
        } else if (500 <= regNumber && regNumber <= 560) {
            if (regNumber == 510) {
                result = "sydw";
            } else if (regNumber == 530 || regNumber == 540) {
                result = "gjjg";
            } else if (Lists.newArrayList((Object[])new Integer[]{520, 521, 522, 523, 550, 560}).contains(regNumber)) {
                result = "mbfqydw";
            }
        } else {
            result = "bsfqydw";
        }
        return result;
    }

    private int getNumberByName(DynamicObject taxMain, String column) {
        int number = 0;
        if (taxMain == null) {
            return number;
        }
        try {
            number = taxMain.getInt(column);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return number;
    }

    private String getIsBuyDgService(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_dg_a100000_1_sum", (String)"id", (QFilter[])new QFilter[]{orgFilter, dateFilter});
        if (CollectionUtils.isEmpty((Collection)query)) {
            return Boolean.FALSE.toString();
        }
        return Boolean.TRUE.toString();
    }

    public Map<String, String> getMap(QFilter orgFilter, QFilter startFilter, QFilter endFilter) {
        DynamicObject[] ids;
        DynamicObjectCollection gdentryentity;
        Map<String, String> map = new HashMap<String, String>();
        DynamicObject dynamicObjects = QueryServiceHelper.queryOne((String)"tccit_policy_confirm", (String)"id", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
        MainEntityType policyConfirm = EntityMetadataCache.getDataEntityType((String)"tccit_policy_confirm");
        if (dynamicObjects != null && !CollectionUtils.isEmpty((Collection)(gdentryentity = (ids = BusinessDataServiceHelper.load((Object[])new Long[]{dynamicObjects.getLong("id")}, (DynamicObjectType)policyConfirm))[0].getDynamicObjectCollection("gdentryentity")))) {
            map = gdentryentity.stream().filter(s -> s.getDynamicObject("nationality") != null).collect(Collectors.toMap(s -> s.getString("seq"), s -> s.getDynamicObject("nationality").getString("name")));
        }
        return map;
    }

    private boolean xedk(String orgId) {
        boolean xedk = false;
        DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData();
        if (taxMain != null) {
            xedk = StringUtil.equals((CharSequence)taxMain.getString("codeandname.number"), (CharSequence)XEDK_NUMBER);
        }
        return xedk;
    }

    private Map<String, String> getCertificateNoAndDate(String orgId) {
        HashMap<String, String> map = new HashMap<String, String>();
        DynamicObjectCollection apitudeentryentity = ApitudeUtils.getApitudeEntryEntity(Long.valueOf(orgId));
        if (CollectionUtils.isEmpty((Collection)apitudeentryentity)) {
            return map;
        }
        List collect = apitudeentryentity.stream().filter(s -> {
            DynamicObject companytype = s.getDynamicObject("companytype");
            return companytype != null && companytype.getString("number").equals("HT001");
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return map;
        }
        collect.sort((o1, o2) -> {
            if (o1.getDate("issuedate") == null) {
                return -1;
            }
            if (o2.getDate("issuedate") == null) {
                return 1;
            }
            return o1.getDate("issuedate").compareTo(o2.getDate("issuedate"));
        });
        if (collect.size() == 1) {
            DynamicObject dynamicObject = (DynamicObject)collect.get(0);
            map.put(ISSUEDATE_1, DateUtils.format(dynamicObject.getDate("issuedate")));
            map.put(CERTIFICATENO_1, dynamicObject.getString("certificateno"));
        } else if (collect.size() > 1) {
            DynamicObject dynamicObject = (DynamicObject)collect.get(0);
            map.put(ISSUEDATE_1, DateUtils.format(dynamicObject.getDate("issuedate")));
            map.put(CERTIFICATENO_1, dynamicObject.getString("certificateno"));
            DynamicObject dynamicObject2 = (DynamicObject)collect.get(1);
            map.put(ISSUEDATE_2, DateUtils.format(dynamicObject2.getDate("issuedate")));
            map.put(CERTIFICATENO_2, dynamicObject2.getString("certificateno"));
        }
        return map;
    }
}

