/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.biz.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IPageCache;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.formula.biz.InitParams;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TcctInitParams
extends InitParams {
    private static final String SBBID = "sbbid";
    private static final String LASTSBBID = "lastsbbid";
    private static final String[] deleteKey = new String[]{"sbbid", "lastsbbid"};

    @Override
    public void deleteSelfCache(IPageCache cache) {
        for (String key : deleteKey) {
            cache.remove(key);
        }
    }

    @Override
    public Map<String, String> setBizParam(IPageCache cache, String type, String orgId, String startDate, String endDate) {
        HashMap<String, String> param = new HashMap<String, String>();
        String yearsbbid = cache.get(LASTSBBID);
        if (StringUtil.isBlank((CharSequence)yearsbbid)) {
            String taxLimit;
            Date start = DateUtils.stringToDate(startDate);
            Date end = DateUtils.stringToDate(endDate);
            switch (taxLimit = DateUtils.getTaxLimit(start, end)) {
                case "season": {
                    start = DateUtils.addMonth(start, -3);
                    end = DateUtils.addMonth(end, -3);
                    break;
                }
                case "month": {
                    start = DateUtils.addMonth(start, -1);
                    end = DateUtils.addMonth(end, -1);
                }
            }
            end = DateUtils.getLastDateOfMonth(end);
            DynamicObject dynamicObject = YbnsrService.queryYbnsr(orgId, type, DateUtils.format(start), DateUtils.format(end), null);
            if (dynamicObject != null) {
                yearsbbid = dynamicObject.getString("id");
                cache.put(LASTSBBID, yearsbbid);
            }
        }
        param.put(LASTSBBID, yearsbbid);
        return param;
    }
}

