/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.biz.impl;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.formula.biz.InitParams;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class TcretCcxwsInitParams
extends InitParams {
    private static final String TCRET_YHS_TAX_SOURCE_INFO = "tcret_yhs_tax_source_info";
    private static final String FCS_HIRE = "tcret_pbt_fcs_hire_sum";
    private static final String FCS_PRICE = "tcret_pbt_fcs_price_sum";
    private static final String FCS_TDS = "tcret_pbt_tds_sum";
    private static final String TAXLIMIT = "taxlimit";
    private static final String DECLARE_MONTH = "declaremonth";
    private static final String MAIN_DATA_ID = "maindataid";
    private static final String[] deleteKey = new String[]{"taxlimit", "declaremonth", "maindataid"};

    @Override
    public void deleteSelfCache(IPageCache cache) {
        for (String key : deleteKey) {
            cache.remove(key);
        }
    }

    @Override
    public Map<String, String> setBizParam(IPageCache cache, String type, String orgId, String startData, String endData) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("isXgm", this.getPolicy(cache.get("orgid"), cache.get(DECLARE_MONTH)));
        this.getMinPeriod(cache.get(MAIN_DATA_ID), param, cache.get(DECLARE_MONTH));
        this.getYhsjz(cache.get(DECLARE_MONTH), param);
        param.put(TAXLIMIT, cache.get(TAXLIMIT));
        param.put(DECLARE_MONTH, cache.get(DECLARE_MONTH));
        return param;
    }

    private String getPolicy(String orgid, String declareMonth) {
        String taxPayerType;
        DynamicObject category = TaxBaseDataUtils.queryCategoryByTaxtype(Long.parseLong(orgid), "zzs");
        DynamicObject changeRecord = OrgChangeRecordUtil.loadChangeRecord(orgid, DateUtils.stringToDate(declareMonth), DateUtils.stringToDate(declareMonth));
        String string = taxPayerType = category != null ? category.getString("taxpayertype") : "";
        if (null != changeRecord) {
            taxPayerType = changeRecord.getString("taxpayertype");
        }
        return "xgmnsr".equals(taxPayerType) ? "1" : "0";
    }

    private void getMinPeriod(String mainDataId, Map<String, String> param, String declareMonth) {
        QFilter declareid = new QFilter("declareid", "=", (Object)Long.parseLong(mainDataId));
        QFilter maindataid = new QFilter(MAIN_DATA_ID, "=", (Object)Long.parseLong(mainDataId));
        DynamicObjectCollection objects = QueryServiceHelper.query((String)TCRET_YHS_TAX_SOURCE_INFO, (String)"skssqq,skssqz", (QFilter[])new QFilter[]{declareid});
        List skssqqList = objects.stream().map(o -> o.getDate("skssqq")).collect(Collectors.toList());
        List skssqzList = objects.stream().map(o -> o.getDate("skssqz")).collect(Collectors.toList());
        DynamicObjectCollection fcshire = QueryServiceHelper.query((String)FCS_HIRE, (String)"skssqq,skssqz", (QFilter[])new QFilter[]{maindataid});
        skssqqList.addAll(fcshire.stream().map(o -> o.getDate("skssqq")).collect(Collectors.toList()));
        skssqzList.addAll(fcshire.stream().map(o -> o.getDate("skssqz")).collect(Collectors.toList()));
        DynamicObjectCollection fcsprice = QueryServiceHelper.query((String)FCS_PRICE, (String)"skssqq,skssqz", (QFilter[])new QFilter[]{maindataid});
        skssqqList.addAll(fcsprice.stream().map(o -> o.getDate("skssqq")).collect(Collectors.toList()));
        skssqzList.addAll(fcsprice.stream().map(o -> o.getDate("skssqz")).collect(Collectors.toList()));
        DynamicObjectCollection fcstds = QueryServiceHelper.query((String)FCS_TDS, (String)"skssqq,skssqz", (QFilter[])new QFilter[]{maindataid});
        skssqqList.addAll(fcstds.stream().map(o -> o.getDate("skssqq")).collect(Collectors.toList()));
        skssqzList.addAll(fcstds.stream().map(o -> o.getDate("skssqz")).collect(Collectors.toList()));
        String maxdate = skssqzList.size() > 0 ? DateUtils.formatMonth((Date)Collections.max(skssqzList)) : declareMonth;
        String minDate = skssqqList.size() > 0 ? DateUtils.formatMonth((Date)Collections.min(skssqqList)) : declareMonth;
        String maxyear = "";
        String maxmonth = "";
        String minyear = "";
        String minmonth = "";
        if (StringUtil.isNotEmpty((CharSequence)maxdate)) {
            maxyear = maxdate.substring(0, 4);
            maxmonth = maxdate.substring(5, 7);
        }
        if (StringUtil.isNotEmpty((CharSequence)minDate)) {
            minyear = minDate.substring(0, 4);
            minmonth = minDate.substring(5, 7);
        }
        param.put("maxyear", maxyear);
        param.put("maxmonth", maxmonth);
        param.put("minyear", minyear);
        param.put("minmonth", minmonth);
    }

    private void getYhsjz(String declareMonth, Map<String, String> param) {
        if (StringUtils.isNotEmpty((CharSequence)declareMonth)) {
            QFilter qFilter = new QFilter("number", "in", (Object)"YHSJZ").and(new QFilter("entryentity.startdate", "<=", (Object)DateUtils.stringToDate(declareMonth, "yyyy-MM-dd"))).and(new QFilter("entryentity.enddate", ">=", (Object)DateUtils.stringToDate(declareMonth, "yyyy-MM-dd")));
            DynamicObject assistObj = QueryServiceHelper.queryOne((String)"tpo_tcvat_assist", (String)"entryentity.fvalue1", (QFilter[])new QFilter[]{qFilter});
            if (assistObj != null) {
                param.put("yhsjz", assistObj.getString("entryentity.fvalue1"));
            }
        }
    }
}

