/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.biz.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IPageCache;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.formula.biz.InitParams;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TcvatCurrentInitParams
extends InitParams {
    private static final String SBBID = "sbbid";
    private static final String YEARSBBID = "yearsbbid";
    public static final String STARTPERIOD = "strStartPeriod";
    public static final String ENDPERIOD = "strEndPeriod";
    public static final String START = "start";
    public static final String END = "end";
    public static final String MIDDLEPERIOD = "strMiddlePeriod";
    private static final String XGM_TAX_RATE_YEAR = "xgmyear";
    private static final String XGM_TAX_RATE_MONTH = "xgmmonth";
    private static final String REGISTERTYPE = "registertype";
    private static final String DEADLINE = "deadline";
    private static final String TYPE = "type";
    private static final String cswhjssenable = "cswhjssenable";
    private static final String jyffjenable = "jyffjenable";
    private static final String dfjyffjenable = "dfjyffjenable";
    public static final String ENABLE = "1";
    public static final String DISABLE = "0";
    public static final String MONTH = "month";
    private static final String[] deleteKey = new String[]{"yearsbbid", "xgmyear", "xgmmonth", "type", "registertype", "deadline"};

    @Override
    public void deleteSelfCache(IPageCache cache) {
        for (String key : deleteKey) {
            cache.remove(key);
        }
    }

    @Override
    public Map<String, String> setBizParam(IPageCache cache, String type, String orgId, String startData, String endData) {
        HashMap<String, String> param = new HashMap<String, String>(16);
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.stringToDate(endData, "yyyy-MM"));
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        param.put(XGM_TAX_RATE_YEAR, String.valueOf(year));
        param.put(XGM_TAX_RATE_MONTH, String.valueOf(month));
        param.put(STARTPERIOD, startData.substring(0, 7));
        Date middleDate = DateUtils.stringToDate(startData);
        middleDate = DateUtils.addMonth(middleDate, 1);
        param.put(MIDDLEPERIOD, DateUtils.formatMonth(middleDate));
        param.put(ENDPERIOD, endData.substring(0, 7));
        param.put(START, startData);
        param.put(END, endData);
        param.put(REGISTERTYPE, cache.get("registerType"));
        param.put(DEADLINE, "aysb");
        param.put(TYPE, DISABLE);
        int startMonth = DateUtils.getMonthOfDate(DateUtils.stringToDate(startData));
        int endMonth = DateUtils.getMonthOfDate(DateUtils.stringToDate(endData));
        int offSet = -1;
        if (endMonth - startMonth == 2) {
            offSet = -3;
            param.put(TYPE, ENABLE);
            param.put(DEADLINE, "ajsb");
        }
        String sbbid = YbnsrService.queryYbnsrPre(orgId, type, startData, endData, offSet);
        String yearsbbid = cache.get(YEARSBBID);
        if (null == yearsbbid) {
            yearsbbid = YbnsrService.queryYbnsrPreYear(orgId, type, startData, endData);
            cache.put(YEARSBBID, yearsbbid);
        }
        param.put(SBBID, sbbid);
        param.put(YEARSBBID, yearsbbid);
        param.put("prestartDate", DateUtils.format(DateUtils.addMonth(DateUtils.stringToDate(startData), offSet)));
        param.put("preendDate", DateUtils.format(DateUtils.getLastDateOfMonth(DateUtils.addMonth(DateUtils.stringToDate(endData), offSet))));
        param.put(MONTH, String.valueOf(startMonth));
        param.put("endMonth", String.valueOf(endMonth));
        DynamicObject category = TaxBaseDataUtils.queryCategoryByTaxtype(Long.parseLong(orgId), "fjsf");
        if (category != null) {
            param.put(cswhjssenable, ENABLE.equals(category.getString(cswhjssenable)) ? ENABLE : DISABLE);
            param.put(jyffjenable, "2".equals(category.getString(jyffjenable)) ? ENABLE : DISABLE);
            param.put(dfjyffjenable, "3".equals(category.getString(dfjyffjenable)) ? ENABLE : DISABLE);
        }
        return param;
    }

    public static String getXgmTaxRateYear() {
        return XGM_TAX_RATE_YEAR;
    }

    public static String getXgmTaxRateMonth() {
        return XGM_TAX_RATE_MONTH;
    }

    public static String getREGISTERTYPE() {
        return REGISTERTYPE;
    }
}

