/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.biz.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IPageCache;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.formula.biz.InitParams;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TcvatFjsfInitParams
extends InitParams {
    private static final String TYPE = "type";
    private static final String SBBID = "sbbid";
    private static final String YEARSBBID = "yearsbbid";
    private static final String CURRENTSBBID = "currentsbbid";
    private static final String YLSC_SBBID = "ylscsbbid";
    private static final String YLPF_SBBID = "ylpfsbbid";
    private static final String cswhjssenable = "cswhjssenable";
    private static final String jyffjenable = "jyffjenable";
    private static final String dfjyffjenable = "dfjyffjenable";
    private static final String[] deleteKey = new String[]{"type", "sbbid", "yearsbbid", "currentsbbid"};
    private static final ArrayList<Integer> lastMonthOfSeason = Lists.newArrayList((Object[])new Integer[]{3, 6, 9, 12});
    public static final String ENABLE = "1";
    public static final String DISABLE = "0";

    @Override
    public void deleteSelfCache(IPageCache cache) {
        for (String key : deleteKey) {
            cache.remove(key);
        }
    }

    @Override
    public Map<String, String> setBizParam(IPageCache cache, String type, String orgId, String startData, String endData) {
        String currentSbbid;
        String yearsbbid;
        HashMap<String, String> param = new HashMap<String, String>();
        String sbbid = cache.get(SBBID);
        if (null == sbbid) {
            sbbid = YbnsrService.queryYbnsrPre(orgId, type, startData, endData);
            cache.put(SBBID, sbbid);
        }
        if (null == (yearsbbid = cache.get(YEARSBBID))) {
            yearsbbid = YbnsrService.queryYbnsrPreYear(orgId, type, startData, endData);
            cache.put(YEARSBBID, yearsbbid);
        }
        if (null == (currentSbbid = cache.get(CURRENTSBBID))) {
            DynamicObject dyo;
            type = "zzs" + cache.get("taxPayerType");
            if ("xgmnsr".equals(cache.get("taxPayerType")) && "ajsb".equals(cache.get("deadline"))) {
                type = type + "jidu";
            }
            if (null != (dyo = YbnsrService.queryYbnsr(orgId, type, startData, endData, null))) {
                currentSbbid = dyo.getString("id");
            }
            cache.put(CURRENTSBBID, currentSbbid);
        }
        param.put(CURRENTSBBID, currentSbbid);
        param.put(SBBID, sbbid);
        param.put(YEARSBBID, yearsbbid);
        int offSet = -1;
        if ("ajsb".equals(cache.get("deadline"))) {
            offSet = -3;
        }
        param.put("prestartDate", DateUtils.format(DateUtils.addMonth(DateUtils.stringToDate(startData), offSet)));
        param.put("preendDate", DateUtils.format(DateUtils.getLastDateOfMonth(DateUtils.addMonth(DateUtils.stringToDate(endData), offSet))));
        param.put(TYPE, ObjectUtils.notEqual((Object)cache.get("taxPayerType"), (Object)"xgmnsr") ? DISABLE : ENABLE);
        Date start = DateUtils.stringToDate(startData);
        Date end = DateUtils.stringToDate(endData);
        String taxLimit = DateUtils.getTaxLimit(start, end);
        if ("season".equals(taxLimit)) {
            DynamicObject object1;
            DynamicObject object = YbnsrService.queryYbnsr(orgId, "xfs", startData, endData, null);
            if (object != null) {
                param.put(YLSC_SBBID, object.getString("id"));
            }
            if ((object1 = YbnsrService.queryYbnsr(orgId, "xfsjypf", startData, endData, null)) != null) {
                param.put(YLPF_SBBID, object1.getString("id"));
            }
        } else if ("month".equals(taxLimit)) {
            String xfsSCsbbid = this.getMainTaxMonthsbbid(orgId, "xfs", startData, endData);
            param.put(YLSC_SBBID, xfsSCsbbid);
            String xfsPFsbbid = this.getMainTaxMonthsbbid(orgId, "xfsjypf", startData, endData);
            param.put(YLPF_SBBID, xfsPFsbbid);
            String zzsCurrentSbbid = this.getMainTaxMonthsbbid(orgId, type, startData, endData);
            if (StringUtil.isNotEmpty((CharSequence)zzsCurrentSbbid)) {
                param.put(CURRENTSBBID, zzsCurrentSbbid);
            }
        }
        DynamicObject category = TaxBaseDataUtils.queryCategoryByTaxtype(Long.parseLong(orgId), "fjsf");
        if (category != null) {
            param.put(cswhjssenable, ENABLE.equals(category.getString(cswhjssenable)) ? ENABLE : DISABLE);
            param.put(jyffjenable, "2".equals(category.getString(jyffjenable)) ? ENABLE : DISABLE);
            param.put(dfjyffjenable, "3".equals(category.getString(dfjyffjenable)) ? ENABLE : DISABLE);
        }
        return param;
    }

    private String getMainTaxMonthsbbid(String orgId, String xfstype, String startData, String endData) {
        Date end = DateUtils.stringToDate(endData);
        DynamicObject xfsMonth = YbnsrService.queryYbnsr(orgId, xfstype, startData, endData, null);
        int monthOfDate = DateUtils.getMonthOfDate(end);
        if (xfsMonth != null) {
            return xfsMonth.getString("id");
        }
        if (lastMonthOfSeason.contains(monthOfDate)) {
            Date firstDateOfSeason = DateUtils.getFirstDateOfSeason(end);
            Date lastDateOfSeason = DateUtils.getLastDateOfSeason(end);
            DynamicObject xfsSeason = YbnsrService.queryYbnsr(orgId, xfstype, DateUtils.format(firstDateOfSeason), DateUtils.format(lastDateOfSeason), null);
            if (xfsSeason != null) {
                return xfsSeason.getString("id");
            }
        }
        return null;
    }

    public static String typeKey() {
        return TYPE;
    }
}

