/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.biz.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.formula.biz.InitParams;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.enums.DraftTypeEnum;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TcvatInitParams
extends InitParams {
    private static final String SBBID = "sbbid";
    private static final String YEARSBBID = "lastyearsbbid";
    private static final String cswhjssenable = "cswhjssenable";
    private static final String jyffjenable = "jyffjenable";
    private static final String dfjyffjenable = "dfjyffjenable";
    private static final String[] deleteKey = new String[]{"sbbid", "lastyearsbbid"};
    public static final String ENABLE = "1";
    public static final String DISABLE = "0";
    public static final String MONTH = "month";
    private static final String ZERO_VALUE = "0";
    private static final String YBHZ = "ybhz";
    private static final String TAXRATE = "taxrate";
    private static final String DEADLINE = "deadline";
    private static final String TYPE = "type";
    public static final String STARTPERIOD = "startPeriod";
    public static final String MIDDLEPERIOD = "middlePeriod";
    public static final String ENDPERIOD = "endPeriod";
    public static final String STARTPERIOD1 = "sPeriod";
    public static final String MIDDLEPERIOD1 = "mPeriod";
    public static final String ENDPERIOD1 = "ePeriod";
    public static final String FIRSTMONSEA = "firstmonsea";
    private static final String TCVAT_DIFFDEDUCT_TEMP = "tcvat_diffdeduct_temp";
    private static final String TCVAT_DIFFDEDUCT_SJJT = "tcvat_diffdeduct_sjjt";
    private static final String[] TYPE_ARY = new String[]{"mdt", "md", "jzjtsjtse"};
    private static Map<String, String> collectionMap = new HashMap<String, String>(4){
        {
            this.put("cityarea", ResManager.loadKDString((String)"\u5e02\u533a\uff08\u589e\u503c\u7a0e\u9644\u5f81\uff09", (String)"TcvatInitParams_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.put("nocityarea", ResManager.loadKDString((String)"\u53bf\u57ce\u3001\u9547\uff08\u589e\u503c\u7a0e\u9644\u5f81\uff09", (String)"TcvatInitParams_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.put("otherarea", ResManager.loadKDString((String)"\u5176\u4ed6\uff08\u589e\u503c\u7a0e\u9644\u5f81\uff09", (String)"TcvatInitParams_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    };

    @Override
    public void deleteSelfCache(IPageCache cache) {
        for (String key : deleteKey) {
            cache.remove(key);
        }
    }

    @Override
    public Map<String, String> setBizParam(IPageCache cache, String type, String orgId, String startData, String endData) {
        HashMap<String, String> param = new HashMap<String, String>(32);
        String deadLine = "aysb";
        param.put(TYPE, "0");
        Date skssqq = DateUtils.stringToDate(startData);
        Date skssqz = DateUtils.stringToDate(endData);
        int startMonth = DateUtils.getMonthOfDate(skssqq);
        int endMonth = DateUtils.getMonthOfDate(skssqz);
        String startPeriod = startData.substring(0, 7);
        param.put(STARTPERIOD, startPeriod);
        param.put(MIDDLEPERIOD, startPeriod);
        param.put(ENDPERIOD, endData.substring(0, 7));
        param.put(STARTPERIOD1, startPeriod);
        param.put(MIDDLEPERIOD1, startPeriod);
        param.put(ENDPERIOD1, endData.substring(0, 7));
        param.put(FIRSTMONSEA, DateUtils.isFirstMonthWithinYear(skssqq) ? ENABLE : "0");
        int offSet = -1;
        if (endMonth - startMonth == 2) {
            offSet = -3;
            param.put(TYPE, ENABLE);
            deadLine = "ajsb";
            Date middleDate = DateUtils.addMonth(skssqq, 1);
            param.put(MIDDLEPERIOD, DateUtils.formatMonth(middleDate));
            param.put(MIDDLEPERIOD1, DateUtils.formatMonth(middleDate));
        }
        param.put(DEADLINE, deadLine);
        String preSbbid = cache.get(SBBID);
        if (StringUtil.isBlank((CharSequence)preSbbid)) {
            preSbbid = YbnsrService.queryYbnsrPre(orgId, type, startData, endData, offSet);
            cache.put(SBBID, preSbbid);
        }
        String predeclaresbbid = "0";
        if (Arrays.asList(DraftTypeEnum.TCVAT.getTemplates()).contains(type) || Arrays.asList(DraftTypeEnum.TCVAT_SJJT.getTemplates()).contains(type)) {
            if (StringUtil.isNotBlank((CharSequence)cache.get("taxPayerType"))) {
                predeclaresbbid = YbnsrService.queryYbnsrPre(orgId, cache.get("taxPayerType"), startData, endData, offSet);
                if ("zzsybnsr".equals(cache.get("taxPayerType")) && (ObjectUtils.isEmpty((Object)predeclaresbbid) || "0".equals(predeclaresbbid))) {
                    String t;
                    Iterator<String> iterator = Arrays.asList("zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg").iterator();
                    while (iterator.hasNext() && (!ObjectUtils.isNotEmpty((Object)(predeclaresbbid = YbnsrService.queryYbnsrPre(orgId, t = iterator.next(), startData, endData, offSet))) || "0".equals(predeclaresbbid))) {
                    }
                }
                param.put("predeclaresbbid", predeclaresbbid);
            }
            String perDeclareSbbidByCurrentDateSubtractOneMonth = YbnsrService.queryYbnsrPreByDatePoint(orgId, cache.get("taxPayerType"), startData);
            param.put("perDeclareSbbidByCurrentDateSubtractOneMonth", perDeclareSbbidByCurrentDateSubtractOneMonth);
        }
        param.put("presbbid", preSbbid);
        param.put(SBBID, preSbbid);
        param.put("currentSbbid", cache.get("cache_sbbid"));
        param.put(YEARSBBID, preSbbid);
        param.put("prestartDate", DateUtils.format(DateUtils.addMonth(skssqq, offSet)));
        param.put("preendDate", DateUtils.format(DateUtils.getLastDateOfMonth(DateUtils.getLastDateOfMonth(DateUtils.addMonth(skssqz, offSet)))));
        param.put("isHangkongOrg", this.isHangkongOrg(orgId, startData, endData) ? ENABLE : "0");
        param.put("taxpayertype", cache.get("taxPayerType"));
        param.put("templatetype", "draft_" + cache.get("taxPayerType"));
        param.put("zlbid", cache.get("zlbid"));
        param.put(MONTH, String.valueOf(DateUtils.getMonthOfDate(skssqq)));
        param.put("endMonth", String.valueOf(DateUtils.getMonthOfDate(skssqz)));
        param.put("income", "0");
        param.put("diff", "0");
        param.put("deduct", "0");
        param.put("amount", this.getAmount(orgId, startData, endData, "amount"));
        param.put("taxamount", this.getAmount(orgId, startData, endData, "taxamount"));
        param.put("ybamount", this.getYbAmount(orgId, startData, endData, "ybamount"));
        param.put("ybtaxamount", this.getYbAmount(orgId, startData, endData, "ybtaxamount"));
        String bqsfsyjzzc = this.setParam(cache, type, orgId, startData, endData, param, deadLine, skssqq, skssqz);
        DynamicObject category = TaxBaseDataUtils.queryCategoryByTaxtype(Long.parseLong(orgId), "fjsf");
        if (category != null) {
            param.put(cswhjssenable, ENABLE.equals(category.getString(cswhjssenable)) ? ENABLE : "0");
            param.put(jyffjenable, "2".equals(category.getString(jyffjenable)) ? ENABLE : "0");
            param.put(dfjyffjenable, "3".equals(category.getString(dfjyffjenable)) ? ENABLE : "0");
        }
        this.getOrgParams(orgId, startData, endData, param);
        String reliefPolicyType = TaxBaseDataUtils.getReliefPolicyType(Long.valueOf(orgId), skssqq, skssqz, false);
        if (bqsfsyjzzc == null) {
            bqsfsyjzzc = "gtgsh".equals(reliefPolicyType) ? ENABLE : "0";
        }
        param.put("reliefpolicytype", "".equals(reliefPolicyType) ? null : reliefPolicyType);
        param.put("bqsfsyjzzc", bqsfsyjzzc);
        param.put("startDate", startData);
        param.put("endDate", endData);
        String draftpurpose = cache.get("draftpurpose");
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tcvat", (String)"MdtsEngineServiceImpl", (String)"fetchMdtsYtse", (Object[])new Object[]{draftpurpose, orgId, startData, endData, TYPE_ARY});
        if (map != null) {
            param.put("mdtYtse", BigDecimalUtil.format(map.get("mdt") == null ? BigDecimal.ZERO : map.get("mdt"), "0.00#"));
            param.put("mdYtse", BigDecimalUtil.format(map.get("md") == null ? BigDecimal.ZERO : map.get("md"), "0.00#"));
            param.put("jzjtsjtse", BigDecimalUtil.format(map.get("jzjtsjtse") == null ? BigDecimal.ZERO : map.get("jzjtsjtse"), "0.00#"));
        }
        return param;
    }

    protected String setParam(IPageCache cache, String type, String orgId, String startData, String endData, Map<String, String> param, String deadLine, Date skssqq, Date skssqz) {
        QFilter orgFilter;
        String bqsfsyjzzc = null;
        String draftpurpose = cache.get("draftpurpose");
        if (StringUtils.isBlank((CharSequence)draftpurpose)) {
            draftpurpose = "nssb";
        }
        String cekcdgBqfseHj = "0";
        String cekcdgBqfseHjJzjtF = "0";
        String cekcdgBqfseHjJzjtS = "0";
        if ("zzsybnsr_ybhz".equals(type) || "draft_zzsybnsr_ybhz".equals(type)) {
            QFilter payerTypeFilter;
            QFilter skssqqzFilter;
            orgFilter = new QFilter("org", "=", (Object)Long.valueOf(orgId));
            if (QueryServiceHelper.exists((String)"tcvat_hz_account_summary", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter = new QFilter("startdate", "=", (Object)skssqq).and(new QFilter("enddate", "=", (Object)skssqz)), payerTypeFilter = new QFilter("taxpayertype", "=", (Object)cache.get("taxPayerType"))})) {
                param.put("income", ENABLE);
            }
            if (QueryServiceHelper.exists((String)"tcvat_hz_diffdeduct_temp", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter})) {
                param.put("diff", ENABLE);
            }
            if (QueryServiceHelper.exists((String)"tcvat_hz_deduction_sum", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter})) {
                param.put("deduct", ENABLE);
            }
            this.setFb5FjsfParams(orgId, startData, endData, param);
            QFilter dateFilter = new QFilter("startdate", ">=", (Object)DateUtils.getDayFirst(skssqq)).and(new QFilter("enddate", "<=", (Object)DateUtils.getDayLast(skssqz)));
            QFilter draftPurposeFilter = new QFilter("draftpurpose", "=", (Object)draftpurpose);
            DynamicObject policyConfirm = QueryServiceHelper.queryOne((String)"tcvat_ybhz_policy_confirm", (String)"bqsfsyjzzc", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgId)), dateFilter, draftPurposeFilter});
            if (policyConfirm != null) {
                bqsfsyjzzc = policyConfirm.getString("bqsfsyjzzc");
            }
            cekcdgBqfseHj = this.getCekcdgBqfseHj("tcvat_hz_diffdeduct_temp", new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
            cekcdgBqfseHjJzjtF = this.getCekcdgBqfseHjJzjtF("tcvat_hz_diffdeduct_temp", new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
            cekcdgBqfseHjJzjtS = this.getCekcdgBqfseHjJzjtS("tcvat_hz_diffdeduct_temp", new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
        }
        if ("zzsybnsr".equals(type) || "draft_zzsybnsr".equals(type)) {
            QFilter deadLineFilter;
            String startPeriod;
            QFilter taxPeriodFilter;
            orgFilter = new QFilter("org", "=", (Object)Long.valueOf(orgId));
            if (QueryServiceHelper.exists((String)"tcvat_account_summary", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter = new QFilter("taxperiod", ">=", (Object)(startPeriod = param.getOrDefault(STARTPERIOD, startData.substring(0, 7)))).and(new QFilter("taxperiod", "<=", (Object)endData.substring(0, 7))), deadLineFilter = new QFilter(DEADLINE, "=", (Object)deadLine)})) {
                param.put("income", ENABLE);
            }
            if (QueryServiceHelper.exists((String)TCVAT_DIFFDEDUCT_TEMP, (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter})) {
                param.put("diff", ENABLE);
            }
            cekcdgBqfseHj = this.getCekcdgBqfseHj(TCVAT_DIFFDEDUCT_TEMP, new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter});
            cekcdgBqfseHjJzjtF = this.getCekcdgBqfseHjJzjtF(TCVAT_DIFFDEDUCT_TEMP, new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter});
            cekcdgBqfseHjJzjtS = this.getCekcdgBqfseHjJzjtS(TCVAT_DIFFDEDUCT_TEMP, new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter});
            QFilter dateFilter = new QFilter("reportperiod", ">=", (Object)DateUtils.getDayFirst(skssqq)).and(new QFilter("reportperiod", "<=", (Object)DateUtils.getDayLast(skssqz)));
            QFilter draftPurposeFilter = new QFilter("draftpurpose", "=", (Object)draftpurpose);
            DynamicObject policyConfirm = QueryServiceHelper.queryOne((String)"tcvat_policy_confirm", (String)"bqsfsyjzzc", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgId)), dateFilter, draftPurposeFilter});
            if (policyConfirm != null) {
                bqsfsyjzzc = policyConfirm.getString("bqsfsyjzzc");
            }
        }
        param.put("cekcdgBqfseHj", cekcdgBqfseHj);
        param.put("cekcdgBqfseHjJzjtF", cekcdgBqfseHjJzjtF);
        param.put("cekcdgBqfseHjJzjtS", cekcdgBqfseHjJzjtS);
        String predeclaresbbid = param.getOrDefault("predeclaresbbid", "0");
        String sqsbbFb3Qmye = this.getYbnsrSqsbbFb3Qmye(predeclaresbbid);
        param.put("sqsbbFb3Qmye", sqsbbFb3Qmye);
        return bqsfsyjzzc;
    }

    private String getAmount(String orgId, String startData, String endData, String name) {
        DynamicObject[] load_0;
        Date sdate = DateUtils.getDayFirst(DateUtils.stringToDate(startData));
        Date edate = DateUtils.getDayLast(DateUtils.stringToDate(endData));
        QFilter orgIdFilter_0 = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter startFilter = new QFilter("taxperiod", ">=", (Object)sdate);
        QFilter endFilter = new QFilter("taxperiod", "<=", (Object)edate);
        QFilter dataSourceFilter_0 = new QFilter("datasources", "=", (Object)"4");
        QFilter dataSourceFilter_1 = new QFilter("datasources", "=", (Object)"27");
        DynamicObjectCollection collection_0 = QueryServiceHelper.query((String)"til_jxdk_ncpjsdk_bill", (String)"entryentity.dataid", (QFilter[])new QFilter[]{orgIdFilter_0, startFilter, endFilter, dataSourceFilter_0});
        List zzsdataid = collection_0.stream().map(s -> s.getLong("entryentity.dataid")).distinct().collect(Collectors.toList());
        DynamicObjectCollection collection_1 = QueryServiceHelper.query((String)"til_jxdk_ncpjsdk_bill", (String)"entryentity.dataid", (QFilter[])new QFilter[]{orgIdFilter_0, startFilter, endFilter, dataSourceFilter_1});
        List qdzpdataid = collection_1.stream().map(s -> s.getLong("entryentity.dataid")).distinct().collect(Collectors.toList());
        if ("amount".equals(name)) {
            DynamicObject[] load_1;
            DynamicObject[] load_02;
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject dynamicObject : load_02 = BusinessDataServiceHelper.load((String)"rim_inv_electric", (String)"invoice_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", qdzpdataid)})) {
                BigDecimal invoice_amount = dynamicObject.getBigDecimal("invoice_amount");
                amount = amount.add(invoice_amount);
            }
            for (DynamicObject dynamicObject : load_1 = BusinessDataServiceHelper.load((String)"rim_inv_special", (String)"invoice_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", zzsdataid)})) {
                BigDecimal invoice_amount = dynamicObject.getBigDecimal("invoice_amount");
                amount = amount.add(invoice_amount);
            }
            return amount.toString();
        }
        BigDecimal taxamount = new BigDecimal(0);
        DynamicObject[] load_1 = load_0 = BusinessDataServiceHelper.load((String)"rim_inv_electric", (String)"effective_tax_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", qdzpdataid)});
        int n = load_1.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject dynamicObject = load_1[i];
            BigDecimal effective_tax_amount = dynamicObject.getBigDecimal("effective_tax_amount");
            taxamount = taxamount.add(effective_tax_amount);
        }
        for (DynamicObject dynamicObject : load_1 = BusinessDataServiceHelper.load((String)"rim_inv_special", (String)"effective_tax_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", zzsdataid)})) {
            BigDecimal effective_tax_amount = dynamicObject.getBigDecimal("effective_tax_amount");
            taxamount = taxamount.add(effective_tax_amount);
        }
        return taxamount.toString();
    }

    private String getYbAmount(String orgId, String startData, String endData, String name) {
        DynamicObject[] load_0;
        Date sdate = DateUtils.getDayFirst(DateUtils.stringToDate(startData));
        Date edate = DateUtils.getDayLast(DateUtils.stringToDate(endData));
        QFilter startFilter = new QFilter("taxperiod", ">=", (Object)sdate);
        QFilter endFilter = new QFilter("taxperiod", "<=", (Object)edate);
        QFilter dataSourceFilter_0 = new QFilter("datasources", "=", (Object)"4");
        QFilter dataSourceFilter_1 = new QFilter("datasources", "=", (Object)"27");
        QFilter orgIdFilter_1 = new QFilter("orgrow.collectorg", "=", (Object)orgId);
        QFilter taxTypeFilter = new QFilter("taxtype", "=", (Object)"zzs");
        QFilter effectDateFilter = new QFilter("effectdate", ">=", (Object)sdate);
        QFilter invalidDateFilter = new QFilter("invaliddate", "<", (Object)edate).or(new QFilter("invaliddate", "is null", null));
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        DynamicObjectCollection collection_2 = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.orgid", (QFilter[])new QFilter[]{orgIdFilter_1, taxTypeFilter, effectDateFilter, invalidDateFilter, statusFilter});
        List orglist = collection_2.stream().map(s -> s.getLong("orgrow.orgid")).distinct().collect(Collectors.toList());
        QFilter orgIdFilter_2 = new QFilter("org", "in", orglist);
        DynamicObjectCollection collection_3 = QueryServiceHelper.query((String)"til_jxdk_ncpjsdk_bill", (String)"entryentity.dataid", (QFilter[])new QFilter[]{orgIdFilter_2, startFilter, endFilter, dataSourceFilter_0});
        List ybzzsdataid = collection_3.stream().map(s -> s.getLong("entryentity.dataid")).distinct().collect(Collectors.toList());
        DynamicObjectCollection collection_4 = QueryServiceHelper.query((String)"til_jxdk_ncpjsdk_bill", (String)"entryentity.dataid", (QFilter[])new QFilter[]{orgIdFilter_2, startFilter, endFilter, dataSourceFilter_1});
        List ybqdzpdataid = collection_4.stream().map(s -> s.getLong("entryentity.dataid")).distinct().collect(Collectors.toList());
        if ("ybamount".equals(name)) {
            DynamicObject[] load_1;
            DynamicObject[] load_02;
            BigDecimal ybamount = BigDecimal.ZERO;
            for (DynamicObject dynamicObject : load_02 = BusinessDataServiceHelper.load((String)"rim_inv_electric", (String)"invoice_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", ybqdzpdataid)})) {
                BigDecimal invoice_amount = dynamicObject.getBigDecimal("invoice_amount");
                ybamount = ybamount.add(invoice_amount);
            }
            for (DynamicObject dynamicObject : load_1 = BusinessDataServiceHelper.load((String)"rim_inv_special", (String)"invoice_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", ybzzsdataid)})) {
                BigDecimal invoice_amount = dynamicObject.getBigDecimal("invoice_amount");
                ybamount = ybamount.add(invoice_amount);
            }
            return ybamount.toString();
        }
        BigDecimal ybtaxamount = BigDecimal.ZERO;
        DynamicObject[] load_1 = load_0 = BusinessDataServiceHelper.load((String)"rim_inv_electric", (String)"effective_tax_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", ybqdzpdataid)});
        int n = load_1.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject dynamicObject = load_1[i];
            BigDecimal invoice_amount = dynamicObject.getBigDecimal("effective_tax_amount");
            ybtaxamount = ybtaxamount.add(invoice_amount);
        }
        for (DynamicObject dynamicObject : load_1 = BusinessDataServiceHelper.load((String)"rim_inv_special", (String)"effective_tax_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", ybzzsdataid)})) {
            BigDecimal invoice_amount = dynamicObject.getBigDecimal("effective_tax_amount");
            ybtaxamount = ybtaxamount.add(invoice_amount);
        }
        return ybtaxamount.toString();
    }

    private void setFb5FjsfParams(String orgId, String startData, String endData, Map<String, String> param) {
        int i;
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter startFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate(startData));
        QFilter endFilter = new QFilter("enddate", "=", (Object)DateUtils.stringToDate(endData));
        QFilter declarationFilter = new QFilter("declaration", "=", (Object)"3");
        DynamicObjectCollection orgList = QueryServiceHelper.query((String)"tcvat_ybhz_zlb_jgfpb", (String)"suborg", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, declarationFilter}, (String)"seqx");
        List suborgList = orgList.stream().map(a -> a.getLong("suborg")).collect(Collectors.toList());
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainFjsfByOrgId(suborgList);
        Map<Object, Object> orgidMap = new HashMap();
        if (ObjectUtils.isNotEmpty((Object)result.getData())) {
            orgidMap = ((List)result.getData()).stream().filter(d -> EmptyCheckUtils.isNotEmpty(d.getDynamicObjectCollection("categoryentryentity"))).collect(Collectors.toMap(a -> a.getLong("taxorg.id"), b -> (DynamicObject)b.getDynamicObjectCollection("categoryentryentity").get(0), (m, n) -> m));
        }
        for (i = 0; i < orgList.size(); ++i) {
            if (null == orgList.get(i) || ((DynamicObject)orgList.get(i)).get("suborg") == null) continue;
            Long suborg = ((DynamicObject)orgList.get(i)).getLong("suborg");
            DynamicObject taxMain = (DynamicObject)orgidMap.get(suborg);
            String cswhjssenable1 = taxMain != null && ENABLE.equals(taxMain.getString(cswhjssenable)) ? ENABLE : "0";
            String jyffjenable1 = taxMain != null && "2".equals(taxMain.getString(jyffjenable)) ? ENABLE : "0";
            String dfjyffjenable1 = taxMain != null && "3".equals(taxMain.getString(dfjyffjenable)) ? ENABLE : "0";
            String orgplace = taxMain != null ? taxMain.getString("orgplace") : "";
            param.put("pm" + i, collectionMap.getOrDefault(orgplace, "cityarea"));
            param.put("ybhzcswhjss" + i, cswhjssenable1);
            param.put("ybhzjyffj" + i, jyffjenable1);
            param.put("ybhzdfjyffj" + i, dfjyffjenable1);
            param.put("ybhzcswhjsstaxrate" + i, ENABLE.equals(cswhjssenable1) ? this.getPolicyParams("CSWHJSS", startData, endData, String.valueOf(suborg)) : "0");
            param.put("ybhzjyffjtaxrate" + i, ENABLE.equals(jyffjenable1) ? this.getPolicyParams("JYFFJ", startData, endData, String.valueOf(suborg)) : "0");
            param.put("ybhzdfjyffjtaxrate" + i, ENABLE.equals(dfjyffjenable1) ? this.getPolicyParams("DFJYFJ", startData, endData, String.valueOf(suborg)) : "0");
        }
        for (i = orgList.size(); i < 10; ++i) {
            param.put("pm" + i, collectionMap.get("cityarea"));
        }
    }

    private String getPolicyParams(String param, String startdate, String enddate, String orgId) {
        List<String> paramList = AssistService.queryAssistParams(param, orgId, startdate, enddate);
        if (paramList.size() > 0) {
            return paramList.get(0);
        }
        return "0";
    }

    private boolean isHangkongOrg(String orgid, String startData, String endData) {
        QFilter orgFilter = new QFilter("orgrow.orgid", "=", (Object)Long.valueOf(orgid));
        QFilter summaryorgtypeFilter = new QFilter("summaryorgtype", "=", (Object)ENABLE);
        QFilter effectdateFilter = new QFilter("effectdate", "<=", (Object)DateUtils.stringToDate(startData));
        QFilter invaliddateFilter = new QFilter("invaliddate", ">=", (Object)DateUtils.stringToDate(endData)).or(QFilter.isNull((String)"invaliddate"));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tctb_org_group_latest", (String)"summaryorgtype,id", (QFilter[])new QFilter[]{orgFilter, summaryorgtypeFilter, effectdateFilter, invaliddateFilter});
        if (dynamicObject != null) {
            return ENABLE.equals(dynamicObject.getString("summaryorgtype"));
        }
        return false;
    }

    private void getOrgParams(String orgId, String startData, String endData, Map<String, String> param) {
        int i;
        QFilter declarationFilter;
        QFilter endFilter;
        QFilter startFilter;
        QFilter orgIdFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        DynamicObjectCollection orgList = QueryServiceHelper.query((String)"tcvat_ybhz_zlb_jgfpb", (String)"suborg", (QFilter[])new QFilter[]{orgIdFilter, startFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate(startData)), endFilter = new QFilter("enddate", "=", (Object)DateUtils.stringToDate(endData)), declarationFilter = new QFilter("declaration", "=", (Object)"3")}, (String)"seqx");
        if (EmptyCheckUtils.isNotEmpty(orgList)) {
            for (i = 0; i < orgList.size(); ++i) {
                if (null == orgList.get(i) || ((DynamicObject)orgList.get(i)).get("suborg") == null) continue;
                QFilter orgFilter = new QFilter("org", "=", ((DynamicObject)orgList.get(i)).get("suborg"));
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"unifiedsocialcode, taxpayer", (QFilter[])new QFilter[]{orgFilter});
                param.put("unifiedsocialcode" + i, dynamicObject.getString("unifiedsocialcode"));
                param.put("taxpayer" + i, dynamicObject.getString("taxpayer"));
            }
        }
        for (i = orgList.size(); i < 10; ++i) {
            param.put("unifiedsocialcode" + i, "");
            param.put("taxpayer" + i, "");
        }
    }

    protected String getCekcdgBqfseHj(String entityName, QFilter[] qFilters) {
        BigDecimal currentamount;
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityName, (String)"sum(currentamount) as currentamount", (QFilter[])qFilters);
        if (dynamicObject != null && (currentamount = dynamicObject.getBigDecimal("currentamount")) != null) {
            return currentamount.toPlainString();
        }
        return BigDecimal.ZERO.toPlainString();
    }

    protected String getCekcdgBqfseHjJzjtF(String entityName, QFilter[] qFilters) {
        ArrayList<QFilter> qFiltersList = new ArrayList<QFilter>(Arrays.asList(qFilters));
        QFilter jzjt = new QFilter("jzjt", "!=", (Object)ENABLE);
        qFiltersList.add(jzjt);
        return this.getCekcdgBqfseHj(entityName, qFiltersList.toArray(new QFilter[qFiltersList.size()]));
    }

    protected String getCekcdgBqfseHjJzjtS(String entityName, QFilter[] qFilters) {
        ArrayList<QFilter> qFiltersList = new ArrayList<QFilter>(Arrays.asList(qFilters));
        QFilter jzjt = new QFilter("jzjt", "=", (Object)ENABLE);
        qFiltersList.add(jzjt);
        return this.getCekcdgBqfseHj(entityName, qFiltersList.toArray(new QFilter[qFiltersList.size()]));
    }

    protected String getYbnsrSqsbbFb3Qmye(String preSbbid) {
        BigDecimal qmye;
        DynamicObject dynamicObject;
        if (StringUtil.isNotEmpty((CharSequence)preSbbid) && !"0".equals(preSbbid) && (dynamicObject = QueryServiceHelper.queryOne((String)"tcvat_ybnsr_fb3", (String)"sum(qmye) as qmye", (QFilter[])new QFilter(SBBID, "=", (Object)preSbbid).toArray())) != null && (qmye = dynamicObject.getBigDecimal("qmye")) != null) {
            return qmye.toPlainString();
        }
        return BigDecimal.ZERO.toPlainString();
    }
}

