/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.biz.impl;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.formula.biz.InitParams;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TcvatPrepayInitParams
extends InitParams {
    private static final String TYPE = "type";
    public static final String STARTDATA = "startDate";
    public static final String ENDDATA = "endDate";
    public static final String PROJECTID = "projectid";
    public static final String TAXORG = "taxorg";
    private static final String[] deleteKey = new String[]{"startDate", "endDate"};

    @Override
    public void deleteSelfCache(IPageCache cache) {
        for (String key : deleteKey) {
            cache.remove(key);
        }
    }

    @Override
    public Map<String, String> setBizParam(IPageCache cache, String type, String orgId, String startData, String endData) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(STARTDATA, startData);
        param.put("declareserialno", cache.get("declareserialno"));
        param.put("prepaytype", cache.get("prepaytype"));
        param.put(ENDDATA, endData);
        param.put(PROJECTID, cache.get(PROJECTID));
        param.put(TAXORG, cache.get(TAXORG));
        param.put(TYPE, ObjectUtils.notEqual((Object)cache.get("taxpayertype"), (Object)"xgmnsr") ? "0" : "1");
        param.put("projectAddress", this.addAddr(param, cache.get(PROJECTID)));
        DynamicObject dynamicObject = OrgChangeRecordUtil.loadChangeRecord(cache.get(TAXORG), DateUtils.stringToDate(startData), DateUtils.stringToDate(endData));
        String taxPayType = dynamicObject != null ? dynamicObject.getString("taxpayertype") : cache.get("taxpayertype");
        param.put("taxmaininfo", "ybnsr".equals(taxPayType) ? "1" : "0");
        DynamicObject taxMainInfo = TaxBaseDataUtils.getTaxMainInfo(Long.valueOf(cache.get(TAXORG)));
        if (null != taxMainInfo) {
            String registerTypeNumber;
            String string = registerTypeNumber = taxMainInfo.getDynamicObject("registertype") != null ? taxMainInfo.getDynamicObject("registertype").getString("number") : "";
            if ("410".equals(registerTypeNumber) || "411".equals(registerTypeNumber) || "412".equals(registerTypeNumber) || "413".equals(registerTypeNumber)) {
                param.put("individual", "1");
            } else {
                param.put("individual", "0");
            }
        }
        return param;
    }

    private String addAddr(Map<String, String> param, String projectId) {
        if (StringUtil.isEmpty((CharSequence)projectId) || "0".equals(projectId)) {
            return "";
        }
        DynamicObject currentObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(projectId), (String)"tcvat_prepay_project_info");
        param.put("projectname", currentObj.getLocaleString("name").getLocaleValue());
        String fieldId = (String)currentObj.get("projectzone");
        if (!StringUtil.isBlank((CharSequence)fieldId)) {
            DynamicObject addr = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"fullname", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(fieldId)).toArray());
            return addr.getString("fullname");
        }
        return "";
    }
}

