/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.formula.context.AbstractContent;
import kd.taxc.bdtaxr.common.refactor.formula.cal.CalculateService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.threadpools.ThreadTaskService;

public class CalFormulaContent
extends AbstractContent {
    private static Log logger = LogFactory.getLog(CalFormulaContent.class);

    public CalFormulaContent() {
    }

    public CalFormulaContent(Map<String, String> param) {
        this.param = param;
    }

    public Map<String, String> initCal(Map<String, String> data, Map<String, String> param, Map<String, FormulaVo> formulas, Map<String, String> sql) {
        long time = System.currentTimeMillis();
        this.formulas = formulas;
        this.data = data;
        this.param = param;
        this.allEntityFieldByType = TemplateUtils.getAllEntityByType(param.getOrDefault("formulaType", ""), "#");
        this.variableKey = new HashMap();
        logger.info("\u5f00\u59cb\u8ba1\u7b97--2--" + (System.currentTimeMillis() - time));
        ThreadTaskService.executorSql(this, sql);
        logger.info("\u5f00\u59cb\u8ba1\u7b97--3--" + (System.currentTimeMillis() - time));
        for (Map.Entry<String, FormulaVo> formula : formulas.entrySet()) {
            this.calculate(formula.getValue());
        }
        logger.info("\u5f00\u59cb\u8ba1\u7b97--4--" + (System.currentTimeMillis() - time));
        logger.info("\u5f00\u59cb\u8ba1\u7b97--5--" + (System.currentTimeMillis() - time));
        return data;
    }

    public Map<String, String> calcUnknownKeys(Map<String, String> data, Map<String, String> param, Map<String, FormulaVo> formulas) {
        this.formulas = formulas;
        this.data = data;
        this.param = param;
        this.allEntityFieldByType = TemplateUtils.getAllEntityByType(param.getOrDefault("formulaType", ""), "#");
        this.variableKey = new HashMap();
        for (Map.Entry<String, FormulaVo> formula : formulas.entrySet()) {
            if (data.get(formula.getKey()) != null) continue;
            this.calculate(formula.getValue());
        }
        return data;
    }

    public Map<String, String> cal(Map<String, String> data, Map<String, String> param, Map<String, FormulaVo> formulas, Map<String, Map<String, String>> classformula, String key) {
        this.data = data;
        this.param = param;
        this.formulas = formulas;
        this.allEntityFieldByType = TemplateUtils.getAllEntityByType(param.getOrDefault("formulaType", ""), "#");
        this.variableKey = new HashMap();
        this.calValues(classformula, formulas, key);
        this.calVariableFormulaKey(formulas);
        return data;
    }

    private void calValues(Map<String, Map<String, String>> classformula, Map<String, FormulaVo> formulas, String key) {
        Map<String, String> calFormula = classformula.get(key);
        if (null != calFormula && calFormula.size() > 0) {
            for (String k : calFormula.keySet()) {
                FormulaVo f = formulas.get(k);
                if (null == f) continue;
                this.getVariableKey().put(f.getFormulaKey(), f.getFormulaKey());
                this.calValues(classformula, formulas, f.getFormulaKey());
            }
        }
    }

    private void calVariableFormulaKey(Map<String, FormulaVo> formulas) {
        Map<String, String> map = this.getVariableKey();
        HashSet<String> set = new HashSet<String>(map.keySet());
        for (String key : set) {
            FormulaVo f = formulas.get(key);
            if (null == f) continue;
            this.calculate(f);
        }
    }

    @Override
    public String calculate(FormulaVo formulaVo) {
        logger.info("\u5f00\u59cb\u6267\u884cCalFormulaContext.calculate\uff0cformulaKey={},\u539fformula={}", (Object)formulaVo.getFormulaKey(), (Object)formulaVo.getFormula());
        String f = this.parse(formulaVo);
        logger.info("\u6267\u884cCalFormulaContext.calculate \uff0cformulaKey={},\u66ff\u6362\u540e\u7684formula={}", (Object)formulaVo.getFormulaKey(), (Object)f);
        String value = CalculateService.calculate(f, formulaVo.getFormulaType(), this.getAllEntityFieldByType().get(formulaVo.getFormulaKey()));
        this.data.put(formulaVo.getFormulaKey(), value);
        logger.info("\u6267\u884cCalFormulaContext.calculate \uff0cformulaKey={},\u6700\u7ec8\u516c\u5f0f\u7684\u503cvalue={}", (Object)formulaVo.getFormulaKey(), (Object)value);
        return (String)this.data.get(formulaVo.getFormulaKey());
    }
}

