/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.formula.context.AbstractContent;
import kd.taxc.bdtaxr.common.refactor.formula.cal.CalculateService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseUtils;

public class CheckFormulaContent
extends AbstractContent {
    public List<Map<String, String>> cal(Map<String, String> data, Map<String, String> param, List<FormulaVo> formulas) {
        this.data = data;
        this.param = param;
        this.variableKey = new HashMap();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (FormulaVo formula : formulas) {
            if (!this.calculate(formula).equals("0")) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("jump", formula.getFormulaKey().replaceAll("#", "_"));
            map.put("title", formula.getTitle());
            map.put("content", this.calculateContent(formula.getContent()));
            map.put("items", formula.getItems() != null ? formula.getItems().replaceAll("#", "_") : "");
            list.add(map);
        }
        return list;
    }

    private String calculateContent(String content) {
        List<String> contentList = ParseUtils.parseformulaContent(content);
        Iterator<String> iterator = contentList.iterator();
        while (iterator.hasNext()) {
            String formula;
            String temp = formula = iterator.next();
            List<String> list = ParseUtils.parseformula(formula);
            for (String f : list) {
                Map<String, String> map = ParseUtils.parseFormulaZKH(f);
                String value = this.getValue(map, null);
                temp = temp.replace(f, value);
            }
            temp = temp.replace("{F[", "").replace("]}", "");
            content = this.replaceFirst(formula, content, temp);
        }
        return content;
    }

    private String replaceFirst(String formula, String content, String temp) {
        int index = content.indexOf(formula);
        int end = index + formula.length();
        StringBuilder sb = new StringBuilder();
        return sb.append(content.substring(0, index)).append(CalculateService.calculateOld(temp)).append(content.substring(end)).toString();
    }

    @Override
    public String calculate(FormulaVo formulaVo) {
        String ret = this.parse(formulaVo);
        if (CalculateService.checkOld(ret)) {
            return "1";
        }
        return "0";
    }

    @Override
    public String getValue(Map<String, String> map, FormulaVo formulaVo) {
        String values = super.getValue(map, formulaVo);
        if (null != formulaVo && "Q".equals(ParseUtils.getType(map))) {
            String items = formulaVo.getItems();
            if (StringUtils.isEmpty((String)items)) {
                formulaVo.setItems(ParseUtils.getValue(map));
            } else {
                formulaVo.setItems(items + "," + ParseUtils.getValue(map));
            }
        }
        return values;
    }
}

