/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.formula.db.formula.QueryFormulaService;
import kd.taxc.bdtaxr.common.formula.parse.ParseFormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.utils.JsonUtils;

public class CacheFormulaService {
    private static final String INITCACHEFORMULAS = "initcacheFormulas";
    private static final String QCACHEFORMULAS = "qcacheFormulas";
    private static final String SCACHEFORMULAS = "scacheFormulas";
    private static final String CHECKFORMULA = "checkFormula";
    private static final String[] deletekey = new String[]{"initcacheFormulas", "qcacheFormulas", "scacheFormulas", "checkFormula"};

    public static void deleteCache(IPageCache cache) {
        for (String key : deletekey) {
            cache.remove(key);
        }
    }

    private static Map<String, FormulaVo> getFormulas(IPageCache cache, String templateId) {
        String json = cache.get(INITCACHEFORMULAS);
        if (StringUtils.isEmpty((String)json)) {
            return CacheFormulaService.paserFormula(cache, templateId).getFormulas();
        }
        return JsonUtils.strToMapList(json);
    }

    private static Map<String, Map<String, String>> getQformulas(IPageCache cache, String templateId) {
        String json = cache.get(QCACHEFORMULAS);
        if (StringUtils.isEmpty((String)json)) {
            return CacheFormulaService.paserFormula(cache, templateId).getQformulas();
        }
        return JsonUtils.strToMapMap(json);
    }

    private static Map<String, String> getSformulas(IPageCache cache, String templateId) {
        String json = cache.get(SCACHEFORMULAS);
        if (StringUtils.isEmpty((String)json) || Objects.equals("{}", json)) {
            return CacheFormulaService.paserFormula(cache, templateId).getSformulas();
        }
        return JsonUtils.strToMap(json);
    }

    private static ParseFormulaService paserFormula(IPageCache cache, String templateId) {
        ParseFormulaService p = new ParseFormulaService(templateId);
        p.parse();
        if (null != cache) {
            cache.put(INITCACHEFORMULAS, JsonUtils.mapToStr(p.getFormulas()));
            cache.put(QCACHEFORMULAS, JsonUtils.mapToStr(p.getQformulas()));
            cache.put(SCACHEFORMULAS, JsonUtils.mapToStr(p.getSformulas()));
        }
        return p;
    }

    public static Map<String, FormulaVo> getFormulas(IPageCache cache) {
        CacheUtils.buildTemplateId(cache);
        return CacheFormulaService.getFormulas(cache, CacheUtils.getInstance().getTemplateId(cache));
    }

    public static Map<String, Map<String, String>> getQformulas(IPageCache cache) {
        CacheUtils.buildTemplateId(cache);
        return CacheFormulaService.getQformulas(cache, CacheUtils.getInstance().getTemplateId(cache));
    }

    public static Map<String, String> getSformulas(IPageCache cache) {
        CacheUtils.buildTemplateId(cache);
        return CacheFormulaService.getSformulas(cache, CacheUtils.getInstance().getTemplateId(cache));
    }

    public static Map<String, String> getFormulaTemplate(String templateId) {
        Map<String, FormulaVo> map = CacheFormulaService.paserFormula(null, templateId).getFormulas();
        HashMap<String, String> data = new HashMap<String, String>(map.size());
        for (Map.Entry<String, FormulaVo> entry : map.entrySet()) {
            data.put(entry.getKey(), entry.getValue().getFormula());
        }
        return data;
    }

    public static void removeCheckCache(IPageCache cache) {
        cache.remove(CHECKFORMULA);
    }

    public static List<FormulaVo> queryCheckFormulas(IPageCache cache) {
        List<FormulaVo> formulas = null;
        String checkformula = cache.get(CHECKFORMULA);
        if (StringUtils.isEmpty((String)checkformula)) {
            CacheUtils.buildTemplateId(cache);
            formulas = QueryFormulaService.queryDBFormulaType(CacheUtils.getInstance().getFormulaType(cache), CacheUtils.getInstance().getStartData(cache), CacheUtils.getInstance().getEndData(cache), cache.get("templateid"));
            cache.put(CHECKFORMULA, JsonUtils.mapToStr(formulas));
        } else {
            formulas = JsonUtils.strToList(checkformula);
        }
        return formulas;
    }

    public static Map<String, FormulaVo> queryCellConfig(String type, String startData, String endData, String templateid) {
        List<FormulaVo> formulas = QueryFormulaService.queryDBCellConfig(type, startData, endData, templateid);
        HashMap<String, FormulaVo> map = new HashMap<String, FormulaVo>(formulas.size());
        for (FormulaVo f : formulas) {
            map.put(f.getFormulaKey(), f);
        }
        return map;
    }
}

