/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class AttachmentHelper {
    private static final String T_TCTB_DECLARE_MAIN_ATT = "t_tctb_declare_main_att";
    public static final String BD_ATTACHMENT = "bd_attachment";
    private static final List<String> DRAFT_ATTACHMENT_APP = Lists.newArrayList((Object[])new String[]{"tcvat", "tccit"});
    private static final Set<String> ATTACHMENT_SHOW_LIST = new HashSet<String>();
    private static final List<String> ATTACHMENT_SHOW_TYPES = Lists.newArrayList((Object[])new String[]{"zzs", "qysds", "yhs", "fjsf", "fcs", "fcscztdsys", "cztdsys", "xfs", "tcept", "tcrt", "yys", "tcvvt", "ccxws", "tcwat", "tvpt", "tcnfep", "qtsf_ty", "whsyjsf", "totf_cjrjybzj", "Overseas", "cwbs", "jzjt_tssqb"});

    public static boolean isDeclareAttachmentType(String templateType) {
        return templateType == null || !templateType.startsWith("draft") && ATTACHMENT_SHOW_LIST.contains(templateType);
    }

    public static boolean isDraftAttachmentType(String appid) {
        return DRAFT_ATTACHMENT_APP.contains(appid);
    }

    public static String queryPermission(String permItemId, Long userId, String appid, String formId) {
        Boolean hasPermOrgResult = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)appid, (String)formId, (String)permItemId);
        return hasPermOrgResult != null && hasPermOrgResult != false ? "1" : "0";
    }

    public static String queryPermissionByOrg(String permItemId, Long userId, Long orgId, String appid, String formId) {
        return PermissionUtils.getPermByUserIdOrg(orgId, userId, appid, formId, permItemId) != false ? "1" : "0";
    }

    public static void updateAttachmentField(List<Map<String, Object>> attachments, DynamicObjectCollection attCol, String appId, String formId, Object pkId) {
        String uid;
        List bdAttachments = AttachmentFieldServiceHelper.saveAttachments((String)formId, (String)"", attachments);
        Set uidSet = bdAttachments.stream().map(a -> a.getString("uid")).collect(Collectors.toSet());
        DynamicObject[] dyColl = BusinessDataServiceHelper.load((String)BD_ATTACHMENT, (String)"id,name,status,sort,uid,url,creator,description,createtime,tempfile,", (QFilter[])new QFilter[]{new QFilter("uid", "in", uidSet)});
        HashMap<String, DynamicObject> uidHashMap = new HashMap<String, DynamicObject>();
        if (!EmptyCheckUtils.isEmpty(dyColl)) {
            for (DynamicObject bdAttachment : dyColl) {
                String tempfile = bdAttachment.getString("tempfile");
                uid = bdAttachment.getString("uid");
                if ("0".equalsIgnoreCase(tempfile)) {
                    String url = bdAttachment.getString("url");
                    String fileName = bdAttachment.getString("name");
                    String persistenceUrl = AttachmentServiceHelper.saveTempToFileService((String)url, (String)appId, (String)formId, (Object)pkId, (String)fileName, (boolean)false, (boolean)false);
                    bdAttachment.set("url", (Object)persistenceUrl);
                    bdAttachment.set("tempfile", (Object)1);
                }
                uidHashMap.put(uid, bdAttachment);
            }
        }
        Map<Object, Map> infoMap = attachments.stream().collect(Collectors.toMap(a -> a.get("uid"), b -> b, (m, n) -> m));
        Iterator iterator = attCol.iterator();
        ArrayList<Object> deleteList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            DynamicObject fbasedataid = dynamicObject.getDynamicObject("fbasedataid");
            if (fbasedataid != null) {
                uid = fbasedataid.getString("uid");
                if (!uidHashMap.containsKey(uid)) {
                    deleteList.add(fbasedataid.get("id"));
                } else {
                    DynamicObject att = (DynamicObject)uidHashMap.get(uid);
                    Map objectMap = infoMap.get(uid);
                    if (att != null && objectMap != null) {
                        att.set("name", (Object)objectMap.getOrDefault("name", ""));
                        att.set("description", (Object)objectMap.getOrDefault("description", ""));
                    }
                }
            }
            iterator.remove();
        }
        if (!EmptyCheckUtils.isEmpty(dyColl)) {
            Arrays.stream(dyColl).forEach(a -> attCol.addNew().set("fbasedataid", a.get("id")));
            AttachmentFieldServiceHelper.removeAttachmentsByAttPkIds((String)formId, (String)T_TCTB_DECLARE_MAIN_ATT, (Object[])deleteList.toArray());
            SaveServiceHelper.save((DynamicObject[])dyColl);
        }
    }

    static {
        Set collect = TemplateTypeConstant.getTypeMap().entrySet().stream().filter(e -> ATTACHMENT_SHOW_TYPES.contains(e.getKey())).map(e -> (String[])e.getValue()).flatMap(a -> Arrays.stream(a)).collect(Collectors.toSet());
        ATTACHMENT_SHOW_LIST.addAll(collect);
    }
}

