/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class ProvisionOpHelper {
    public static Long getAccountOrg(DynamicObject draftDynamicObject) {
        Long taxorgId = draftDynamicObject.getLong("org.id");
        List<Long> orgTakeRelation = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(taxorgId), draftDynamicObject.getDate("skssqq"), draftDynamicObject.getDate("skssqz"));
        if (ObjectUtils.isNotEmpty(orgTakeRelation)) {
            HashSet<Long> set = new HashSet<Long>(orgTakeRelation);
            if (set.size() == 1 && !((Long)set.stream().findFirst().get()).equals(0L)) {
                return (Long)set.stream().findFirst().get();
            }
            if (set.size() >= 2) {
                Long org = 0L;
                for (Long id : set) {
                    if (id.equals(taxorgId)) continue;
                    org = id;
                    break;
                }
                return org;
            }
            return null;
        }
        return null;
    }

    public static String getTemplateType(String number) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_template_type", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        String name = TemplateTypeConstant.getNsrtypemap().get(number);
        return dynamicObject != null ? dynamicObject.getString("name") : (name != null ? name : ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u8ba1\u63d0\u4e00\u822c\u7eb3\u7a0e\u4eba\u5e95\u7a3f", (String)"ProvisionOpHelper_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
    }

    public static Map<Boolean, Map<Long, String>> requestZzsGenerateProvisionBillService(List<Long> idList) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)TaxAppEnum.TCVAT.getAppid(), (String)"GenerateProvisionBillService", (String)"generateProvisionBill", (Object[])new Object[]{idList});
    }

    public static void getLogResultMessage(OperationResult operationResult, StringBuilder successMessage, StringBuilder failMessage) {
        List successPkIds = operationResult.getSuccessPkIds();
        Map billNos = operationResult.getBillNos();
        Set entries = billNos.entrySet();
        for (Map.Entry entry : entries) {
            if (successPkIds.contains(Long.valueOf(entry.getKey().toString()))) {
                if (successMessage.length() > 0) {
                    successMessage.append(" ");
                }
                successMessage.append((String)entry.getValue());
                continue;
            }
            if (failMessage.length() > 0) {
                failMessage.append(" ");
            }
            failMessage.append((String)entry.getValue());
        }
    }
}

