/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class QueryInHelper {
    private static final int GROUP_SIZE = 1000;

    public static List<DynamicObject> queryBySplitFilter(String entityid, String fields, List<QFilter> inQfilters, List<QFilter> otherQfilters) {
        return QueryInHelper.query(entityid, fields, inQfilters, otherQfilters, true);
    }

    public static DynamicObject[] loadByInfilter(String entityid, String fields, List<QFilter> inQfilters, List<QFilter> otherQfilters) {
        List<DynamicObject> query = QueryInHelper.query(entityid, fields, inQfilters, otherQfilters, false);
        return query.toArray(new DynamicObject[query.size()]);
    }

    private static void findFieldRecursion(QFilter inQfilter, Set<String> getFields) {
        String property = inQfilter.getProperty();
        if (!("id".equals(property) || "1".equals(property) || "0".equals(property))) {
            getFields.add(property);
        }
        List nests = inQfilter.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            QueryInHelper.findFieldRecursion(nest.getFilter(), getFields);
        }
    }

    private static List<DynamicObject> query(String entityid, String fields, List<QFilter> inQfilters, List<QFilter> otherQfilters, boolean isQuery) {
        HashSet<String> getFields = new HashSet<String>(4);
        for (QFilter inQfilter : inQfilters) {
            QueryInHelper.findFieldRecursion(inQfilter, getFields);
        }
        String inFields = getFields.stream().collect(Collectors.joining(","));
        inFields = inFields != null && inFields.length() > 0 ? "id," + inFields : "id";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.taxc.bdtaxr.common.refactor.template.TemplateUtils.query", (String)entityid, (String)inFields, (QFilter[])otherQfilters.toArray(new QFilter[otherQfilters.size()]), (String)"id asc");
        String filterStr = inQfilters.stream().map(a -> a.toString()).collect(Collectors.joining(" and "));
        DataSet resultSet = dataSet.filter(filterStr);
        ArrayList<Object> ids = new ArrayList<Object>();
        if (!resultSet.isEmpty()) {
            while (resultSet.hasNext()) {
                Row next = resultSet.next();
                ids.add(next.get("id"));
            }
            return QueryInHelper.batchQuery(entityid, fields, "id", ids, isQuery);
        }
        return new ArrayList<DynamicObject>();
    }

    public static List<DynamicObject> batchQuery(String entityid, String fields, String inField, List<Object> inValues) {
        return QueryInHelper.batchQuery(entityid, fields, inField, inValues, true);
    }

    private static List<DynamicObject> batchQuery(String entityid, String fields, String inField, List<Object> inValues, boolean isQuery) {
        List partition = Lists.partition(inValues, (int)1000);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(inValues.size());
        for (List invalueSubList : partition) {
            if (isQuery) {
                DynamicObjectCollection query = QueryServiceHelper.query((String)entityid, (String)fields, (QFilter[])new QFilter(inField, "in", (Object)invalueSubList).toArray());
                result.addAll((Collection<DynamicObject>)query);
                continue;
            }
            if (isQuery || !inField.equals("id")) continue;
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])invalueSubList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityid));
            result.addAll(Arrays.stream(load).collect(Collectors.toList()));
        }
        return result;
    }
}

