/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.SourceRelationConstant;
import kd.taxc.bdtaxr.common.helper.SourceRelationHelper;
import kd.taxc.bdtaxr.common.taxsource.ITaxSourceOperator;
import kd.taxc.bdtaxr.common.taxsource.TaxSourceOperatorFactory;
import kd.taxc.bdtaxr.common.taxsource.delete.IDeleteService;
import kd.taxc.bdtaxr.common.taxsource.save.ISaveService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import org.apache.commons.collections.CollectionUtils;

public class SourceOperateHelper {
    public static void saveSourceEntity(String templateType, String sbbid) {
        if (EmptyCheckUtils.isNotEmpty(sbbid)) {
            Map<String, List<DynamicObject>> relationsMap = SourceRelationHelper.queryRelationsGroupByRelationType(templateType);
            for (Map.Entry<String, List<DynamicObject>> entry : relationsMap.entrySet()) {
                String relationType = entry.getKey();
                ITaxSourceOperator sourceOperator = TaxSourceOperatorFactory.createService(relationType);
                ISaveService saveService = sourceOperator.createSaveService();
                List<DynamicObject> dynamicObjects = entry.getValue();
                saveService.saveSourceData(Long.parseLong(sbbid), dynamicObjects);
            }
        }
    }

    public static void saveSourceTemporaryEntity(String templateType, String sbbid) {
        if (EmptyCheckUtils.isNotEmpty(sbbid)) {
            Map<String, List<DynamicObject>> relationsMap = SourceRelationHelper.queryRelationsGroupByRelationType(templateType);
            for (Map.Entry<String, List<DynamicObject>> entry : relationsMap.entrySet()) {
                String relationType = entry.getKey();
                ITaxSourceOperator sourceOperator = TaxSourceOperatorFactory.createService(relationType);
                ISaveService saveService = sourceOperator.createSaveService();
                List<DynamicObject> dynamicObjects = entry.getValue();
                saveService.saveTemporarySourceData(Long.parseLong(sbbid), dynamicObjects);
            }
        }
    }

    public static void deleteSourceEntity(String templateType, Long sbbid) {
        if (EmptyCheckUtils.isNotEmpty(sbbid)) {
            Map<String, List<DynamicObject>> relationsMap = SourceRelationHelper.queryRelationsGroupByRelationType(templateType);
            for (Map.Entry<String, List<DynamicObject>> entry : relationsMap.entrySet()) {
                String relationType = entry.getKey();
                ITaxSourceOperator sourceOperator = TaxSourceOperatorFactory.createService(relationType);
                IDeleteService deleteService = sourceOperator.createDeleteService();
                List<DynamicObject> dynamicObjects = entry.getValue();
                deleteService.deleteSourceData(sbbid, dynamicObjects);
            }
        }
    }

    public static void deleteSourceTpEntity(String templateType, Long sbbid) {
        SourceOperateHelper.deleteSourceTpEntity(templateType, sbbid, null);
    }

    public static void deleteSourceTpEntity(String templateType, Long sbbid, String excludeEntity) {
        if (EmptyCheckUtils.isNotEmpty(sbbid)) {
            Map<String, List<DynamicObject>> relationsMap = SourceRelationHelper.queryRelationsGroupByRelationType(templateType);
            for (Map.Entry<String, List<DynamicObject>> entry : relationsMap.entrySet()) {
                String relationType = entry.getKey();
                ITaxSourceOperator sourceOperator = TaxSourceOperatorFactory.createService(relationType);
                IDeleteService deleteService = sourceOperator.createDeleteService();
                List<DynamicObject> dynamicObjects = entry.getValue();
                deleteService.deleteTemporarySourceData(sbbid, dynamicObjects, excludeEntity);
            }
        }
    }

    public static void deleteSourceEntityByNumber(String relationNumber, Long sbbid) {
        DynamicObject sourceRelation = BusinessDataServiceHelper.loadSingleFromCache((String)"bdtaxr_source_relation", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)relationNumber)});
        if (sourceRelation != null) {
            String relationType = sourceRelation.getString("relationtype");
            ITaxSourceOperator sourceOperator = TaxSourceOperatorFactory.createService(relationType);
            IDeleteService deleteService = sourceOperator.createDeleteService();
            deleteService.deleteSourceData(sbbid, Collections.singletonList(sourceRelation));
        }
    }

    public static void deleteSourceTpEntityByNumber(String relationNumber, Long sbbid) {
        DynamicObject sourceRelation = BusinessDataServiceHelper.loadSingleFromCache((String)"bdtaxr_source_relation", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)relationNumber)});
        if (sourceRelation != null) {
            String relationType = sourceRelation.getString("relationtype");
            ITaxSourceOperator sourceOperator = TaxSourceOperatorFactory.createService(relationType);
            IDeleteService deleteService = sourceOperator.createDeleteService();
            deleteService.deleteTemporarySourceData(sbbid, Collections.singletonList(sourceRelation));
        }
    }

    public static void saveMappingData(String taxsourcetype, Long sbbid, List<DynamicObject> sourceList) {
        SourceOperateHelper.saveMappingData(taxsourcetype, null, sbbid, sourceList);
    }

    public static void saveMappingData(String taxsourcetype, String taxtype, Long sbbid, List<DynamicObject> sourceList) {
        if (CollectionUtils.isNotEmpty(sourceList)) {
            Object[] ids = sourceList.stream().map(s -> s.getLong("id")).toArray();
            ArrayList<DynamicObject> mappingList = new ArrayList<DynamicObject>(ids.length);
            for (Object id : ids) {
                DynamicObject mappingObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)SourceRelationConstant.BDTAXR_SOURCE_MAPPING));
                mappingObj.set("taxsourcetype", (Object)taxsourcetype);
                mappingObj.set("taxsourceid", id);
                mappingObj.set("sbbid", (Object)sbbid);
                if (EmptyCheckUtils.isNotEmpty(taxtype)) {
                    mappingObj.set("taxtype", (Object)taxtype);
                }
                mappingList.add(mappingObj);
            }
            SaveServiceHelper.save((DynamicObject[])mappingList.toArray(new DynamicObject[0]));
        }
    }

    public static List<Long> queryTaxSourceIds(String taxsourcetype, Long sbbid) {
        QFilter q1 = new QFilter("sbbid", "=", (Object)sbbid);
        QFilter q2 = new QFilter("taxsourcetype", "=", (Object)taxsourcetype);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)SourceRelationConstant.BDTAXR_SOURCE_MAPPING, (String)"taxsourcetype,taxsourceid,sbbid", (QFilter[])new QFilter[]{q1, q2});
        return dynamicObjects.stream().map(d -> d.getLong("taxsourceid")).collect(Collectors.toList());
    }
}

